/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ripper;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ripper.RipperParser;
import org.jruby.ext.ripper.RipperParserBase;
import org.jruby.ext.ripper.SyntaxException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.lexer.ByteListLexerSource;
import org.jruby.lexer.GetsLexerSource;
import org.jruby.lexer.LexerSource;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyRipper
extends RubyObject {
    private RipperParserBase parser = null;
    private IRubyObject filename = null;
    private boolean parseStarted = false;

    public static void initRipper(Ruby runtime) {
        RubyClass ripper2 = runtime.defineClass("Ripper", runtime.getObject(), new ObjectAllocator(){

            @Override
            public IRubyObject allocate(Ruby runtime, RubyClass klazz) {
                return new RubyRipper(runtime, klazz);
            }
        });
        ripper2.defineConstant("SCANNER_EVENT_TABLE", RubyRipper.createScannerEventTable(runtime, ripper2));
        ripper2.defineConstant("PARSER_EVENT_TABLE", RubyRipper.createParserEventTable(runtime, ripper2));
        ripper2.defineAnnotatedMethods(RubyRipper.class);
    }

    private static IRubyObject createScannerEventTable(Ruby runtime, RubyClass ripper2) {
        RubyHash hash2 = new RubyHash(runtime);
        hash2.fastASet(runtime.newSymbol("CHAR"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("__end__"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("backref"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("backtick"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("comma"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("comment"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("const"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("cvar"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("embdoc"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("embdoc_beg"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("embdoc_end"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("embexpr_beg"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("embexpr_end"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("embvar"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("float"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("gvar"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("heredoc_beg"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("heredoc_end"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("ident"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("ignored_nl"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("imaginary"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("int"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("ivar"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("kw"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("label"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("label_end"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("lbrace"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("lbracket"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("lparen"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("nl"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("op"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("period"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("qsymbols_beg"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("qwords_beg"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("rational"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("rbrace"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("rbracket"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("regexp_beg"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("regexp_end"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("rparen"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("semicolon"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("sp"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("symbeg"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("symbols_beg"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("tlambda"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("tlambeg"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("tstring_beg"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("tstring_content"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("tstring_end"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("words_beg"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("words_sep"), runtime.newFixnum(1));
        return hash2;
    }

    private static IRubyObject createParserEventTable(Ruby runtime, RubyClass ripper2) {
        RubyHash hash2 = new RubyHash(runtime);
        hash2.fastASet(runtime.newSymbol("BEGIN"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("END"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("alias"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("alias_error"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("aref"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("aref_field"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("arg_ambiguous"), runtime.newFixnum(0));
        hash2.fastASet(runtime.newSymbol("arg_paren"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("args_add"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("args_add_block"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("args_add_star"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("args_new"), runtime.newFixnum(0));
        hash2.fastASet(runtime.newSymbol("array"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("assign"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("assign_error"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("assoc_new"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("assoc_splat"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("assoclist_from_args"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("bare_assoc_hash"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("begin"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("binary"), runtime.newFixnum(3));
        hash2.fastASet(runtime.newSymbol("block_var"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("block_var_add_block"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("block_var_add_star"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("blockarg"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("bodystmt"), runtime.newFixnum(4));
        hash2.fastASet(runtime.newSymbol("brace_block"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("break"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("call"), runtime.newFixnum(3));
        hash2.fastASet(runtime.newSymbol("case"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("class"), runtime.newFixnum(3));
        hash2.fastASet(runtime.newSymbol("class_name_error"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("command"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("command_call"), runtime.newFixnum(4));
        hash2.fastASet(runtime.newSymbol("const_path_field"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("const_path_ref"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("const_ref"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("def"), runtime.newFixnum(3));
        hash2.fastASet(runtime.newSymbol("defined"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("defs"), runtime.newFixnum(5));
        hash2.fastASet(runtime.newSymbol("do_block"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("dot2"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("dot3"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("dyna_symbol"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("else"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("elsif"), runtime.newFixnum(3));
        hash2.fastASet(runtime.newSymbol("ensure"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("excessed_comma"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("fcall"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("field"), runtime.newFixnum(3));
        hash2.fastASet(runtime.newSymbol("for"), runtime.newFixnum(3));
        hash2.fastASet(runtime.newSymbol("hash"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("heredoc_dedent"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("if"), runtime.newFixnum(3));
        hash2.fastASet(runtime.newSymbol("if_mod"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("ifop"), runtime.newFixnum(3));
        hash2.fastASet(runtime.newSymbol("lambda"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("magic_comment"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("massign"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("method_add_arg"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("method_add_block"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("mlhs_add"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("mlhs_add_star"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("mlhs_new"), runtime.newFixnum(0));
        hash2.fastASet(runtime.newSymbol("mlhs_paren"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("module"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("mrhs_add"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("mrhs_add_star"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("mrhs_new"), runtime.newFixnum(0));
        hash2.fastASet(runtime.newSymbol("mrhs_new_from_args"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("next"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("opassign"), runtime.newFixnum(3));
        hash2.fastASet(runtime.newSymbol("operator_ambiguous"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("param_error"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("params"), runtime.newFixnum(7));
        hash2.fastASet(runtime.newSymbol("paren"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("parse_error"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("program"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("qsymbols_add"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("qsymbols_new"), runtime.newFixnum(0));
        hash2.fastASet(runtime.newSymbol("qwords_add"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("qwords_new"), runtime.newFixnum(0));
        hash2.fastASet(runtime.newSymbol("redo"), runtime.newFixnum(0));
        hash2.fastASet(runtime.newSymbol("regexp_add"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("regexp_literal"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("regexp_new"), runtime.newFixnum(0));
        hash2.fastASet(runtime.newSymbol("rescue"), runtime.newFixnum(4));
        hash2.fastASet(runtime.newSymbol("rescue_mod"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("rest_param"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("retry"), runtime.newFixnum(0));
        hash2.fastASet(runtime.newSymbol("return"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("return0"), runtime.newFixnum(0));
        hash2.fastASet(runtime.newSymbol("sclass"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("stmts_add"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("stmts_new"), runtime.newFixnum(0));
        hash2.fastASet(runtime.newSymbol("string_add"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("string_concat"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("string_content"), runtime.newFixnum(0));
        hash2.fastASet(runtime.newSymbol("string_dvar"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("string_embexpr"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("string_literal"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("super"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("symbol"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("symbol_literal"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("symbols_add"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("symbols_new"), runtime.newFixnum(0));
        hash2.fastASet(runtime.newSymbol("top_const_field"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("top_const_ref"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("unary"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("undef"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("unless"), runtime.newFixnum(3));
        hash2.fastASet(runtime.newSymbol("unless_mod"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("until"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("until_mod"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("var_alias"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("var_field"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("var_ref"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("vcall"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("void_stmt"), runtime.newFixnum(0));
        hash2.fastASet(runtime.newSymbol("when"), runtime.newFixnum(3));
        hash2.fastASet(runtime.newSymbol("while"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("while_mod"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("word_add"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("word_new"), runtime.newFixnum(0));
        hash2.fastASet(runtime.newSymbol("words_add"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("words_new"), runtime.newFixnum(0));
        hash2.fastASet(runtime.newSymbol("xstring_add"), runtime.newFixnum(2));
        hash2.fastASet(runtime.newSymbol("xstring_literal"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("xstring_new"), runtime.newFixnum(0));
        hash2.fastASet(runtime.newSymbol("yield"), runtime.newFixnum(1));
        hash2.fastASet(runtime.newSymbol("yield0"), runtime.newFixnum(0));
        hash2.fastASet(runtime.newSymbol("zsuper"), runtime.newFixnum(0));
        return hash2;
    }

    private RubyRipper(Ruby runtime, RubyClass klazz) {
        super(runtime, klazz);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject src) {
        return this.initialize(context, src, null, null);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject src, IRubyObject file2) {
        return this.initialize(context, src, file2, null);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject src, IRubyObject file2, IRubyObject line) {
        this.filename = this.filenameAsString(context, file2).dup();
        this.parser = new RipperParser(context, this, this.source(context, src, this.filename.asJavaString(), this.lineAsInt(context, line)));
        return context.runtime.getNil();
    }

    @JRubyMethod
    public IRubyObject column(ThreadContext context) {
        if (!this.parser.hasStarted()) {
            throw context.runtime.newArgumentError("method called for uninitialized object");
        }
        if (!this.parseStarted) {
            return context.runtime.getNil();
        }
        return context.runtime.newFixnum(this.parser.getColumn());
    }

    @JRubyMethod
    public IRubyObject encoding(ThreadContext context) {
        return context.runtime.getEncodingService().getEncoding(this.parser.encoding());
    }

    @JRubyMethod(name={"end_seen?"})
    public IRubyObject end_seen_p(ThreadContext context) {
        return context.runtime.newBoolean(this.parser.isEndSeen());
    }

    @JRubyMethod(name={"error?"})
    public IRubyObject error_p(ThreadContext context) {
        return context.runtime.newBoolean(this.parser.isError());
    }

    @JRubyMethod
    public IRubyObject filename(ThreadContext context) {
        return this.filename;
    }

    @JRubyMethod
    public IRubyObject lineno(ThreadContext context) {
        if (!this.parser.hasStarted()) {
            context.runtime.newArgumentError("method called for uninitialized object");
        }
        if (!this.parseStarted) {
            return context.runtime.getNil();
        }
        return context.runtime.newFixnum(this.parser.getLineno());
    }

    @JRubyMethod
    public IRubyObject parse(ThreadContext context) {
        this.parseStarted = true;
        try {
            return this.parser.parse(true);
        }
        catch (IOException e) {
            System.out.println("ERRROR: " + e);
        }
        catch (SyntaxException syntaxException) {
            // empty catch block
        }
        return context.runtime.getNil();
    }

    @JRubyMethod
    public IRubyObject yydebug(ThreadContext context) {
        return context.runtime.newBoolean(this.parser.getYYDebug());
    }

    @JRubyMethod(name={"yydebug="})
    public IRubyObject yydebug_set(ThreadContext context, IRubyObject arg2) {
        this.parser.setYYDebug(arg2.isTrue());
        return arg2;
    }

    private LexerSource source(ThreadContext context, IRubyObject src, String filename2, int lineno2) {
        DynamicMethod method = src.getMetaClass().searchMethod("gets");
        if (method.isUndefined() || method.getVisibility() == Visibility.PRIVATE) {
            return new ByteListLexerSource(filename2, lineno2, src.convertToString().getByteList(), null);
        }
        return new GetsLexerSource(filename2, lineno2, src, null);
    }

    private IRubyObject filenameAsString(ThreadContext context, IRubyObject filename2) {
        if (filename2 == null || filename2.isNil()) {
            return context.runtime.newString("(ripper)");
        }
        return filename2.convertToString();
    }

    private int lineAsInt(ThreadContext context, IRubyObject line) {
        if (line == null || line.isNil()) {
            return 0;
        }
        return RubyNumeric.fix2int(line.convertToInteger()) - 1;
    }
}

