/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import jnr.constants.platform.AddressFamily;
import jnr.constants.platform.ProtocolFamily;
import jnr.constants.platform.Sock;
import jnr.netdb.Protocol;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.socket.SocketType;
import org.jruby.ext.socket.SocketUtils;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.io.Sockaddr;

public class Addrinfo
extends RubyObject {
    final short ARPHRD_ETHER = 1;
    final short ARPHRD_LOOPBACK = (short)772;
    final short AF_PACKET = (short)17;
    final byte PACKET_HOST = 0;
    private InetAddress inetAddress;
    private int port;
    private ProtocolFamily pfamily;
    private AddressFamily afamily;
    private Sock sock;
    private SocketType socketType;
    private String interfaceName;
    private boolean interfaceLink;
    private NetworkInterface networkInterface;
    private boolean isBroadcast;
    private Protocol protocol = Protocol.getProtocolByNumber((int)0);

    public static void createAddrinfo(Ruby runtime) {
        RubyClass addrinfo = runtime.defineClass("Addrinfo", runtime.getClass("Data"), new ObjectAllocator(){

            @Override
            public IRubyObject allocate(Ruby runtime, RubyClass klazz) {
                return new Addrinfo(runtime, klazz);
            }
        });
        addrinfo.defineAnnotatedMethods(Addrinfo.class);
    }

    public Addrinfo(Ruby runtime, RubyClass cls) {
        super(runtime, cls);
    }

    public Addrinfo(Ruby runtime, RubyClass cls, NetworkInterface networkInterface, InetAddress inetAddress) {
        super(runtime, cls);
        this.networkInterface = networkInterface;
        this.interfaceLink = false;
        this.inetAddress = inetAddress;
        this.interfaceName = networkInterface.getName();
        this.pfamily = inetAddress instanceof Inet4Address ? ProtocolFamily.PF_INET : ProtocolFamily.PF_INET6;
        this.afamily = inetAddress instanceof Inet4Address ? AddressFamily.AF_INET : AddressFamily.AF_INET6;
        this.socketType = SocketType.SOCKET;
    }

    public Addrinfo(Ruby runtime, RubyClass cls, NetworkInterface networkInterface, boolean isBroadcast) {
        super(runtime, cls);
        this.networkInterface = networkInterface;
        this.interfaceLink = true;
        this.isBroadcast = isBroadcast;
        this.interfaceName = networkInterface.getName();
        this.afamily = AddressFamily.AF_UNSPEC;
        this.pfamily = ProtocolFamily.PF_UNSPEC;
        this.socketType = SocketType.SOCKET;
    }

    public Addrinfo(Ruby runtime, RubyClass cls, InetAddress inetAddress) {
        super(runtime, cls);
        this.inetAddress = inetAddress;
        this.pfamily = inetAddress instanceof Inet4Address ? ProtocolFamily.PF_INET : ProtocolFamily.PF_INET6;
        this.afamily = inetAddress instanceof Inet4Address ? AddressFamily.AF_INET : AddressFamily.AF_INET6;
        this.socketType = SocketType.SOCKET;
    }

    public Addrinfo(Ruby runtime, RubyClass cls, InetAddress inetAddress, int port) {
        super(runtime, cls);
        this.inetAddress = inetAddress;
        this.port = port;
        this.sock = Sock.SOCK_STREAM;
        this.pfamily = inetAddress instanceof Inet4Address ? ProtocolFamily.PF_INET : ProtocolFamily.PF_INET6;
        this.afamily = inetAddress instanceof Inet4Address ? AddressFamily.AF_INET : AddressFamily.AF_INET6;
        this.socketType = SocketType.SOCKET;
    }

    public Addrinfo(Ruby runtime, RubyClass cls, InetAddress inetAddress, int port, SocketType socketType) {
        super(runtime, cls);
        this.inetAddress = inetAddress;
        this.port = port;
        this.socketType = socketType;
        this.sock = Sock.SOCK_STREAM;
        this.pfamily = inetAddress instanceof Inet4Address ? ProtocolFamily.PF_INET : ProtocolFamily.PF_INET6;
        this.afamily = inetAddress instanceof Inet4Address ? AddressFamily.AF_INET : AddressFamily.AF_INET6;
        this.socketType = SocketType.SOCKET;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public int getPort() {
        return this.port;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject _sockaddr) {
        this.initializeCommon(context.runtime, _sockaddr, null, null, null);
        return context.nil;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject _sockaddr, IRubyObject _family) {
        this.initializeCommon(context.runtime, _sockaddr, _family, null, null);
        return context.nil;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject _sockaddr, IRubyObject _family, IRubyObject _socktype) {
        this.initializeCommon(context.runtime, _sockaddr, _family, _socktype, null);
        return context.nil;
    }

    @JRubyMethod(required=1, optional=4, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return this.initialize(context, args2[0]);
            }
            case 2: {
                return this.initialize(context, args2[0], args2[1]);
            }
            case 3: {
                return this.initialize(context, args2[0], args2[1], args2[2]);
            }
        }
        IRubyObject _sockaddr = args2[0];
        IRubyObject _family = args2[1];
        IRubyObject _socktype = args2[2];
        IRubyObject _protocol = args2[3];
        this.initializeCommon(context.runtime, _sockaddr, _family, _socktype, _protocol);
        return context.nil;
    }

    private void initializeCommon(Ruby runtime, IRubyObject sockaddr, IRubyObject family2, IRubyObject sock, IRubyObject port) {
        try {
            this.inetAddress = SocketUtils.getRubyInetAddress(sockaddr.convertToString().getByteList());
            if (family2 == null) {
                this.pfamily = this.inetAddress instanceof Inet4Address ? ProtocolFamily.PF_INET : ProtocolFamily.PF_INET6;
                this.afamily = this.inetAddress instanceof Inet4Address ? AddressFamily.AF_INET : AddressFamily.AF_INET6;
                this.socketType = SocketType.SOCKET;
            } else {
                this.pfamily = SocketUtils.protocolFamilyFromArg(family2);
                if (this.pfamily == ProtocolFamily.__UNKNOWN_CONSTANT__) {
                    throw runtime.newErrnoENOPROTOOPTError();
                }
                this.afamily = SocketUtils.addressFamilyFromArg(family2);
                if (this.afamily == AddressFamily.__UNKNOWN_CONSTANT__) {
                    throw runtime.newErrnoENOPROTOOPTError();
                }
                this.socketType = SocketType.SOCKET;
            }
            this.sock = sock == null ? Sock.SOCK_STREAM : SocketUtils.sockFromArg(sock);
            this.port = port == null ? 0 : (int)port.convertToInteger().getLongValue();
            this.protocol = Protocol.getProtocolByName((String)"tcp");
        }
        catch (IOException ioe) {
            throw runtime.newIOErrorFromException(ioe);
        }
    }

    @JRubyMethod
    public IRubyObject inspect(ThreadContext context) {
        if (this.interfaceLink) {
            return context.runtime.newString("#<Addrinfo: " + this.packet_inspect() + ">");
        }
        String portString = this.port == 0 ? "" : ":" + this.port;
        return context.runtime.newString("#<Addrinfo: " + this.inetAddress.getHostAddress() + portString + ">");
    }

    @JRubyMethod
    public IRubyObject inspect_sockaddr(ThreadContext context) {
        String portString = this.port == 0 ? "" : ":" + this.port;
        return context.runtime.newString(this.inetAddress.getHostAddress() + portString);
    }

    @JRubyMethod(rest=true, meta=true)
    public static IRubyObject getaddrinfo(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyArray.newArray(context.runtime, SocketUtils.getaddrinfoList(context, args2));
    }

    @JRubyMethod(meta=true)
    public static IRubyObject ip(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        String host = arg2.convertToString().toString();
        try {
            InetAddress addy = InetAddress.getByName(host);
            return new Addrinfo(context.runtime, (RubyClass)recv2, addy);
        }
        catch (UnknownHostException uhe) {
            throw SocketUtils.sockerr(context.runtime, "host not found");
        }
    }

    @JRubyMethod(meta=true)
    public static IRubyObject tcp(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1) {
        Addrinfo addrinfo = new Addrinfo(context.runtime, (RubyClass)recv2);
        addrinfo.initializeCommon(context.runtime, arg0, null, null, arg1);
        return addrinfo;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject udp(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1) {
        return ((RubyClass)recv2).newInstance(context, arg0, arg1, Block.NULL_BLOCK);
    }

    @JRubyMethod(rest=true, meta=true, notImplemented=true)
    public static IRubyObject unix(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return ((RubyClass)recv2).newInstance(context, args2, Block.NULL_BLOCK);
    }

    @JRubyMethod
    public IRubyObject afamily(ThreadContext context) {
        return context.runtime.newFixnum(this.afamily.intValue());
    }

    @JRubyMethod
    public IRubyObject pfamily(ThreadContext context) {
        return context.runtime.newFixnum(this.pfamily.intValue());
    }

    @JRubyMethod
    public IRubyObject socktype(ThreadContext context) {
        if (this.sock == null) {
            return context.runtime.newFixnum(0);
        }
        return context.runtime.newFixnum(this.sock.intValue());
    }

    @JRubyMethod
    public IRubyObject protocol(ThreadContext context) {
        return context.runtime.newFixnum(this.protocol.getProto());
    }

    @JRubyMethod
    public IRubyObject canonname(ThreadContext context) {
        return context.runtime.newString(this.inetAddress.getCanonicalHostName());
    }

    @JRubyMethod(name={"ipv4?"})
    public IRubyObject ipv4_p(ThreadContext context) {
        return context.runtime.newBoolean(this.pfamily == ProtocolFamily.PF_INET);
    }

    @JRubyMethod(name={"ipv6?"})
    public IRubyObject ipv6_p(ThreadContext context) {
        return context.runtime.newBoolean(this.pfamily == ProtocolFamily.PF_INET6);
    }

    @JRubyMethod(name={"unix?"})
    public IRubyObject unix_p(ThreadContext context) {
        return context.runtime.newBoolean(this.pfamily == ProtocolFamily.PF_UNIX);
    }

    @JRubyMethod(name={"ip?"}, notImplemented=true)
    public IRubyObject ip_p(ThreadContext context) {
        return context.runtime.newBoolean(this.pfamily == ProtocolFamily.PF_INET || this.pfamily == ProtocolFamily.PF_INET6);
    }

    @JRubyMethod
    public IRubyObject ip_unpack(ThreadContext context) {
        RubyArray ary = RubyArray.newArray(context.runtime, 2);
        ary.append(this.ip_address(context));
        ary.append(this.ip_port(context));
        return ary;
    }

    @JRubyMethod(notImplemented=true)
    public IRubyObject ip_address(ThreadContext context) {
        if (this.interfaceLink) {
            throw SocketUtils.sockerr(context.runtime, "need IPv4 or IPv6 address");
        }
        return context.runtime.newString(this.inetAddress.getHostAddress());
    }

    @JRubyMethod(notImplemented=true)
    public IRubyObject ip_port(ThreadContext context) {
        if (this.interfaceLink) {
            throw SocketUtils.sockerr(context.runtime, "need IPv4 or IPv6 address");
        }
        return context.runtime.newFixnum(this.port);
    }

    @JRubyMethod(name={"ipv4_private?"}, notImplemented=true)
    public IRubyObject ipv4_private_p(ThreadContext context) {
        return context.nil;
    }

    @JRubyMethod(name={"ipv4_loopback?"})
    public IRubyObject ipv4_loopback_p(ThreadContext context) {
        if (this.afamily == AddressFamily.AF_INET) {
            return context.runtime.newBoolean(this.inetAddress.isLoopbackAddress());
        }
        return context.runtime.newBoolean(false);
    }

    @JRubyMethod(name={"ipv4_multicast?"})
    public IRubyObject ipv4_multicast_p(ThreadContext context) {
        return context.runtime.newBoolean(this.inetAddress.isMulticastAddress());
    }

    @JRubyMethod(name={"ipv6_unspecified?"}, notImplemented=true)
    public IRubyObject ipv6_unspecified_p(ThreadContext context) {
        return context.nil;
    }

    @JRubyMethod(name={"ipv6_loopback?"})
    public IRubyObject ipv6_loopback_p(ThreadContext context) {
        if (this.afamily == AddressFamily.AF_INET6) {
            return context.runtime.newBoolean(this.inetAddress.isLoopbackAddress());
        }
        return context.runtime.newBoolean(false);
    }

    @JRubyMethod(name={"ipv6_multicast?"})
    public IRubyObject ipv6_multicast_p(ThreadContext context) {
        return context.runtime.newBoolean(this.inetAddress.isMulticastAddress());
    }

    @JRubyMethod(name={"ipv6_linklocal?"})
    public IRubyObject ipv6_linklocal_p(ThreadContext context) {
        return context.runtime.newBoolean(this.inetAddress.isLinkLocalAddress());
    }

    @JRubyMethod(name={"ipv6_sitelocal?"})
    public IRubyObject ipv6_sitelocal_p(ThreadContext context) {
        return context.runtime.newBoolean(this.inetAddress.isSiteLocalAddress());
    }

    @JRubyMethod(name={"ipv6_v4mapped?"}, notImplemented=true)
    public IRubyObject ipv6_v4mapped_p(ThreadContext context) {
        return context.nil;
    }

    @JRubyMethod(name={"ipv6_v4compat?"})
    public IRubyObject ipv6_v4compat_p(ThreadContext context) {
        if (!(this.inetAddress instanceof Inet6Address)) {
            return context.runtime.getFalse();
        }
        return context.runtime.newBoolean(((Inet6Address)this.inetAddress).isIPv4CompatibleAddress());
    }

    @JRubyMethod(name={"ipv6_mc_nodelocal?"})
    public IRubyObject ipv6_mc_nodelocal_p(ThreadContext context) {
        return context.runtime.newBoolean(this.inetAddress.isMCNodeLocal());
    }

    @JRubyMethod(name={"ipv6_mc_linklocal?"})
    public IRubyObject ipv6_mc_linklocal_p(ThreadContext context) {
        return context.runtime.newBoolean(this.inetAddress.isMCLinkLocal());
    }

    @JRubyMethod(name={"ipv6_mc_sitelocal?"})
    public IRubyObject ipv6_mc_sitelocal_p(ThreadContext context) {
        return context.runtime.newBoolean(this.inetAddress.isMCSiteLocal());
    }

    @JRubyMethod(name={"ipv6_mc_orglocal?"})
    public IRubyObject ipv6_mc_orglocal_p(ThreadContext context) {
        return context.runtime.newBoolean(this.inetAddress.isMCOrgLocal());
    }

    @JRubyMethod(name={"ipv6_mc_global?"})
    public IRubyObject ipv6_mc_global_p(ThreadContext context) {
        return context.runtime.newBoolean(this.inetAddress.isMCGlobal());
    }

    @JRubyMethod(notImplemented=true)
    public IRubyObject ipv6_to_ipv4(ThreadContext context) {
        return context.nil;
    }

    @JRubyMethod(notImplemented=true)
    public IRubyObject unix_path(ThreadContext context) {
        return context.nil;
    }

    @JRubyMethod(name={"to_sockaddr", "to_s"})
    public IRubyObject to_sockaddr(ThreadContext context) {
        if (this.afamily == AddressFamily.AF_INET || this.afamily == AddressFamily.AF_INET6) {
            return Sockaddr.pack_sockaddr_in(context, this.port, this.inetAddress.getHostAddress());
        }
        if (this.afamily == AddressFamily.AF_UNSPEC) {
            ByteArrayOutputStream bufS = new ByteArrayOutputStream();
            DataOutputStream ds = new DataOutputStream(bufS);
            try {
                ds.writeShort(this.swapShortEndian((short)17));
                ds.writeShort(0);
                ds.writeInt(this.swapIntEndian(this.networkInterface.getIndex()));
                ds.writeShort(this.swapShortEndian(this.hatype()));
                ds.writeByte(0);
                byte[] hw = this.hwaddr();
                ds.writeByte(hw.length);
                ds.write(hw);
            }
            catch (IOException e) {
                throw Addrinfo.sockerr(context.runtime, "to_sockaddr: " + e.getMessage());
            }
            return context.runtime.newString(new ByteList(bufS.toByteArray(), false));
        }
        return context.nil;
    }

    private short hatype() {
        try {
            short ht = 1;
            if (this.networkInterface.isLoopback()) {
                ht = 772;
            }
            return ht;
        }
        catch (IOException e) {
            return 0;
        }
    }

    private byte[] hwaddr() {
        try {
            byte[] hw = new byte[]{0, 0, 0, 0, 0, 0};
            if (!this.networkInterface.isLoopback() && (hw = this.networkInterface.getHardwareAddress()) == null) {
                hw = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            }
            if (this.isBroadcast) {
                hw = new byte[]{-1, -1, -1, -1, -1, -1};
            }
            return hw;
        }
        catch (IOException e) {
            return ByteList.NULL_ARRAY;
        }
    }

    public String packet_inspect() {
        StringBuffer hwaddr_sb = new StringBuffer();
        String sep = "";
        for (byte b2 : this.hwaddr()) {
            hwaddr_sb.append(sep);
            sep = ":";
            hwaddr_sb.append(String.format("%02x", b2));
        }
        return "PACKET[protocol=0 " + this.interfaceName + " hatype=" + this.hatype() + " HOST hwaddr=" + hwaddr_sb + "]";
    }

    private int swapIntEndian(int i2) {
        return ((i2 & 0xFF) << 24) + ((i2 & 0xFF00) << 8) + ((i2 & 0xFF0000) >> 8) + (i2 >> 24 & 0xFF);
    }

    private int swapShortEndian(short i2) {
        return ((i2 & 0xFF) << 8) + ((i2 & 0xFF00) >> 8);
    }

    private static RuntimeException sockerr(Ruby runtime, String msg) {
        return new RaiseException(runtime, runtime.getClass("SocketError"), msg, true);
    }

    @JRubyMethod(rest=true, notImplemented=true)
    public IRubyObject getnameinfo(ThreadContext context, IRubyObject[] args2) {
        return context.nil;
    }

    @JRubyMethod(notImplemented=true)
    public IRubyObject marshal_dump(ThreadContext context) {
        return context.nil;
    }

    @JRubyMethod(notImplemented=true)
    public IRubyObject marshal_load(ThreadContext context, IRubyObject arg2) {
        return context.nil;
    }

    @JRubyMethod
    public IRubyObject to_str(ThreadContext context) {
        return context.runtime.newString(this.toString());
    }

    @Override
    public String toString() {
        return this.inetAddress.getHostAddress() + ":" + this.port;
    }
}

