/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.extension;

import org.asciidoctor.extension.BlockMacroProcessor;
import org.asciidoctor.extension.BlockProcessor;
import org.asciidoctor.extension.DocinfoProcessor;
import org.asciidoctor.extension.IncludeProcessor;
import org.asciidoctor.extension.InlineMacroProcessor;
import org.asciidoctor.extension.Name;
import org.asciidoctor.extension.Postprocessor;
import org.asciidoctor.extension.Preprocessor;
import org.asciidoctor.extension.Treeprocessor;
import org.asciidoctor.extension.processorproxies.BlockMacroProcessorProxy;
import org.asciidoctor.extension.processorproxies.BlockProcessorProxy;
import org.asciidoctor.extension.processorproxies.DocinfoProcessorProxy;
import org.asciidoctor.extension.processorproxies.IncludeProcessorProxy;
import org.asciidoctor.extension.processorproxies.InlineMacroProcessorProxy;
import org.asciidoctor.extension.processorproxies.PostprocessorProxy;
import org.asciidoctor.extension.processorproxies.PreprocessorProxy;
import org.asciidoctor.extension.processorproxies.TreeprocessorProxy;
import org.asciidoctor.internal.AsciidoctorModule;
import org.jruby.Ruby;
import org.jruby.RubyClass;

public class JavaExtensionRegistry {
    private AsciidoctorModule asciidoctorModule;
    private Ruby rubyRuntime;

    public JavaExtensionRegistry(AsciidoctorModule asciidoctorModule, Ruby rubyRuntime) {
        this.asciidoctorModule = asciidoctorModule;
        this.rubyRuntime = rubyRuntime;
    }

    public void docinfoProcessor(Class<? extends DocinfoProcessor> docInfoProcessor) {
        RubyClass rubyClass = DocinfoProcessorProxy.register(this.rubyRuntime, docInfoProcessor);
        this.asciidoctorModule.docinfo_processor(rubyClass);
    }

    public void docinfoProcessor(DocinfoProcessor docInfoProcessor) {
        RubyClass rubyClass = DocinfoProcessorProxy.register(this.rubyRuntime, docInfoProcessor);
        this.asciidoctorModule.docinfo_processor(rubyClass);
    }

    public void docinfoProcessor(String docInfoProcessor) {
        try {
            Class<?> docinfoProcessorClass = Class.forName(docInfoProcessor);
            this.docinfoProcessor(docinfoProcessorClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void preprocessor(Class<? extends Preprocessor> preprocessor) {
        RubyClass rubyClass = PreprocessorProxy.register(this.rubyRuntime, preprocessor);
        this.asciidoctorModule.preprocessor(rubyClass);
    }

    public void preprocessor(Preprocessor preprocessor) {
        RubyClass rubyClass = PreprocessorProxy.register(this.rubyRuntime, preprocessor);
        this.asciidoctorModule.preprocessor(rubyClass);
    }

    public void preprocessor(String preprocessor) {
        try {
            Class<?> preprocessorClass = Class.forName(preprocessor);
            this.preprocessor(preprocessorClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void postprocessor(String postprocessor) {
        try {
            Class<?> postprocessorClass = Class.forName(postprocessor);
            this.postprocessor(postprocessorClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void postprocessor(Class<? extends Postprocessor> postprocessor) {
        RubyClass rubyClass = PostprocessorProxy.register(this.rubyRuntime, postprocessor);
        this.asciidoctorModule.postprocessor(rubyClass);
    }

    public void postprocessor(Postprocessor postprocessor) {
        RubyClass rubyClass = PostprocessorProxy.register(this.rubyRuntime, postprocessor);
        this.asciidoctorModule.postprocessor(rubyClass);
    }

    public void includeProcessor(String includeProcessor) {
        try {
            Class<?> includeProcessorClass = Class.forName(includeProcessor);
            this.includeProcessor(includeProcessorClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void includeProcessor(Class<? extends IncludeProcessor> includeProcessor) {
        RubyClass rubyClass = IncludeProcessorProxy.register(this.rubyRuntime, includeProcessor);
        this.asciidoctorModule.include_processor(rubyClass);
    }

    public void includeProcessor(IncludeProcessor includeProcessor) {
        RubyClass rubyClass = IncludeProcessorProxy.register(this.rubyRuntime, includeProcessor);
        this.asciidoctorModule.include_processor(rubyClass);
    }

    public void treeprocessor(Treeprocessor treeprocessor) {
        RubyClass rubyClass = TreeprocessorProxy.register(this.rubyRuntime, treeprocessor);
        this.asciidoctorModule.treeprocessor(rubyClass);
    }

    public void treeprocessor(Class<? extends Treeprocessor> abstractTreeProcessor) {
        RubyClass rubyClass = TreeprocessorProxy.register(this.rubyRuntime, abstractTreeProcessor);
        this.asciidoctorModule.treeprocessor(rubyClass);
    }

    public void treeprocessor(String treeProcessor) {
        try {
            Class<?> treeProcessorClass = Class.forName(treeProcessor);
            this.treeprocessor(treeProcessorClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void block(String blockName, String blockProcessor) {
        try {
            Class<?> blockProcessorClass = Class.forName(blockProcessor);
            this.block(blockName, blockProcessorClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void block(String blockProcessor) {
        try {
            Class<?> blockProcessorClass = Class.forName(blockProcessor);
            this.block(blockProcessorClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void block(String blockName, Class<? extends BlockProcessor> blockProcessor) {
        RubyClass rubyClass = BlockProcessorProxy.register(this.rubyRuntime, blockProcessor);
        this.asciidoctorModule.block_processor(rubyClass, (Object)blockName);
    }

    public void block(Class<? extends BlockProcessor> blockProcessor) {
        String name = this.getName(blockProcessor);
        this.block(name, blockProcessor);
    }

    public void block(BlockProcessor blockProcessor) {
        RubyClass rubyClass = BlockProcessorProxy.register(this.rubyRuntime, blockProcessor);
        this.asciidoctorModule.block_processor(rubyClass, (Object)blockProcessor.getName());
    }

    public void block(String blockName, BlockProcessor blockProcessor) {
        RubyClass rubyClass = BlockProcessorProxy.register(this.rubyRuntime, blockProcessor);
        this.asciidoctorModule.block_processor(rubyClass, (Object)blockName);
    }

    public void blockMacro(String blockName, Class<? extends BlockMacroProcessor> blockMacroProcessor) {
        RubyClass rubyClass = BlockMacroProcessorProxy.register(this.rubyRuntime, blockMacroProcessor);
        this.asciidoctorModule.block_macro(rubyClass, (Object)blockName);
    }

    public void blockMacro(Class<? extends BlockMacroProcessor> blockMacroProcessor) {
        String name = this.getName(blockMacroProcessor);
        RubyClass rubyClass = BlockMacroProcessorProxy.register(this.rubyRuntime, blockMacroProcessor);
        this.asciidoctorModule.block_macro(rubyClass, (Object)name);
    }

    public void blockMacro(String blockName, String blockMacroProcessor) {
        try {
            Class<?> blockMacroProcessorClass = Class.forName(blockMacroProcessor);
            this.blockMacro(blockName, blockMacroProcessorClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void blockMacro(String blockMacroProcessor) {
        try {
            Class<?> blockMacroProcessorClass = Class.forName(blockMacroProcessor);
            this.blockMacro(blockMacroProcessorClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void blockMacro(BlockMacroProcessor blockMacroProcessor) {
        RubyClass rubyClass = BlockMacroProcessorProxy.register(this.rubyRuntime, blockMacroProcessor);
        this.asciidoctorModule.block_macro(rubyClass, (Object)blockMacroProcessor.getName());
    }

    public void inlineMacro(InlineMacroProcessor inlineMacroProcessor) {
        RubyClass rubyClass = InlineMacroProcessorProxy.register(this.rubyRuntime, inlineMacroProcessor);
        this.asciidoctorModule.inline_macro(rubyClass, (Object)inlineMacroProcessor.getName());
    }

    public void inlineMacro(String blockName, Class<? extends InlineMacroProcessor> inlineMacroProcessor) {
        RubyClass rubyClass = InlineMacroProcessorProxy.register(this.rubyRuntime, inlineMacroProcessor);
        this.asciidoctorModule.inline_macro(rubyClass, (Object)blockName);
    }

    public void inlineMacro(Class<? extends InlineMacroProcessor> inlineMacroProcessor) {
        String name = this.getName(inlineMacroProcessor);
        RubyClass rubyClass = InlineMacroProcessorProxy.register(this.rubyRuntime, inlineMacroProcessor);
        this.asciidoctorModule.inline_macro(rubyClass, (Object)name);
    }

    public void inlineMacro(String blockName, String inlineMacroProcessor) {
        try {
            Class<?> inlineMacroProcessorClass = Class.forName(inlineMacroProcessor);
            this.inlineMacro(blockName, inlineMacroProcessorClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void inlineMacro(String inlineMacroProcessor) {
        try {
            Class<?> inlineMacroProcessorClass = Class.forName(inlineMacroProcessor);
            this.inlineMacro(inlineMacroProcessorClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private String getName(Class<?> clazz) {
        Name nameAnnotation = clazz.getAnnotation(Name.class);
        if (nameAnnotation == null || nameAnnotation.value() == null) {
            throw new IllegalArgumentException(clazz + " must be registered with a name or it must have a Name annotation!");
        }
        return nameAnnotation.value();
    }
}

