/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.extension;

import java.util.List;
import org.asciidoctor.extension.Reader;
import org.asciidoctor.internal.RubyObjectWrapper;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.runtime.builtin.IRubyObject;

public class ReaderImpl
extends RubyObjectWrapper
implements Reader {
    public ReaderImpl(IRubyObject rubyNode) {
        super(rubyNode);
    }

    static ReaderImpl createReader(Ruby runtime, List<String> lines) {
        RubyArray rubyLines = runtime.newArray(lines.size());
        for (String line : lines) {
            rubyLines.add((Object)runtime.newString(line));
        }
        RubyClass readerClass = runtime.getModule("Asciidoctor").getClass("Reader");
        return new ReaderImpl(readerClass.callMethod("new", new IRubyObject[]{rubyLines}));
    }

    @Override
    public int getLineno() {
        return this.getLineNumber();
    }

    @Override
    public int getLineNumber() {
        return this.getInt("lineno", new Object[0]);
    }

    @Override
    public boolean hasMoreLines() {
        return this.getBoolean("has_more_lines?", new Object[0]);
    }

    @Override
    public boolean isNextLineEmpty() {
        return this.getBoolean("next_line_empty?", new Object[0]);
    }

    @Override
    public String read() {
        return this.getString("read", new Object[0]);
    }

    @Override
    public List<String> readLines() {
        return this.getList("read_lines", String.class, new Object[0]);
    }

    @Override
    public String readLine() {
        return this.getString("read_line", new Object[0]);
    }

    @Override
    public List<String> lines() {
        return this.getList("lines", String.class, new Object[0]);
    }

    @Override
    public void restoreLine(String line) {
        this.getRubyProperty("unshift_line", line);
    }

    @Override
    public void restoreLines(List<String> lines) {
        this.getRubyProperty("unshift_lines", lines);
    }

    @Override
    public String peekLine() {
        return this.getString("peek_line", new Object[0]);
    }

    @Override
    public List<String> peekLines(int lineCount) {
        return this.getList("peek_lines", String.class, lineCount);
    }

    @Override
    public boolean advance() {
        return this.getBoolean("advance", new Object[0]);
    }

    @Override
    public void terminate() {
        this.getRubyProperty("terminate", new Object[0]);
    }
}

