@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  asciidoctorj startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Add default JVM options here. You can also use JAVA_OPTS and ASCIIDOCTORJ_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS="-client" "-Xmn128m" "-Xms256m" "-Xmx256m" "-Xverify:none" "-XX:+UseFastAccessorMethods" "-XX:+TieredCompilation" "-XX:TieredStopAtLevel=1" "-XX:+DisableExplicitGC"

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto init

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto init

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:init
@rem Get command-line arguments, handling Windows variants

if not "%OS%" == "Windows_NT" goto win9xME_args
if "%@eval[2+2]" == "4" goto 4NT_args

:win9xME_args
@rem Slurp the command line arguments.
set CMD_LINE_ARGS=
set _SKIP=2

:win9xME_args_slurp
if "x%~1" == "x" goto execute

set CMD_LINE_ARGS=%*
goto execute

:4NT_args
@rem Get arguments from the 4NT Shell from JP Software
set CMD_LINE_ARGS=%$

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\asciidoctorj-1.6.0-alpha.3-bin.jar;%APP_HOME%\lib\asciidoctorj-1.6.0-alpha.3.jar;%APP_HOME%\lib\asciidoctorj-epub3-1.5.0-alpha.6.jar;%APP_HOME%\lib\asciidoctorj-pdf-1.5.0-alpha.11.jar;%APP_HOME%\lib\asciidoctorj-diagram-1.3.1.jar;%APP_HOME%\lib\jruby-9.1.2.0.jar;%APP_HOME%\lib\jcommander-1.35.jar;%APP_HOME%\lib\jruby-core-9.1.2.0.jar;%APP_HOME%\lib\jruby-stdlib-9.1.2.0.jar;%APP_HOME%\lib\jnr-netdb-1.1.5.jar;%APP_HOME%\lib\jnr-enxio-0.12.jar;%APP_HOME%\lib\jnr-x86asm-1.0.2.jar;%APP_HOME%\lib\jnr-unixsocket-0.12.jar;%APP_HOME%\lib\jnr-posix-3.0.29.jar;%APP_HOME%\lib\jnr-constants-0.9.2.jar;%APP_HOME%\lib\jffi-1.2.12.jar;%APP_HOME%\lib\jffi-1.2.12-native.jar;%APP_HOME%\lib\joni-2.1.10.jar;%APP_HOME%\lib\bytelist-1.0.13.jar;%APP_HOME%\lib\jcodings-1.0.17.jar;%APP_HOME%\lib\dirgra-0.3.jar;%APP_HOME%\lib\invokebinder-1.7.jar;%APP_HOME%\lib\options-1.4.jar;%APP_HOME%\lib\jzlib-1.1.3.jar;%APP_HOME%\lib\nailgun-server-0.9.1.jar;%APP_HOME%\lib\joda-time-2.8.2.jar

@rem Execute asciidoctorj
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %ASCIIDOCTORJ_OPTS%  -classpath "%CLASSPATH%" org.asciidoctor.cli.AsciidoctorInvoker %CMD_LINE_ARGS%

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable ASCIIDOCTORJ_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%ASCIIDOCTORJ_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
