/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.asciidoctor.internal.RubyHashMapDecorator;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubyString;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyAttributesMapDecorator
implements Map<String, Object> {
    private final RubyHash rubyHash;

    public RubyAttributesMapDecorator(RubyHash rubyHash) {
        this.rubyHash = rubyHash;
    }

    @Override
    public int size() {
        return this.rubyHash.size();
    }

    @Override
    public boolean isEmpty() {
        return this.rubyHash.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (!(key instanceof String)) {
            return false;
        }
        return this.rubyHash.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.rubyHash.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        if (!(key instanceof String)) {
            return false;
        }
        Object value = this.rubyHash.get(key);
        return this.convertRubyValue(value);
    }

    @Override
    public Object put(String key, Object value) {
        Object oldValue = this.get(key);
        this.rubyHash.put((Object)key, (Object)this.convertJavaValue(value));
        return oldValue;
    }

    @Override
    public Object remove(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        Object oldValue = this.get(key);
        this.rubyHash.remove(key);
        return this.convertRubyValue(oldValue);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        for (Map.Entry<String, ?> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.rubyHash.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.createJavaMap().keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.createJavaMap().values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.createJavaMap().entrySet();
    }

    private Map<String, Object> createJavaMap() {
        HashMap<String, Object> copy = new HashMap<String, Object>();
        Set rubyEntrySet = this.rubyHash.entrySet();
        for (Map.Entry o : rubyEntrySet) {
            String key;
            Object rubyKey = o.getKey();
            Object rubyValue = o.getValue();
            if (rubyKey instanceof RubyString) {
                key = ((RubyString)rubyKey).asJavaString();
            } else {
                if (!(rubyKey instanceof String)) continue;
                key = (String)rubyKey;
            }
            Object value = this.convertRubyValue(rubyValue);
            copy.put(key, value);
        }
        return copy;
    }

    private Object convertRubyValue(Object rubyValue) {
        if (rubyValue == null) {
            return null;
        }
        if (rubyValue instanceof IRubyObject) {
            return JavaEmbedUtils.rubyToJava((IRubyObject)((IRubyObject)rubyValue));
        }
        return rubyValue;
    }

    private IRubyObject convertJavaValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String && ((String)value).startsWith(":")) {
            return this.rubyHash.getRuntime().getSymbolTable().getSymbol(((String)value).substring(1));
        }
        return JavaEmbedUtils.javaToRuby((Ruby)this.rubyHash.getRuntime(), (Object)value);
    }

    public String toString() {
        return this.createJavaMap().toString();
    }

    public Object dup() {
        return new RubyHashMapDecorator((RubyHash)this.rubyHash.dup());
    }
}

