/*
 * Decompiled with CFR 0.152.
 */
package com.headius.invokebinder.transform;

import com.headius.invokebinder.Binder;
import com.headius.invokebinder.transform.Transform;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;

public class Collect
extends Transform {
    private final MethodType source;
    private final int index;
    private final int count;
    private final Class<?> arrayType;

    public Collect(MethodType source, int index, Class<?> arrayType) {
        this.source = source;
        this.index = index;
        this.count = source.parameterCount() - index;
        this.arrayType = arrayType;
    }

    public Collect(MethodType source, int index, int count, Class<?> arrayType) {
        this.source = source;
        this.index = index;
        this.count = count;
        this.arrayType = arrayType;
    }

    @Override
    public MethodHandle up(MethodHandle target) {
        if (this.index + this.count == this.source.parameterCount()) {
            return target.asCollector(this.arrayType, this.count);
        }
        int[] movePermute = new int[this.source.parameterCount()];
        int[] moveBackPermute = new int[target.type().parameterCount()];
        for (int i = 0; i < this.index; ++i) {
            movePermute[i] = i;
            moveBackPermute[i] = i;
        }
        int shifted = 0;
        int i = this.index;
        while (i + this.count < movePermute.length) {
            movePermute[i] = i + this.count;
            ++i;
            ++shifted;
        }
        i = this.index;
        while (i + 1 < moveBackPermute.length) {
            moveBackPermute[i + 1] = i;
            ++i;
        }
        for (i = this.index + shifted; i < movePermute.length; ++i) {
            movePermute[i] = i - shifted;
        }
        moveBackPermute[this.index] = moveBackPermute.length - 1;
        return Binder.from(this.source).permute(movePermute).collect(this.source.parameterCount() - this.count, this.arrayType).permute(moveBackPermute).invoke(target);
    }

    @Override
    public MethodType down(MethodType type) {
        this.assertTypesAreCompatible();
        return type.dropParameterTypes(this.index, this.index + this.count).insertParameterTypes(this.index, this.arrayType);
    }

    private void assertTypesAreCompatible() {
        Class<?> componentType = this.arrayType.getComponentType();
        for (int i = this.index; i < this.index + this.count; ++i) {
            TypeDescriptor.OfField in = this.source.parameterType(i);
            assert (((Class)in).isAssignableFrom(componentType)) : "incoming type " + ((Class)in).getName() + " not compatible with " + componentType.getName() + "[]";
        }
    }

    @Override
    public String toString() {
        return "collect at " + this.index + " into " + this.arrayType.getName();
    }
}

