/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import jnr.posix.util.FieldAccess;
import org.jruby.RubyInstanceConfig;
import org.jruby.util.io.SeekableByteChannelImpl;

public abstract class ChannelHelper {
    private ChannelHelper() {
    }

    public static ReadableByteChannel readableChannel(InputStream inputStream) {
        if (inputStream instanceof ByteArrayInputStream && SeekableByteChannelImpl.USABLE) {
            return new SeekableByteChannelImpl((ByteArrayInputStream)inputStream);
        }
        return Channels.newChannel(inputStream);
    }

    public static WritableByteChannel writableChannel(OutputStream ouputStream) {
        return Channels.newChannel(ouputStream);
    }

    public static OutputStream unwrapBufferedStream(OutputStream filteredStream) {
        if (RubyInstanceConfig.NO_UNWRAP_PROCESS_STREAMS) {
            return filteredStream;
        }
        return ChannelHelper.unwrapFilterOutputStream(filteredStream);
    }

    public static InputStream unwrapBufferedStream(InputStream filteredStream) {
        if (RubyInstanceConfig.NO_UNWRAP_PROCESS_STREAMS) {
            return filteredStream;
        }
        if (filteredStream.getClass().getName().indexOf("ProcessPipeInputStream") != 1) {
            return filteredStream;
        }
        return ChannelHelper.unwrapFilterInputStream((FilterInputStream)filteredStream);
    }

    public static OutputStream unwrapFilterOutputStream(OutputStream filteredStream) {
        while (filteredStream instanceof FilterOutputStream) {
            try {
                OutputStream dripStream;
                OutputStream tmpStream = (OutputStream)FieldAccess.getProtectedFieldValue(FilterOutputStream.class, (String)"out", (Object)filteredStream);
                if (!(tmpStream instanceof FilterOutputStream) && (dripStream = ChannelHelper.unwrapDripStream(tmpStream)) != null) {
                    tmpStream = dripStream;
                }
                filteredStream = tmpStream;
            }
            catch (Exception e) {
                break;
            }
        }
        return filteredStream;
    }

    public static InputStream unwrapFilterInputStream(InputStream filteredStream) {
        while (filteredStream instanceof FilterInputStream) {
            try {
                InputStream dripStream;
                InputStream tmpStream = (InputStream)FieldAccess.getProtectedFieldValue(FilterInputStream.class, (String)"in", (Object)filteredStream);
                if (tmpStream == null) break;
                if (!(tmpStream instanceof FilterInputStream) && (dripStream = ChannelHelper.unwrapDripStream(tmpStream)) != null) {
                    tmpStream = dripStream;
                }
                filteredStream = tmpStream;
            }
            catch (Exception e) {
                break;
            }
        }
        return filteredStream;
    }

    private static OutputStream unwrapDripStream(OutputStream stream) {
        if (ChannelHelper.isDripSwitchable(stream)) {
            try {
                return (OutputStream)FieldAccess.getProtectedFieldValue(stream.getClass(), (String)"out", (Object)stream);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return null;
    }

    private static InputStream unwrapDripStream(InputStream stream) {
        if (ChannelHelper.isDripSwitchable(stream)) {
            try {
                return (InputStream)FieldAccess.getProtectedFieldValue(stream.getClass(), (String)"in", (Object)stream);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean isDripSwitchable(Object stream) {
        return stream.getClass().getName().startsWith("org.flatland.drip.Switchable");
    }
}

