/*
 * Decompiled with CFR 0.152.
 */
package jnr.unixsocket;

import java.io.IOException;
import java.nio.channels.spi.SelectorProvider;
import jnr.constants.platform.ProtocolFamily;
import jnr.constants.platform.Sock;
import jnr.enxio.channels.NativeServerSocketChannel;
import jnr.ffi.byref.IntByReference;
import jnr.unixsocket.Native;
import jnr.unixsocket.SockAddrUnix;
import jnr.unixsocket.UnixServerSocket;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;

public class UnixServerSocketChannel
extends NativeServerSocketChannel {
    private final UnixServerSocket socket = new UnixServerSocket(this);

    UnixServerSocketChannel(UnixServerSocket socket) throws IOException {
        super(Native.socket(ProtocolFamily.PF_UNIX, Sock.SOCK_STREAM, 0));
    }

    UnixServerSocketChannel(SelectorProvider provider, int fd) {
        super(provider, fd, 17);
    }

    public static UnixServerSocketChannel open() throws IOException {
        return new UnixServerSocket().channel;
    }

    public UnixSocketChannel accept() throws IOException {
        UnixSocketAddress remote = new UnixSocketAddress();
        SockAddrUnix addr = remote.getStruct();
        int maxLength = addr.getMaximumLength();
        IntByReference len = new IntByReference(maxLength);
        int clientfd = Native.accept(this.getFD(), addr, len);
        if (clientfd < 0) {
            if (this.isBlocking()) {
                throw new IOException("accept failed: " + Native.getLastErrorString());
            }
            return null;
        }
        addr.updatePath((Integer)len.getValue());
        Native.setBlocking(clientfd, true);
        return new UnixSocketChannel(clientfd);
    }

    public final UnixServerSocket socket() {
        return this.socket;
    }

    public final UnixSocketAddress getRemoteSocketAddress() {
        return null;
    }

    public final UnixSocketAddress getLocalSocketAddress() {
        return this.socket.localAddress;
    }
}

