/*
 * Decompiled with CFR 0.152.
 */
package com.headius.invokebinder.transform;

import com.headius.invokebinder.Binder;
import com.headius.invokebinder.transform.Transform;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;

public class Collect
extends Transform {
    private final MethodType source;
    private final int index;
    private final int count;
    private final Class<?> arrayType;

    public Collect(MethodType source2, int index2, Class<?> arrayType) {
        this.source = source2;
        this.index = index2;
        this.count = source2.parameterCount() - index2;
        this.arrayType = arrayType;
    }

    public Collect(MethodType source2, int index2, int count2, Class<?> arrayType) {
        this.source = source2;
        this.index = index2;
        this.count = count2;
        this.arrayType = arrayType;
    }

    @Override
    public MethodHandle up(MethodHandle target) {
        if (this.onlyTail()) {
            return target.asCollector(this.arrayType, this.count);
        }
        Permutes permutes = this.buildPermutes(this.source, target.type());
        Binder binder = this.preparePermuteBinder(permutes);
        return binder.invoke(target);
    }

    private Binder preparePermuteBinder(Permutes permutes) {
        return Binder.from(this.source).permute(permutes.movePermute).collect(this.source.parameterCount() - this.count, this.arrayType).permute(permutes.moveBackPermute);
    }

    @Override
    public MethodType down(MethodType type2) {
        this.assertTypesAreCompatible();
        return type2.dropParameterTypes(this.index, this.index + this.count).insertParameterTypes(this.index, this.arrayType);
    }

    private void assertTypesAreCompatible() {
        Class<?> componentType = this.arrayType.getComponentType();
        for (int i2 = this.index; i2 < this.index + this.count; ++i2) {
            TypeDescriptor.OfField in = this.source.parameterType(i2);
            assert (((Class)in).isAssignableFrom(componentType)) : "incoming type " + ((Class)in).getName() + " not compatible with " + componentType.getName() + "[]";
        }
    }

    @Override
    public String toString() {
        return "collect at " + this.index + " into " + this.arrayType.getName();
    }

    @Override
    public String toJava(MethodType incoming) {
        StringBuilder builder = new StringBuilder();
        if (!this.onlyTail()) {
            Permutes permutes = this.buildPermutes(this.source, incoming);
            Binder binder = this.preparePermuteBinder(permutes);
            return binder.toJava(incoming);
        }
        builder.append("handle = handle.asCollector(");
        Collect.buildClassArgument(builder, this.arrayType);
        builder.append(", ").append(this.count).append(");");
        return builder.toString();
    }

    private boolean onlyTail() {
        return this.index + this.count == this.source.parameterCount();
    }

    private Permutes buildPermutes(MethodType source2, MethodType target) {
        return new Permutes(source2, target, this.index, this.count);
    }

    private static class Permutes {
        private final int[] movePermute;
        private final int[] moveBackPermute;

        private Permutes(MethodType source2, MethodType target, int index2, int count2) {
            this.movePermute = new int[source2.parameterCount()];
            this.moveBackPermute = new int[target.parameterCount()];
            for (int i2 = 0; i2 < index2; ++i2) {
                this.movePermute[i2] = i2;
                this.moveBackPermute[i2] = i2;
            }
            int shifted = 0;
            int i3 = index2;
            while (i3 + count2 < this.movePermute.length) {
                this.movePermute[i3] = i3 + count2;
                ++i3;
                ++shifted;
            }
            i3 = index2;
            while (i3 + 1 < this.moveBackPermute.length) {
                this.moveBackPermute[i3 + 1] = i3;
                ++i3;
            }
            for (i3 = index2 + shifted; i3 < this.movePermute.length; ++i3) {
                this.movePermute[i3] = i3 - shifted;
            }
            this.moveBackPermute[index2] = this.moveBackPermute.length - 1;
        }
    }
}

