/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.constantine.platform;

import com.kenai.constantine.Constant;
import com.kenai.constantine.ConstantSet;
import java.lang.reflect.Array;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

@Deprecated
class ConstantResolver<E extends Enum<E>> {
    public static final String __UNKNOWN_CONSTANT__ = "__UNKNOWN_CONSTANT__";
    private final Object modLock = new Object();
    private final Class<E> enumType;
    private final Map<Integer, E> reverseLookupMap = new ConcurrentHashMap<Integer, E>();
    private final AtomicInteger nextUnknown;
    private final int lastUnknown;
    private final boolean bitmask;
    private Constant[] cache = null;
    private volatile E[] valueCache = null;
    private volatile int cacheGuard = 0;
    private volatile ConstantSet constants;

    private ConstantResolver(Class<E> enumType) {
        this(enumType, Integer.MIN_VALUE, -2147482648, false);
    }

    private ConstantResolver(Class<E> enumType, int firstUnknown, int lastUnknown, boolean bitmask) {
        this.enumType = enumType;
        this.nextUnknown = new AtomicInteger(firstUnknown);
        this.lastUnknown = lastUnknown;
        this.bitmask = bitmask;
    }

    static final <T extends Enum<T>> ConstantResolver<T> getResolver(Class<T> enumType) {
        return new ConstantResolver<T>(enumType);
    }

    static final <T extends Enum<T>> ConstantResolver<T> getResolver(Class<T> enumType, int first2, int last2) {
        return new ConstantResolver<T>(enumType, first2, last2, false);
    }

    static final <T extends Enum<T>> ConstantResolver<T> getBitmaskResolver(Class<T> enumType) {
        return new ConstantResolver<T>(enumType, 0, Integer.MIN_VALUE, true);
    }

    private Constant getConstant(E e) {
        Constant c;
        if (this.cacheGuard != 0 && (c = this.cache[((Enum)e).ordinal()]) != null) {
            return c;
        }
        return this.lookupAndCacheConstant(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Constant lookupAndCacheConstant(E e) {
        Object object = this.modLock;
        synchronized (object) {
            Constant c;
            if (this.cacheGuard != 0 && (c = this.cache[((Enum)e).ordinal()]) != null) {
                return c;
            }
            EnumSet<Enum> enums = EnumSet.allOf(this.enumType);
            ConstantSet cset = this.getConstants();
            if (this.cache == null) {
                this.cache = new Constant[enums.size()];
            }
            long known = 0L;
            long unknown = 0L;
            for (Enum v : enums) {
                c = cset.getConstant(v.name());
                if (c == null) {
                    if (this.bitmask) {
                        unknown |= 1L << v.ordinal();
                        c = new UnknownConstant(0, v.name());
                    } else {
                        c = new UnknownConstant(this.nextUnknown.getAndAdd(1), v.name());
                    }
                } else if (this.bitmask) {
                    known |= (long)c.value();
                }
                this.cache[v.ordinal()] = c;
            }
            if (this.bitmask) {
                long mask = 0L;
                while ((mask = Long.lowestOneBit(unknown)) != 0L) {
                    int index2 = Long.numberOfTrailingZeros(mask);
                    int sparebit = Long.numberOfTrailingZeros(Long.lowestOneBit(known ^ 0xFFFFFFFFFFFFFFFFL));
                    int value2 = 1 << sparebit;
                    this.cache[index2] = new UnknownConstant(value2, this.cache[index2].name());
                    known |= (long)value2;
                    unknown &= 1L << index2 ^ 0xFFFFFFFFFFFFFFFFL;
                }
            }
            this.cacheGuard = 1;
            return this.cache[((Enum)e).ordinal()];
        }
    }

    final int intValue(E e) {
        return this.getConstant(e).value();
    }

    final long longValue(E e) {
        return this.getConstant(e).longValue();
    }

    final String description(E e) {
        return this.getConstant(e).toString();
    }

    final E valueOf(int value2) {
        Enum e;
        if (value2 >= 0 && value2 < 256 && this.valueCache != null && (e = this.valueCache[value2]) != null) {
            return (E)e;
        }
        e = (Enum)this.reverseLookupMap.get(value2);
        if (e != null) {
            return (E)e;
        }
        Constant c = this.getConstants().getConstant(value2);
        if (c != null) {
            try {
                e = Enum.valueOf(this.enumType, c.name());
                this.reverseLookupMap.put(value2, e);
                if (c.value() >= 0 && c.value() < 256) {
                    Object[] values2 = this.valueCache;
                    if (values2 == null) {
                        values2 = (Enum[])Array.newInstance(this.enumType, 256);
                    }
                    values2[c.value()] = e;
                    this.valueCache = values2;
                }
                return (E)e;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        System.out.println("failed to reverse lookup value " + value2);
        return Enum.valueOf(this.enumType, __UNKNOWN_CONSTANT__);
    }

    private final ConstantSet getConstants() {
        if (this.constants == null) {
            this.constants = ConstantSet.getConstantSet(this.enumType.getSimpleName());
            if (this.constants == null) {
                throw new RuntimeException("Could not load platform constants for " + this.enumType.getSimpleName());
            }
        }
        return this.constants;
    }

    private static final class UnknownConstant
    implements Constant {
        private final int value;
        private final String name;

        UnknownConstant(int value2, String name2) {
            this.value = value2;
            this.name = name2;
        }

        @Override
        public int value() {
            return this.value;
        }

        @Override
        public int intValue() {
            return this.value;
        }

        @Override
        public long longValue() {
            return this.value;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public boolean defined() {
            return false;
        }

        public String toString() {
            return this.name;
        }
    }
}

