/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.thread;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyNumeric;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.thread.Queue;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"SizedQueue"}, parent="Queue")
public class SizedQueue
extends Queue {
    private final RubyThread.Task<IRubyObject, IRubyObject> blockingPushTask = new RubyThread.Task<IRubyObject, IRubyObject>(){

        @Override
        public IRubyObject run(ThreadContext context, IRubyObject value2) throws InterruptedException {
            SizedQueue.this.putInternal(context, value2);
            return SizedQueue.this;
        }

        @Override
        public void wakeup(RubyThread thread2, IRubyObject value2) {
            thread2.getNativeThread().interrupt();
        }
    };
    private final RubyThread.Task<IRubyObject, IRubyObject> nonblockingPushTask = new RubyThread.Task<IRubyObject, IRubyObject>(){

        @Override
        public IRubyObject run(ThreadContext context, IRubyObject value2) {
            if (!SizedQueue.this.offerInternal(context, value2)) {
                throw context.runtime.newThreadError("queue full");
            }
            return SizedQueue.this;
        }

        @Override
        public void wakeup(RubyThread thread2, IRubyObject value2) {
            thread2.getNativeThread().interrupt();
        }
    };

    protected SizedQueue(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    public SizedQueue(Ruby runtime2, RubyClass type2, int max2) {
        super(runtime2, type2);
        this.initialize(runtime2.getCurrentContext(), runtime2.newFixnum(max2));
    }

    public static void setup(Ruby runtime2) {
        RubyClass cSizedQueue = runtime2.getThread().defineClassUnder("SizedQueue", runtime2.getClass("Queue"), new ObjectAllocator(){

            @Override
            public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
                return new SizedQueue(runtime2, klass);
            }
        });
        cSizedQueue.setReifiedClass(SizedQueue.class);
        cSizedQueue.defineAnnotatedMethods(SizedQueue.class);
        runtime2.getObject().setConstant("SizedQueue", cSizedQueue);
    }

    @JRubyMethod
    public RubyNumeric max(ThreadContext context) {
        return RubyNumeric.int2fix(context.runtime, this.capacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"max="})
    public synchronized IRubyObject max_set(ThreadContext context, IRubyObject arg2) {
        this.initializedCheck();
        Ruby runtime2 = context.runtime;
        int max2 = RubyNumeric.num2int(arg2);
        int diff = 0;
        if (max2 <= 0) {
            throw runtime2.newArgumentError("queue size must be positive");
        }
        this.fullyLock();
        try {
            if (this.count.get() >= this.capacity && max2 > this.capacity) {
                diff = max2 - this.capacity;
            }
            this.capacity = max2;
            while (diff-- > 0) {
                this.notFull.signal();
            }
            IRubyObject iRubyObject = arg2;
            return iRubyObject;
        }
        finally {
            this.fullyUnlock();
        }
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public synchronized IRubyObject initialize(ThreadContext context, IRubyObject arg2) {
        this.capacity = Integer.MAX_VALUE;
        this.max_set(context, arg2);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    @JRubyMethod
    public RubyNumeric num_waiting(ThreadContext context) {
        this.initializedCheck();
        ReentrantLock takeLock = this.takeLock;
        ReentrantLock putLock = this.putLock;
        try {
            takeLock.lockInterruptibly();
            try {
                putLock.lockInterruptibly();
                try {
                    RubyFixnum rubyFixnum = context.runtime.newFixnum(takeLock.getWaitQueueLength(this.notEmpty) + putLock.getWaitQueueLength(this.notFull));
                    putLock.unlock();
                    return rubyFixnum;
                }
                catch (Throwable throwable) {
                    putLock.unlock();
                    throw throwable;
                }
            }
            finally {
                takeLock.unlock();
            }
        }
        catch (InterruptedException ie) {
            throw this.createInterruptedError(context, "num_waiting");
        }
    }

    @JRubyMethod(name={"push", "<<", "enq"}, required=1, optional=1)
    public IRubyObject push(ThreadContext context, IRubyObject[] argv2) {
        this.initializedCheck();
        boolean should_block = SizedQueue.shouldBlock(context, argv2);
        try {
            return context.getThread().executeTask(context, argv2[0], should_block ? this.blockingPushTask : this.nonblockingPushTask);
        }
        catch (InterruptedException ie) {
            throw this.createInterruptedError(context, "push");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean offerInternal(ThreadContext context, IRubyObject e) {
        if (e == null) {
            throw new NullPointerException();
        }
        AtomicInteger count2 = this.count;
        if (count2.get() == this.capacity) {
            return false;
        }
        int c = -1;
        Queue.Node node = new Queue.Node(e);
        ReentrantLock putLock = this.putLock;
        putLock.lock();
        try {
            if (this.closed) {
                this.raiseClosedError(context);
            }
            if (count2.get() < this.capacity) {
                this.enqueue(node);
                c = count2.getAndIncrement();
                if (c + 1 < this.capacity) {
                    this.notFull.signal();
                }
            }
        }
        finally {
            putLock.unlock();
        }
        if (c == 0) {
            this.signalNotEmpty();
        }
        return c >= 0;
    }

    private static boolean shouldBlock(ThreadContext context, IRubyObject[] argv2) {
        boolean should_block = true;
        Arity.checkArgumentCount(context, argv2, 1, 2);
        if (argv2.length > 1) {
            should_block = !argv2[1].isTrue();
        }
        return should_block;
    }
}

