/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.IScopingNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;

public class ClassNode
extends Node
implements IScopingNode {
    private final Colon3Node cpath;
    private final StaticScope scope;
    private final Node bodyNode;
    private final Node superNode;
    private final int endLine;

    public ClassNode(ISourcePosition position, Colon3Node cpath, StaticScope scope, Node bodyNode, Node superNode, int endLine) {
        super(position, cpath.containsVariableAssignment() || bodyNode.containsVariableAssignment() || superNode != null && superNode.containsVariableAssignment());
        assert (scope != null) : "scope is not null";
        assert (bodyNode != null) : "bodyNode is not null";
        this.cpath = cpath;
        this.scope = scope;
        this.bodyNode = bodyNode;
        this.superNode = superNode;
        this.endLine = endLine;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.CLASSNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitClassNode(this);
    }

    @Override
    public Node getBodyNode() {
        return this.bodyNode;
    }

    public int getEndLine() {
        return this.endLine;
    }

    @Override
    public StaticScope getScope() {
        return this.scope;
    }

    @Override
    public Colon3Node getCPath() {
        return this.cpath;
    }

    public Node getSuperNode() {
        return this.superNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList((Node)this.cpath, this.bodyNode, this.superNode);
    }
}

