/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jruby.ast.InvisibleNode;
import org.jruby.ast.NilImplicitNode;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.AbstractNodeVisitor;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.ISourcePositionHolder;

public abstract class Node
implements ISourcePositionHolder,
ISourcePosition {
    static final List<Node> EMPTY_LIST = new ArrayList<Node>();
    private int line;
    protected boolean containsVariableAssignment;
    protected boolean newline;

    public Node(ISourcePosition position, boolean containsAssignment) {
        this.line = position.getLine();
        this.containsVariableAssignment = containsAssignment;
    }

    public void setNewline() {
        this.newline = true;
    }

    public boolean isNewline() {
        return this.newline;
    }

    @Override
    public ISourcePosition getPosition() {
        return this;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public String getFile() {
        return null;
    }

    @Override
    public void setPosition(ISourcePosition position) {
        this.line = position.getLine();
    }

    public abstract <T> T accept(NodeVisitor<T> var1);

    public abstract List<Node> childNodes();

    protected static List<Node> createList(Node node) {
        return Collections.singletonList(node);
    }

    protected static List<Node> createList(Node node1, Node node2) {
        ArrayList<Node> list2 = new ArrayList<Node>(2);
        list2.add(node1);
        list2.add(node2);
        return list2;
    }

    protected static List<Node> createList(Node node1, Node node2, Node node3) {
        ArrayList<Node> list2 = new ArrayList<Node>(3);
        list2.add(node1);
        list2.add(node2);
        list2.add(node3);
        return list2;
    }

    protected static List<Node> createList(Node ... nodes) {
        ArrayList<Node> list2 = new ArrayList<Node>(nodes.length);
        for (Node node : nodes) {
            if (node == null) continue;
            list2.add(node);
        }
        return list2;
    }

    public String toString() {
        return this.toString(false, 0);
    }

    public String toString(boolean indent, int indentation) {
        if (this instanceof InvisibleNode) {
            return "";
        }
        StringBuilder builder = new StringBuilder(60);
        if (indent) {
            Node.indent(indentation, builder);
        }
        builder.append("(").append(this.getNodeName());
        String moreState = this.toStringInternal();
        if (moreState != null) {
            builder.append("[").append(moreState).append("]");
        }
        if (this instanceof INameNode) {
            builder.append(":").append(((INameNode)((Object)this)).getName());
        }
        builder.append(" ").append(this.getPosition().getLine());
        if (!this.childNodes().isEmpty() && indent) {
            builder.append("\n");
        }
        for (Node child : this.childNodes()) {
            if (!indent) {
                builder.append(", ");
            }
            if (child == null) {
                if (indent) {
                    Node.indent(indentation + 1, builder);
                }
                builder.append("null");
            } else if (indent && child instanceof NilImplicitNode) {
                Node.indent(indentation + 1, builder);
                builder.append(child.getClass().getSimpleName());
            } else {
                builder.append(child.toString(indent, indentation + 1));
            }
            if (!indent) continue;
            builder.append("\n");
        }
        if (!this.childNodes().isEmpty() && indent) {
            Node.indent(indentation, builder);
        }
        builder.append(")");
        return builder.toString();
    }

    protected String toStringInternal() {
        return null;
    }

    private static void indent(int indentation, StringBuilder builder) {
        for (int n = 0; n < indentation; ++n) {
            builder.append("  ");
        }
    }

    protected String getNodeName() {
        String name2 = this.getClass().getName();
        return name2.substring(name2.lastIndexOf(46) + 1);
    }

    public <T extends Node> T findFirstChild(final Class<T> nodeClass) {
        return (T)((Node)this.accept(new AbstractNodeVisitor<T>(){

            @Override
            protected T defaultVisit(Node node) {
                if (nodeClass.isAssignableFrom(node.getClass())) {
                    return node;
                }
                return (Node)this.visitFirstChild(node);
            }
        }));
    }

    public abstract NodeType getNodeType();

    public boolean isNil() {
        return false;
    }

    public boolean needsDefinitionCheck() {
        return true;
    }

    public boolean containsVariableAssignment() {
        return this.containsVariableAssignment;
    }
}

