/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.RubyModule;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.TwoOperandInstr;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ModuleVersionGuardInstr
extends TwoOperandInstr
implements FixedArityInstr {
    private final int expectedVersion;
    private final RubyModule module;

    public ModuleVersionGuardInstr(RubyModule module, int expectedVersion, Operand candidateObj, Label failurePathLabel) {
        super(Operation.MODULE_GUARD, candidateObj, failurePathLabel);
        this.module = module;
        this.expectedVersion = expectedVersion;
    }

    public Operand getCandidateObject() {
        return this.getOperand1();
    }

    public Label getFailurePathLabel() {
        return (Label)this.getOperand2();
    }

    public RubyModule getModule() {
        return this.module;
    }

    public int getExpectedVersion() {
        return this.expectedVersion;
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"name: " + this.module.getName(), "expected_version: " + this.expectedVersion};
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new ModuleVersionGuardInstr(this.module, this.expectedVersion, this.getCandidateObject().cloneForInlining(ii), ii.getRenamedLabel(this.getFailurePathLabel()));
    }

    private boolean versionMatches(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        IRubyObject receiver2 = (IRubyObject)this.getCandidateObject().retrieve(context, self2, currScope, currDynScope, temp);
        return receiver2.getMetaClass().getGeneration() == this.getExpectedVersion();
    }

    @Override
    public int interpretAndGetNewIPC(ThreadContext context, DynamicScope currDynScope, StaticScope currScope, IRubyObject self2, Object[] temp, int ipc) {
        return this.versionMatches(context, currScope, currDynScope, self2, temp) ? ipc : this.getFailurePathLabel().getTargetPC();
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ModuleVersionGuardInstr(this);
    }
}

