/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.net.InetSocketAddress;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.socket.RubyBasicSocket;
import org.jruby.ext.socket.SocketUtils;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.Sockaddr;

@JRubyClass(name={"IPSocket"}, parent="BasicSocket")
public class RubyIPSocket
extends RubyBasicSocket {
    private static ObjectAllocator IPSOCKET_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyIPSocket(runtime2, klass);
        }
    };

    static void createIPSocket(Ruby runtime2) {
        RubyClass rb_cIPSocket = runtime2.defineClass("IPSocket", runtime2.getClass("BasicSocket"), IPSOCKET_ALLOCATOR);
        rb_cIPSocket.defineAnnotatedMethods(RubyIPSocket.class);
        rb_cIPSocket.undefineMethod("initialize");
        runtime2.getObject().setConstant("IPsocket", rb_cIPSocket);
    }

    public RubyIPSocket(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    @JRubyMethod(name={"addr"})
    public IRubyObject addr(ThreadContext context) {
        return this.addrCommon(context, !context.getRuntime().isDoNotReverseLookupEnabled());
    }

    @JRubyMethod(name={"addr"})
    public IRubyObject addr(ThreadContext context, IRubyObject reverse2) {
        return this.addrCommon(context, reverse2);
    }

    @JRubyMethod(name={"peeraddr"})
    public IRubyObject peeraddr(ThreadContext context) {
        return this.peeraddrCommon(context, !context.getRuntime().isDoNotReverseLookupEnabled());
    }

    @JRubyMethod(name={"peeraddr"})
    public IRubyObject peeraddr(ThreadContext context, IRubyObject reverse2) {
        return this.peeraddrCommon(context, reverse2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject getaddress(ThreadContext context, IRubyObject self2, IRubyObject hostname) {
        return SocketUtils.getaddress(context, hostname);
    }

    @JRubyMethod
    public IRubyObject recvfrom(ThreadContext context, IRubyObject _length) {
        String hostName;
        String hostAddress;
        int port;
        Ruby runtime2 = context.runtime;
        IRubyObject result2 = this.recv(context, _length);
        InetSocketAddress sender = this.getInetRemoteSocket();
        if (sender == null) {
            port = 0;
            hostAddress = "0.0.0.0";
            hostName = "0.0.0.0";
        } else {
            port = sender.getPort();
            hostName = sender.getHostName();
            hostAddress = sender.getAddress().getHostAddress();
        }
        RubyArray addressArray = context.runtime.newArrayNoCopy(runtime2.newString("AF_INET"), runtime2.newFixnum(port), runtime2.newString(hostName), runtime2.newString(hostAddress));
        return runtime2.newArray(result2, (IRubyObject)addressArray);
    }

    @JRubyMethod
    public IRubyObject recvfrom(ThreadContext context, IRubyObject _length, IRubyObject _flags) {
        return this.recvfrom(context, _length);
    }

    @Override
    @JRubyMethod(name={"getpeereid"}, notImplemented=true)
    public IRubyObject getpeereid(ThreadContext context) {
        throw context.runtime.newNotImplementedError("getpeereid not implemented");
    }

    @Override
    protected IRubyObject getSocknameCommon(ThreadContext context, String caller2) {
        InetSocketAddress sock = this.getInetSocketAddress();
        return Sockaddr.packSockaddrFromAddress(context, sock);
    }

    @Override
    public IRubyObject getpeername(ThreadContext context) {
        InetSocketAddress sock = this.getInetRemoteSocket();
        return Sockaddr.packSockaddrFromAddress(context, sock);
    }

    private IRubyObject addrCommon(ThreadContext context, IRubyObject reverse2) {
        Boolean doReverse = RubyIPSocket.doReverseLookup(context, reverse2);
        if (doReverse == null) {
            doReverse = false;
        }
        return this.addrCommon(context, doReverse);
    }

    private IRubyObject addrCommon(ThreadContext context, boolean reverse2) {
        InetSocketAddress address2 = this.getInetSocketAddress();
        this.checkAddress(context, address2);
        return this.addrFor(context, address2, reverse2);
    }

    private void checkAddress(ThreadContext context, InetSocketAddress address2) {
        if (address2 == null) {
            throw context.runtime.newErrnoENOTSOCKError("Not socket or not connected");
        }
    }

    private IRubyObject peeraddrCommon(ThreadContext context, IRubyObject reverse2) {
        Boolean doReverse = RubyIPSocket.doReverseLookup(context, reverse2);
        if (doReverse == null) {
            doReverse = !context.runtime.isDoNotReverseLookupEnabled();
        }
        return this.peeraddrCommon(context, doReverse);
    }

    private IRubyObject peeraddrCommon(ThreadContext context, boolean reverse2) {
        InetSocketAddress address2 = this.getInetRemoteSocket();
        this.checkAddress(context, address2);
        return this.addrFor(context, address2, reverse2);
    }

    public static Boolean doReverseLookup(ThreadContext context, IRubyObject noreverse) {
        if (noreverse == context.tru) {
            return false;
        }
        if (noreverse == context.fals) {
            return true;
        }
        if (noreverse == context.nil) {
            return null;
        }
        Ruby runtime2 = context.runtime;
        TypeConverter.checkType(context, noreverse, runtime2.getSymbol());
        switch (noreverse.toString()) {
            case "numeric": {
                return true;
            }
            case "hostname": {
                return false;
            }
        }
        throw runtime2.newArgumentError("invalid reverse_lookup flag: " + noreverse);
    }

    @Deprecated
    public IRubyObject addr() {
        return this.addr(this.getRuntime().getCurrentContext());
    }

    @Deprecated
    public IRubyObject peeraddr() {
        return this.peeraddr(this.getRuntime().getCurrentContext());
    }

    @Deprecated
    public static IRubyObject getaddress(IRubyObject recv2, IRubyObject hostname) {
        return RubyIPSocket.getaddress(recv2.getRuntime().getCurrentContext(), recv2, hostname);
    }

    @Deprecated
    public IRubyObject recvfrom(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return this.recvfrom(context, args2[0]);
            }
            case 2: {
                return this.recvfrom(context, args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(context.runtime, args2, 1, 2);
        return null;
    }
}

