/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.List;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubySymbol;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.instructions.specialized.OneFixnumArgNoBlockCallInstr;
import org.jruby.ir.instructions.specialized.OneFloatArgNoBlockCallInstr;
import org.jruby.ir.instructions.specialized.OneOperandArgBlockCallInstr;
import org.jruby.ir.instructions.specialized.OneOperandArgNoBlockCallInstr;
import org.jruby.ir.instructions.specialized.TwoOperandArgNoBlockCallInstr;
import org.jruby.ir.instructions.specialized.ZeroOperandArgNoBlockCallInstr;
import org.jruby.ir.operands.Hash;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.util.KeyValuePair;

public class CallInstr
extends CallBase
implements ResultInstr {
    protected transient Variable result;

    public static CallInstr createWithKwargs(IRScope scope, CallType callType, Variable result2, RubySymbol name2, Operand receiver2, Operand[] args2, Operand closure, List<KeyValuePair<Operand, Operand>> kwargs) {
        Operand[] newArgs = new Operand[args2.length + 1];
        System.arraycopy(args2, 0, newArgs, 0, args2.length);
        newArgs[args2.length] = new Hash(kwargs, true);
        return CallInstr.create(scope, callType, result2, name2, receiver2, newArgs, closure);
    }

    public static CallInstr create(IRScope scope, Variable result2, RubySymbol name2, Operand receiver2, Operand[] args2, Operand closure) {
        return CallInstr.create(scope, CallType.NORMAL, result2, name2, receiver2, args2, closure);
    }

    public static CallInstr create(IRScope scope, CallType callType, Variable result2, RubySymbol name2, Operand receiver2, Operand[] args2, Operand closure) {
        boolean isPotentiallyRefined = scope.maybeUsingRefinements();
        if (!CallInstr.containsArgSplat(args2)) {
            boolean hasClosure;
            boolean bl = hasClosure = closure != null;
            if (args2.length == 0 && !hasClosure) {
                return new ZeroOperandArgNoBlockCallInstr(scope, callType, result2, name2, receiver2, args2, isPotentiallyRefined);
            }
            if (args2.length == 1) {
                if (hasClosure) {
                    return new OneOperandArgBlockCallInstr(scope, callType, result2, name2, receiver2, args2, closure, isPotentiallyRefined);
                }
                if (!isPotentiallyRefined) {
                    if (CallInstr.isAllFixnums(args2)) {
                        return new OneFixnumArgNoBlockCallInstr(scope, callType, result2, name2, receiver2, args2, isPotentiallyRefined);
                    }
                    if (CallInstr.isAllFloats(args2)) {
                        return new OneFloatArgNoBlockCallInstr(scope, callType, result2, name2, receiver2, args2, isPotentiallyRefined);
                    }
                }
                return new OneOperandArgNoBlockCallInstr(scope, callType, result2, name2, receiver2, args2, isPotentiallyRefined);
            }
            if (args2.length == 2 && !hasClosure) {
                return new TwoOperandArgNoBlockCallInstr(scope, callType, result2, name2, receiver2, args2, isPotentiallyRefined);
            }
        }
        return new CallInstr(scope, callType, result2, name2, receiver2, args2, closure, isPotentiallyRefined);
    }

    public CallInstr(IRScope scope, CallType callType, Variable result2, RubySymbol name2, Operand receiver2, Operand[] args2, Operand closure, boolean potentiallyRefined) {
        this(scope, Operation.CALL, callType, result2, name2, receiver2, args2, closure, potentiallyRefined);
    }

    protected CallInstr(IRScope scope, Operation op, CallType callType, Variable result2, RubySymbol name2, Operand receiver2, Operand[] args2, Operand closure, boolean potentiallyRefined, CallSite callSite, long callSiteId) {
        super(scope, op, callType, name2, receiver2, args2, closure, potentiallyRefined, callSite, callSiteId);
        assert (result2 != null);
        this.result = result2;
    }

    protected CallInstr(IRScope scope, Operation op, CallType callType, Variable result2, RubySymbol name2, Operand receiver2, Operand[] args2, Operand closure, boolean potentiallyRefined) {
        super(scope, op, callType, name2, receiver2, args2, closure, potentiallyRefined);
        assert (result2 != null);
        this.result = result2;
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getResult());
    }

    public static CallInstr decode(IRReaderDecoder d) {
        Operand closure;
        int argsLength;
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decodeCall");
        }
        int callTypeOrdinal = d.decodeInt();
        CallType callType = CallType.fromOrdinal(callTypeOrdinal);
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decodeCall - calltype:  " + (Object)((Object)callType));
        }
        RubySymbol name2 = d.decodeSymbol();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decodeCall - methaddr:  " + name2);
        }
        Operand receiver2 = d.decodeOperand();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decodeCall - receiver:  " + receiver2);
        }
        int argsCount = d.decodeInt();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decodeCall - # of args:  " + argsCount);
        }
        boolean hasClosureArg = argsCount < 0;
        int n = argsLength = hasClosureArg ? -1 * (argsCount + 1) : argsCount;
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decodeCall - # of args(2): " + argsLength);
        }
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decodeCall - hasClosure: " + hasClosureArg);
        }
        Operand[] args2 = new Operand[argsLength];
        for (int i2 = 0; i2 < argsLength; ++i2) {
            args2[i2] = d.decodeOperand();
        }
        Operand operand = closure = hasClosureArg ? d.decodeOperand() : null;
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("before result");
        }
        Variable result2 = d.decodeVariable();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decoding call, result:  " + result2);
        }
        return CallInstr.create(d.getCurrentScope(), callType, result2, name2, receiver2, args2, closure);
    }

    @Override
    public Variable getResult() {
        return this.result;
    }

    @Override
    public void updateResult(Variable v) {
        this.result = v;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new CallInstr(ii.getScope(), this.getOperation(), this.getCallType(), ii.getRenamedVariable(this.result), this.getName(), this.getReceiver().cloneForInlining(ii), this.cloneCallArgs(ii), this.getClosureArg() == null ? null : this.getClosureArg().cloneForInlining(ii), this.isPotentiallyRefined(), this.getCallSite(), this.getCallSiteId());
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.CallInstr(this);
    }
}

