/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.passes;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jruby.ir.IRScope;
import org.jruby.ir.passes.CompilerPassListener;
import org.jruby.util.StringSupport;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public abstract class CompilerPass {
    static final Logger LOG = LoggerFactory.getLogger(CompilerPass.class);
    private static final List<Class<? extends CompilerPass>> NO_DEPENDENCIES = Collections.emptyList();

    public abstract String getLabel();

    public String getShortLabel() {
        return this.getLabel();
    }

    public int hashCode() {
        return this.getLabel().hashCode();
    }

    public boolean equals(Object other) {
        return other != null && other instanceof CompilerPass && this.getLabel() == ((CompilerPass)other).getLabel();
    }

    public abstract Object execute(IRScope var1, Object ... var2);

    public List<Class<? extends CompilerPass>> getDependencies() {
        return NO_DEPENDENCIES;
    }

    public Object previouslyRun(IRScope scope) {
        return scope.getExecutedPasses().contains(this) ? new Object() : null;
    }

    public boolean invalidate(IRScope scope) {
        scope.getExecutedPasses().remove(this);
        return true;
    }

    protected Object run(IRScope scope, boolean force, boolean childScope) {
        Object prevData = null;
        if (!force && (prevData = this.previouslyRun(scope)) != null) {
            return prevData;
        }
        List<Class<? extends CompilerPass>> dependencies = this.getDependencies();
        Object[] data2 = new Object[dependencies.size()];
        for (int i2 = 0; i2 < data2.length; ++i2) {
            data2[i2] = this.makeSureDependencyHasRunOnce(dependencies.get(i2), scope, childScope);
        }
        for (CompilerPassListener listener : scope.getManager().getListeners()) {
            listener.startExecute(this, scope, childScope);
        }
        scope.getExecutedPasses().add(this);
        Object passData = this.execute(scope, data2);
        for (CompilerPassListener listener : scope.getManager().getListeners()) {
            listener.endExecute(this, scope, passData, childScope);
        }
        return passData;
    }

    public Object run(IRScope scope, boolean force) {
        return this.run(scope, force, false);
    }

    public Object run(IRScope scope) {
        return this.run(scope, false, false);
    }

    private Object makeSureDependencyHasRunOnce(Class<? extends CompilerPass> passClass, IRScope scope, boolean childScope) {
        CompilerPass pass2 = CompilerPass.createPassInstance(passClass);
        Object data2 = pass2.previouslyRun(scope);
        if (data2 == null) {
            data2 = pass2.run(scope, false, childScope);
        } else {
            for (CompilerPassListener listener : scope.getManager().getListeners()) {
                listener.alreadyExecuted(pass2, scope, data2, childScope);
            }
        }
        return data2;
    }

    public static CompilerPass createPassInstance(Class<? extends CompilerPass> passClass) {
        try {
            return passClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException ex) {
            LOG.error("failed to create compiler pass: '" + passClass.getName() + "'", ex);
        }
        catch (InstantiationException | SecurityException | InvocationTargetException ex) {
            LOG.error("failed to create compiler pass: '" + passClass.getName() + "'", ex);
        }
        return null;
    }

    public static CompilerPass createPassInstance(String passClassName) {
        String className = "org.jruby.ir.passes." + passClassName;
        try {
            Class<?> clazz = Class.forName(className);
            return CompilerPass.createPassInstance(clazz);
        }
        catch (ClassNotFoundException ex) {
            LOG.warn("skipping unknown compiler pass name: '" + className + "'", new Object[0]);
            return null;
        }
    }

    public static List<CompilerPass> getPassesFromString(String passList, String defaultPassList) {
        ArrayList<CompilerPass> passes;
        if (passList == null) {
            passList = defaultPassList;
        }
        if (!passList.isEmpty()) {
            List<String> split2 = StringSupport.split(passList, ',');
            passes = new ArrayList(split2.size());
            for (String passClassName : split2) {
                CompilerPass pass2;
                if (passClassName.isEmpty() || (pass2 = CompilerPass.createPassInstance(passClassName)) == null) continue;
                passes.add(pass2);
            }
        } else {
            passes = new ArrayList<CompilerPass>(2);
        }
        return passes;
    }
}

