/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.persistence;

import java.io.IOException;
import org.jruby.EvalType;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.ir.IRClassBody;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IREvalScript;
import org.jruby.ir.IRFor;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRMetaClassBody;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRModuleBody;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.persistence.IRPersistenceValues;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.parser.StaticScope;
import org.jruby.parser.StaticScopeFactory;
import org.jruby.runtime.Signature;
import org.jruby.util.ByteList;

public class IRReader
implements IRPersistenceValues {
    public static IRScope load(IRManager manager, IRReaderDecoder file2) throws IOException {
        int version = file2.decodeIntRaw();
        if (version != 2) {
            throw new IOException("Trying to read incompatible persistence format (version found: " + version + ", version expected: " + 2);
        }
        int headersOffset = file2.decodeIntRaw();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("header_offset = " + headersOffset);
        }
        file2.seek(headersOffset);
        int scopesToRead = file2.decodeInt();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("scopes to read = " + scopesToRead);
        }
        IRScope firstScope = null;
        for (int i2 = 0; i2 < scopesToRead; ++i2) {
            IRScope scope = IRReader.decodeScopeHeader(manager, file2);
            if (firstScope == null) {
                firstScope = scope;
            }
            int instructionsOffset = file2.decodeInt();
            int poolOffset = file2.decodeInt();
            scope.allocateInterpreterContext(() -> file2.decodeInstructionsAt(scope, poolOffset, instructionsOffset));
        }
        return firstScope;
    }

    private static IRScope decodeScopeHeader(IRManager manager, IRReaderDecoder decoder) {
        Signature signature;
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("DECODING SCOPE HEADER");
        }
        IRScopeType type2 = decoder.decodeIRScopeType();
        int line = decoder.decodeInt();
        int tempVarsCount = decoder.decodeInt();
        int nextLabelInt = decoder.decodeInt();
        boolean isEND = false;
        if (type2 == IRScopeType.CLOSURE || type2 == IRScopeType.FOR) {
            isEND = decoder.decodeBoolean();
            signature = Signature.decode(decoder.decodeLong());
        } else {
            signature = Signature.OPTIONAL;
        }
        String file2 = null;
        ByteList name2 = null;
        IRScope parent = null;
        if (type2 == IRScopeType.SCRIPT_BODY) {
            file2 = decoder.decodeString();
        } else {
            name2 = decoder.decodeByteList();
            parent = decoder.decodeScope();
        }
        StaticScope parentScope = parent == null ? null : parent.getStaticScope();
        StaticScope staticScope = IRReader.decodeStaticScope(decoder, parentScope);
        IRScope scope = IRReader.createScope(manager, type2, name2, file2, line, parent, signature, staticScope);
        if (scope instanceof IRClosure && isEND) {
            ((IRClosure)scope).setIsEND();
        }
        scope.setTemporaryVariableCount(tempVarsCount);
        scope.setNextLabelIndex(nextLabelInt);
        decoder.addScope(scope);
        return scope;
    }

    private static StaticScope decodeStaticScope(IRReaderDecoder decoder, StaticScope parentScope) {
        StaticScope scope = StaticScopeFactory.newStaticScope(parentScope, decoder.decodeStaticScopeType(), decoder.decodeStringArray(), decoder.decodeInt());
        scope.setSignature(decoder.decodeSignature());
        return scope;
    }

    public static IRScope createScope(IRManager manager, IRScopeType type2, ByteList byteName, String file2, int line, IRScope lexicalParent, Signature signature, StaticScope staticScope) {
        Ruby runtime2 = manager.getRuntime();
        switch (type2) {
            case CLASS_BODY: {
                return new IRClassBody(manager, lexicalParent, byteName, line, staticScope, false);
            }
            case METACLASS_BODY: {
                return new IRMetaClassBody(manager, lexicalParent, manager.getMetaClassName().getBytes(), line, staticScope);
            }
            case INSTANCE_METHOD: {
                return new IRMethod(manager, lexicalParent, null, byteName, true, line, staticScope, false);
            }
            case CLASS_METHOD: {
                return new IRMethod(manager, lexicalParent, null, byteName, false, line, staticScope, false);
            }
            case MODULE_BODY: {
                return new IRModuleBody(manager, lexicalParent, byteName, line, staticScope, false);
            }
            case SCRIPT_BODY: {
                return new IRScriptBody(manager, file2, staticScope);
            }
            case FOR: {
                return new IRFor(manager, lexicalParent, line, staticScope, signature);
            }
            case CLOSURE: {
                return new IRClosure(manager, lexicalParent, line, staticScope, signature);
            }
            case EVAL_SCRIPT: {
                return new IREvalScript(manager, lexicalParent, lexicalParent.getFileName(), line, staticScope, EvalType.NONE);
            }
        }
        throw new RuntimeException("No such scope type: " + (Object)((Object)type2));
    }
}

