/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.management;

import java.lang.ref.SoftReference;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jruby.Ruby;
import org.jruby.management.ParserStatsMBean;

public class ParserStats
implements ParserStatsMBean {
    private final SoftReference<Ruby> ruby;
    private AtomicInteger totalParseTime = new AtomicInteger(0);
    private AtomicLong totalParsedBytes = new AtomicLong(0L);
    private AtomicInteger totalEvalParses = new AtomicInteger(0);
    private AtomicInteger totalLoadParses = new AtomicInteger(0);
    private AtomicInteger totalJRubyModuleParses = new AtomicInteger(0);

    public ParserStats(Ruby ruby) {
        this.ruby = new SoftReference<Ruby>(ruby);
    }

    public void addParseTime(int time) {
        this.totalParseTime.addAndGet(time);
    }

    public void addParsedBytes(int bytes2) {
        this.totalParsedBytes.addAndGet(bytes2);
    }

    public void addEvalParse() {
        this.totalEvalParses.incrementAndGet();
    }

    public void addLoadParse() {
        this.totalLoadParses.incrementAndGet();
    }

    public void addJRubyModuleParse() {
        this.totalJRubyModuleParses.incrementAndGet();
    }

    @Override
    public double getTotalParseTime() {
        Ruby runtime2 = this.ruby.get();
        if (runtime2 == null) {
            return 0.0;
        }
        return (double)runtime2.getParser().getTotalTime() / 1.0E9;
    }

    @Override
    public long getTotalParsedBytes() {
        Ruby runtime2 = this.ruby.get();
        if (runtime2 == null) {
            return 0L;
        }
        return runtime2.getParser().getTotalBytes();
    }

    @Override
    public double getParseTimePerKB() {
        long totalBytes = this.getTotalParsedBytes();
        if (totalBytes == 0L) {
            return 0.0;
        }
        return this.getTotalParseTime() / ((double)totalBytes / 1000.0);
    }

    @Override
    public int getNumberOfEvalParses() {
        return this.totalEvalParses.get();
    }

    @Override
    public int getNumberOfLoadParses() {
        return this.totalLoadParses.get();
    }
}

