/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.load;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LoadServiceResourceInputStream
extends ByteArrayInputStream {
    private static final byte[] NULL_BYTE_ARRAY = new byte[0];
    private static final int READ_CHUNK_SIZE = 16384;

    public LoadServiceResourceInputStream(byte[] bytes2) {
        super(bytes2);
    }

    public LoadServiceResourceInputStream(InputStream stream) throws IOException {
        super(NULL_BYTE_ARRAY);
        this.bufferEntireStream(stream);
    }

    public byte[] getBytes() {
        if (this.buf.length != this.count) {
            byte[] b2 = new byte[this.count];
            System.arraycopy(this.buf, 0, b2, 0, this.count);
            return b2;
        }
        return this.buf;
    }

    private void bufferEntireStream(InputStream stream) throws IOException {
        int bytesRead;
        byte[] chunk2 = new byte[16384];
        while ((bytesRead = stream.read(chunk2)) != -1) {
            byte[] newbuf = new byte[this.buf.length + bytesRead];
            System.arraycopy(this.buf, 0, newbuf, 0, this.buf.length);
            System.arraycopy(chunk2, 0, newbuf, this.buf.length, bytesRead);
            this.buf = newbuf;
            this.count = this.buf.length;
        }
    }
}

