/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor;

import java.net.URI;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.asciidoctor.CompatMode;
import org.asciidoctor.Placement;

public class Attributes {
    private static final char ATTRIBUTE_SEPARATOR = '=';
    private static Format DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static Format TIME_FORMAT = new SimpleDateFormat("HH:mm:ss z");
    public static final String BACKEND = "backend";
    public static final String TITLE = "title";
    public static final String DOCTYPE = "doctype";
    public static final String IMAGESDIR = "imagesdir";
    public static final String SOURCE_HIGHLIGHTER = "source-highlighter";
    public static final String SOURCE_LANGUAGE = "source-language";
    public static final String LOCALDATE = "localdate";
    public static final String LOCALTIME = "localtime";
    public static final String DOCDATE = "docdate";
    public static final String DOCTIME = "doctime";
    public static final String TOC = "toc";
    public static final String STYLESHEET_NAME = "stylesheet";
    public static final String STYLES_DIR = "stylesdir";
    public static final String NOT_STYLESHEET_NAME = "stylesheet!";
    public static final String LINK_CSS = "linkcss";
    public static final String COPY_CSS = "copycss";
    public static final String ICONS = "icons";
    public static final String ICONFONT_REMOTE = "iconfont-remote";
    public static final String ICONFONT_CDN = "iconfont-cdn";
    public static final String ICONFONT_NAME = "iconfont-name";
    public static final String ICONS_DIR = "iconsdir";
    public static final String DATA_URI = "data-uri";
    public static final String SECTION_NUMBERS = "numbered";
    public static final String IMAGE_ICONS = "";
    public static final String FONT_ICONS = "font";
    public static final String LINK_ATTRS = "linkattrs";
    public static final String EXPERIMENTAL = "experimental";
    public static final String SHOW_TITLE = "showtitle";
    public static final String NOTITLE = "notitle";
    public static final String ALLOW_URI_READ = "allow-uri-read";
    public static final String TOC_POSITION = "toc-position";
    public static final String TOC_2 = "toc2";
    public static final String IGNORE_UNDEFINED = "ignore-undefined";
    public static final String UNTITLED_LABEL = "untitled-label";
    public static final String SET_ANCHORS = "sectanchors";
    public static final String SKIP_FRONT_MATTER = "skip-front-matter";
    public static final String MAX_INCLUDE_DEPTH = "max-include-depth";
    public static final String ATTRIBUTE_MISSING = "attribute-missing";
    public static final String ATTRIBUTE_UNDEFINED = "attribute-undefined";
    public static final String NO_FOOTER = "nofooter";
    public static final String HARDBREAKS = "hardbreaks";
    public static final String SECT_NUM_LEVELS = "sectnumlevels";
    public static final String CACHE_URI = "cache-uri";
    public static final String MATH = "stem";
    public static final String APPENDIX_CAPTION = "appendix-caption";
    public static final String HIDE_URI_SCHEME = "hide-uri-scheme";
    public static final String COMPAT_MODE = "compat-mode";
    private Map<String, Object> attributes = new LinkedHashMap<String, Object>();

    public Attributes() {
    }

    public Attributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public Attributes(String[] attributes) {
        this.setAttributes(attributes);
    }

    public Attributes(String attributes) {
        this.setAttributes(attributes);
    }

    public void setAllowUriRead(boolean allowUriRead) {
        this.attributes.put(ALLOW_URI_READ, Attributes.toAsciidoctorFlag(allowUriRead));
    }

    public void setAttributeMissing(String attributeMissing) {
        this.attributes.put(ATTRIBUTE_MISSING, attributeMissing);
    }

    public void setAttributeUndefined(String attributeUndefined) {
        this.attributes.put(ATTRIBUTE_UNDEFINED, attributeUndefined);
    }

    public void setBackend(String backend) {
        this.attributes.put(BACKEND, backend);
    }

    public void setTitle(String title) {
        this.attributes.put(TITLE, title);
    }

    public void setDocType(String docType) {
        this.attributes.put(DOCTYPE, docType);
    }

    public void setImagesDir(String imagesDir) {
        this.attributes.put(IMAGESDIR, imagesDir);
    }

    public void setSourceLanguage(String sourceLanguage) {
        this.attributes.put(SOURCE_LANGUAGE, sourceLanguage);
    }

    public void setSourceHighlighter(String sourceHighlighter) {
        this.attributes.put(SOURCE_HIGHLIGHTER, sourceHighlighter);
    }

    public void setMaxIncludeDepth(int maxIncludeDepth) {
        this.attributes.put(MAX_INCLUDE_DEPTH, maxIncludeDepth);
    }

    public void setSectNumLevels(int sectNumLevels) {
        this.attributes.put(SECT_NUM_LEVELS, sectNumLevels);
    }

    public void setHardbreaks(boolean hardbreaks) {
        this.attributes.put(HARDBREAKS, Attributes.toAsciidoctorFlag(hardbreaks));
    }

    public void setCacheUri(boolean cacheUri) {
        this.attributes.put(CACHE_URI, Attributes.toAsciidoctorFlag(cacheUri));
    }

    public void setHideUriScheme(boolean hideUriScheme) {
        this.attributes.put(HIDE_URI_SCHEME, Attributes.toAsciidoctorFlag(hideUriScheme));
    }

    public void setAppendixCaption(String appendixCaption) {
        this.attributes.put(APPENDIX_CAPTION, appendixCaption);
    }

    public void setMath(String math) {
        this.attributes.put(MATH, math);
    }

    public void setSkipFrontMatter(boolean skipFrontMatter) {
        this.attributes.put(SKIP_FRONT_MATTER, Attributes.toAsciidoctorFlag(skipFrontMatter));
    }

    public void setAnchors(boolean setAnchors) {
        this.attributes.put(SET_ANCHORS, setAnchors);
    }

    public void setUntitledLabel(String untitledLabel) {
        this.attributes.put(UNTITLED_LABEL, untitledLabel);
    }

    public void setIgnoreUndefinedAttributes(boolean ignoreUndefinedAttributes) {
        this.attributes.put(IGNORE_UNDEFINED, Attributes.toAsciidoctorFlag(ignoreUndefinedAttributes));
    }

    public void setTableOfContents2(Placement placement) {
        this.attributes.put(TOC_2, Attributes.toAsciidoctorFlag(true));
        this.attributes.put(TOC_POSITION, placement.getPosition());
    }

    public void setTableOfContents(Placement placement) {
        this.attributes.put(TOC, Attributes.toAsciidoctorFlag(true));
        this.attributes.put(TOC_POSITION, placement.getPosition());
    }

    public void setShowTitle(boolean showTitle) {
        if (showTitle) {
            this.attributes.put(SHOW_TITLE, true);
            this.attributes.remove(NOTITLE);
        } else {
            this.attributes.put(NOTITLE, true);
            this.attributes.remove(SHOW_TITLE);
        }
    }

    public void setTableOfContents(boolean toc) {
        this.attributes.put(TOC, Attributes.toAsciidoctorFlag(toc));
    }

    public void setLocalDate(Date localDate) {
        this.attributes.put(LOCALDATE, Attributes.toDate(localDate));
    }

    public void setLocalTime(Date localTime) {
        this.attributes.put(LOCALTIME, Attributes.toTime(localTime));
    }

    public void setDocDate(Date docDate) {
        this.attributes.put(DOCDATE, Attributes.toDate(docDate));
    }

    public void setDocTime(Date docTime) {
        this.attributes.put(DOCTIME, Attributes.toTime(docTime));
    }

    public void setStyleSheetName(String styleSheetName) {
        this.attributes.put(STYLESHEET_NAME, styleSheetName);
    }

    public void unsetStyleSheet() {
        this.attributes.put(NOT_STYLESHEET_NAME, Attributes.toAsciidoctorFlag(true));
    }

    public void setStylesDir(String stylesDir) {
        this.attributes.put(STYLES_DIR, stylesDir);
    }

    public void setLinkCss(boolean linkCss) {
        this.attributes.put(LINK_CSS, Attributes.toAsciidoctorFlag(linkCss));
    }

    public void setCopyCss(boolean copyCss) {
        this.attributes.put(COPY_CSS, Attributes.toAsciidoctorFlag(copyCss));
    }

    public void setIcons(String iconsName) {
        this.attributes.put(ICONS, iconsName);
    }

    public void setIconFontRemote(boolean iconFontRemote) {
        this.attributes.put(ICONFONT_REMOTE, Attributes.toAsciidoctorFlag(iconFontRemote));
    }

    public void setIconFontCdn(URI cdnUri) {
        this.attributes.put(ICONFONT_CDN, cdnUri.toASCIIString());
    }

    public void setIconFontName(String iconFontName) {
        this.attributes.put(ICONFONT_NAME, iconFontName);
    }

    public void setDataUri(boolean dataUri) {
        this.attributes.put(DATA_URI, Attributes.toAsciidoctorFlag(dataUri));
    }

    public void setIconsDir(String iconsDir) {
        this.attributes.put(ICONS_DIR, iconsDir);
    }

    public void setSectionNumbers(boolean sectionNumbers) {
        this.attributes.put(SECTION_NUMBERS, Attributes.toAsciidoctorFlag(sectionNumbers));
    }

    public void setLinkAttrs(boolean linkAttrs) {
        this.attributes.put(LINK_ATTRS, Attributes.toAsciidoctorFlag(linkAttrs));
    }

    public void setExperimental(boolean experimental) {
        this.attributes.put(EXPERIMENTAL, experimental);
    }

    public void setNoFooter(boolean noFooter) {
        this.attributes.put(NO_FOOTER, Attributes.toAsciidoctorFlag(noFooter));
    }

    public void setCompatMode(CompatMode compatMode) {
        this.attributes.put(COMPAT_MODE, compatMode.getMode());
    }

    public void setAttribute(String attributeName, Object attributeValue) {
        this.attributes.put(attributeName, attributeValue);
    }

    public void setAttributes(String attributes) {
        String[] allAttributes = attributes.split(" ");
        this.addAttributes(allAttributes);
    }

    public void setAttributes(String ... attributes) {
        this.addAttributes(attributes);
    }

    private void addAttributes(String[] allAttributes) {
        for (String attribute : allAttributes) {
            int equalsIndex = attribute.indexOf(61);
            if (equalsIndex > -1) {
                this.extractAttributeNameAndValue(attribute, equalsIndex);
                continue;
            }
            this.attributes.put(attribute, IMAGE_ICONS);
        }
    }

    private void extractAttributeNameAndValue(String attribute, int equalsIndex) {
        String attributeName = attribute.substring(0, equalsIndex);
        String attributeValue = attribute.substring(equalsIndex + 1, attribute.length());
        this.attributes.put(attributeName, attributeValue);
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes.putAll(attributes);
    }

    public Map<String, Object> map() {
        return this.attributes;
    }

    public static String toAsciidoctorFlag(boolean flag) {
        return flag ? IMAGE_ICONS : null;
    }

    private static String toDate(Date date) {
        return DATE_FORMAT.format(date);
    }

    private static String toTime(Date time) {
        return TIME_FORMAT.format(time);
    }
}

