/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.jruby.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.asciidoctor.jruby.internal.RubyHashMapDecorator;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubyString;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyAttributesMapDecorator
implements Map<String, Object> {
    private final RubyHash rubyHash;

    public RubyAttributesMapDecorator(RubyHash rubyHash) {
        this.rubyHash = rubyHash;
    }

    @Override
    public int size() {
        return this.rubyHash.size();
    }

    @Override
    public boolean isEmpty() {
        return this.rubyHash.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (!(key instanceof String)) {
            return false;
        }
        return this.rubyHash.containsKey(this.convertJavaToRubyKey((String)key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.rubyHash.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        if (!(key instanceof String)) {
            return false;
        }
        Object value = this.rubyHash.get(this.convertJavaToRubyKey((String)key));
        return this.convertRubyValue(value);
    }

    @Override
    public Object put(String key, Object value) {
        Object convertedKey = this.convertJavaToRubyKey(key);
        Object oldValue = this.rubyHash.get(convertedKey);
        this.rubyHash.put(convertedKey, (Object)this.convertJavaValue(value));
        return oldValue;
    }

    @Override
    public Object remove(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        Object convertedKey = this.convertJavaToRubyKey((String)key);
        Object oldValue = this.rubyHash.get(convertedKey);
        this.rubyHash.remove(convertedKey);
        return this.convertRubyValue(oldValue);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        for (Map.Entry<String, ?> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.rubyHash.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.createJavaMap().keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.createJavaMap().values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.createJavaMap().entrySet();
    }

    private Map<String, Object> createJavaMap() {
        HashMap<String, Object> copy = new HashMap<String, Object>();
        Set rubyEntrySet = this.rubyHash.entrySet();
        for (Map.Entry o : rubyEntrySet) {
            String key;
            Object rubyKey = o.getKey();
            Object rubyValue = o.getValue();
            if (rubyKey instanceof RubyString) {
                key = ((RubyString)rubyKey).asJavaString();
            } else if (rubyKey instanceof String) {
                key = (String)rubyKey;
            } else {
                if (!(rubyKey instanceof Number)) continue;
                key = String.valueOf(rubyKey);
            }
            Object value = this.convertRubyValue(rubyValue);
            copy.put(key, value);
        }
        return copy;
    }

    private Object convertRubyValue(Object rubyValue) {
        if (rubyValue == null) {
            return null;
        }
        if (rubyValue instanceof IRubyObject) {
            return JavaEmbedUtils.rubyToJava((IRubyObject)((IRubyObject)rubyValue));
        }
        return rubyValue;
    }

    private IRubyObject convertJavaValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String && ((String)value).startsWith(":")) {
            return this.rubyHash.getRuntime().getSymbolTable().getSymbol(((String)value).substring(1));
        }
        return JavaEmbedUtils.javaToRuby((Ruby)this.rubyHash.getRuntime(), (Object)value);
    }

    private Object convertJavaToRubyKey(String keyString) {
        Object convertedKey = this.isDigits(keyString) ? Long.valueOf(Long.parseLong(keyString)) : keyString;
        return convertedKey;
    }

    private boolean isDigits(String arg) {
        if (arg.length() == 0) {
            return false;
        }
        for (int i = 0; i < arg.length(); ++i) {
            char c = arg.charAt(i);
            if (c >= '0' && '9' >= c) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.createJavaMap().toString();
    }

    public Object dup() {
        return new RubyHashMapDecorator((RubyHash)this.rubyHash.dup());
    }
}

