/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyObject;
import org.jruby.RubyStandardError;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.NameError;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ArraySupport;
import org.jruby.util.ByteList;
import org.jruby.util.Sprintf;

@JRubyClass(name={"NameError"}, parent="StandardError")
public class RubyNameError
extends RubyStandardError {
    private IRubyObject name;
    private IRubyObject receiver;
    protected boolean privateCall;

    static RubyClass define(Ruby runtime2, RubyClass StandardError2) {
        RubyClass NameError2 = runtime2.defineClass("NameError", StandardError2, RubyNameError::new);
        NameError2.defineAnnotatedMethods(RubyNameError.class);
        NameError2.setReifiedClass(RubyNameError.class);
        return NameError2;
    }

    protected RubyNameError(Ruby runtime2, RubyClass exceptionClass) {
        this(runtime2, exceptionClass, exceptionClass.getName());
    }

    public RubyNameError(Ruby runtime2, RubyClass exceptionClass, String message2) {
        this(runtime2, exceptionClass, message2, (String)null);
    }

    public RubyNameError(Ruby runtime2, RubyClass exceptionClass, String message2, String name2) {
        super(runtime2, exceptionClass, message2);
        this.name = name2 == null ? runtime2.getNil() : RubySymbol.newSymbol(runtime2, name2);
    }

    public RubyNameError(Ruby runtime2, RubyClass exceptionClass, String message2, IRubyObject name2) {
        super(runtime2, exceptionClass, message2);
        this.name = name2;
    }

    @Override
    protected RaiseException constructThrowable(String message2) {
        return new NameError(message2, this);
    }

    @JRubyMethod(name={"exception"}, meta=true)
    public static IRubyObject exception(ThreadContext context, IRubyObject recv2) {
        return RubyNameError.newNameError(recv2, NULL_ARRAY);
    }

    @JRubyMethod(name={"exception"}, meta=true)
    public static RubyException exception(ThreadContext context, IRubyObject recv2, IRubyObject message2) {
        return RubyNameError.newNameError(recv2, new IRubyObject[]{message2});
    }

    @JRubyMethod(name={"exception"}, meta=true)
    public static RubyException exception(ThreadContext context, IRubyObject recv2, IRubyObject message2, IRubyObject name2) {
        return RubyNameError.newNameError(recv2, message2, name2, false);
    }

    private static RubyException newNameError(IRubyObject recv2, IRubyObject[] args2) {
        RubyClass klass = (RubyClass)recv2;
        RubyException newError = (RubyException)klass.allocate();
        newError.callInit(args2, Block.NULL_BLOCK);
        return newError;
    }

    static RubyException newNameError(IRubyObject recv2, IRubyObject message2, IRubyObject name2, boolean privateCall) {
        RubyClass klass = (RubyClass)recv2;
        RubyNameError newError = (RubyNameError)klass.allocate();
        newError.callInit(message2, name2, Block.NULL_BLOCK);
        newError.privateCall = privateCall;
        return newError;
    }

    @Override
    @JRubyMethod(rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args2, Block block) {
        RubyHash options2 = null;
        if (args2.length > 0 && args2[args2.length - 1] != null && args2[args2.length - 1] instanceof RubyHash) {
            options2 = (RubyHash)args2[args2.length - 1];
            args2 = ArraySupport.newCopy(args2, args2.length - 1);
        }
        return this.initializeOptions(args2, options2, block);
    }

    public IRubyObject initializeOptions(IRubyObject[] args2, RubyHash options2, Block block) {
        IRubyObject[] values2;
        String[] keywords = new String[]{"receiver"};
        if (args2.length > 0) {
            this.message = args2[0];
        }
        if (this.message instanceof RubyNameErrorMessage) {
            this.receiver = ((RubyNameErrorMessage)this.message).object;
        }
        IRubyObject iRubyObject = this.name = args2.length > 1 ? args2[1] : this.getRuntime().getNil();
        if (options2 != null && (values2 = ArgsUtil.extractKeywordArgs(this.getRuntime().getCurrentContext(), options2, keywords)) != null && values2.length == 1 && values2[0] != null) {
            this.receiver = values2[0];
        }
        return super.initialize(NULL_ARRAY, block);
    }

    @Override
    @JRubyMethod
    public IRubyObject to_s(ThreadContext context) {
        if (this.message == context.nil) {
            return context.runtime.newString(this.getMetaClass().getRealClass().getName());
        }
        RubyString str = this.message.convertToString();
        if (str != this.message) {
            this.message = str;
        }
        return this.message;
    }

    @JRubyMethod
    public IRubyObject name() {
        return this.name;
    }

    @JRubyMethod
    public IRubyObject receiver(ThreadContext context) {
        if (this.receiver != null) {
            return this.receiver;
        }
        throw context.runtime.newArgumentError("no receiver is available");
    }

    @JRubyMethod(name={"private_call?"})
    public IRubyObject private_call_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.isPrivateCall());
    }

    @Override
    public void copySpecialInstanceVariables(IRubyObject clone2) {
        super.copySpecialInstanceVariables(clone2);
        RubyNameError exception2 = (RubyNameError)clone2;
        exception2.receiver = this.receiver;
        exception2.name = this.name;
    }

    public boolean isPrivateCall() {
        return this.privateCall;
    }

    @JRubyClass(name={"NameError::Message"}, parent="Object")
    public static final class RubyNameErrorMessage
    extends RubyObject {
        private final String message;
        private final IRubyObject object;
        private final IRubyObject name;

        RubyNameErrorMessage(Ruby runtime2, RubyClass klazz) {
            super(runtime2, klazz);
            this.message = null;
            this.object = null;
            this.name = null;
        }

        RubyNameErrorMessage(Ruby runtime2, String message2, IRubyObject object, IRubyObject name2) {
            super(runtime2, runtime2.getNameErrorMessage(), false);
            this.message = message2;
            this.object = object;
            this.name = name2;
        }

        @JRubyMethod(name={"_load"}, meta=true)
        public static IRubyObject load(IRubyObject recv2, IRubyObject arg2) {
            return arg2;
        }

        static RubyClass define(Ruby runtime2, RubyClass NameError2) {
            RubyClass Message = NameError2.defineClassUnder("Message", runtime2.getObject(), RubyNameErrorMessage::new);
            NameError2.setConstantVisibility(runtime2, "Message", true);
            Message.defineAnnotatedMethods(RubyNameErrorMessage.class);
            return Message;
        }

        @JRubyMethod(name={"_dump"})
        public IRubyObject dump(ThreadContext context, IRubyObject arg2) {
            return this.to_str(context);
        }

        @JRubyMethod
        public IRubyObject to_str(ThreadContext context) {
            RubyString className;
            RubyString separator;
            if (this.message == null) {
                return context.nil;
            }
            Ruby runtime2 = context.runtime;
            RubyString description = null;
            boolean singleton = false;
            if (this.object == context.nil) {
                description = RubyNil.inspect(runtime2);
            } else if (this.object == context.tru) {
                description = RubyString.newStringShared(runtime2, RubyBoolean.TRUE_BYTES);
            } else if (this.object == context.fals) {
                description = RubyString.newStringShared(runtime2, RubyBoolean.FALSE_BYTES);
            } else {
                try {
                    IRubyObject name2;
                    if (this.object instanceof RubyModule && ((RubyModule)this.object).respondsTo("name") && !(name2 = ((RubyModule)this.object).callMethod("name")).isNil()) {
                        description = name2.asString();
                    }
                    if (description == null) {
                        description = RubyObject.inspect(context, this.object).asString();
                    }
                }
                catch (JumpException e) {
                    context.setErrorInfo(context.nil);
                }
                if (description == null || description.size() > 65) {
                    description = this.object.anyToString().asString();
                }
                boolean bl = singleton = description.size() > 0 && description.getByteList().get(0) == 35;
            }
            if (!singleton) {
                separator = RubyString.newString(runtime2, (byte)58);
                className = RubyString.newString(runtime2, this.object.getMetaClass().getRealClass().getName());
            } else {
                className = separator = RubyString.newEmptyString(runtime2);
            }
            RubyArray arr = RubyArray.newArray(runtime2, this.name, description, separator, className);
            ByteList msgBytes = new ByteList(this.message.length() + description.size() + 16, (Encoding)USASCIIEncoding.INSTANCE);
            Sprintf.sprintf(msgBytes, this.message, (IRubyObject)arr);
            return runtime2.newString(msgBytes);
        }
    }
}

