/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import java.math.BigInteger;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.ext.ffi.AbstractMemory;
import org.jruby.ext.ffi.Buffer;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.MemoryObject;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.Struct;
import org.jruby.ext.ffi.jffi.DelegatingPointerParameterStrategy;
import org.jruby.ext.ffi.jffi.FFIUtil;
import org.jruby.ext.ffi.jffi.MemoryIOParameterStrategy;
import org.jruby.ext.ffi.jffi.MemoryObjectParameterStrategy;
import org.jruby.ext.ffi.jffi.NativeMemoryIO;
import org.jruby.ext.ffi.jffi.NilPointerParameterStrategy;
import org.jruby.ext.ffi.jffi.PointerParameterStrategy;
import org.jruby.ext.ffi.jffi.StringParameterStrategy;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CachingCallSite;

public final class JITRuntime {
    private static final BigInteger UINT64_BASE = BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE);
    private static final PointerParameterStrategy DIRECT_MEMORY_OBJECT = new MemoryObjectParameterStrategy(true);
    private static final PointerParameterStrategy HEAP_MEMORY_OBJECT = new MemoryObjectParameterStrategy(false);
    private static final PointerParameterStrategy DIRECT_MEMORY_IO = new MemoryIOParameterStrategy(true);
    private static final PointerParameterStrategy HEAP_MEMORY_IO = new MemoryIOParameterStrategy(false);
    private static final PointerParameterStrategy NIL_POINTER_STRATEGY = new NilPointerParameterStrategy();
    private static final PointerParameterStrategy HEAP_STRING_POINTER_STRATEGY = new StringParameterStrategy(false, false);
    private static final PointerParameterStrategy TRANSIENT_STRING_PARAMETER_STRATEGY = new StringParameterStrategy(false, true);
    private static final PointerParameterStrategy DIRECT_STRING_PARAMETER_STRATEGY = new StringParameterStrategy(true, true);

    private JITRuntime() {
    }

    public static RuntimeException newArityError(ThreadContext context, int got, int expected) {
        return context.runtime.newArgumentError(got, expected);
    }

    public static long other2long(IRubyObject parameter) {
        return RubyNumeric.num2long(parameter);
    }

    public static int s8Value32(IRubyObject parameter) {
        return (byte)(parameter instanceof RubyFixnum ? ((RubyFixnum)parameter).getLongValue() : JITRuntime.other2long(parameter));
    }

    public static long s8Value64(IRubyObject parameter) {
        return (byte)(parameter instanceof RubyFixnum ? ((RubyFixnum)parameter).getLongValue() : JITRuntime.other2long(parameter));
    }

    public static int u8Value32(IRubyObject parameter) {
        return (int)((parameter instanceof RubyFixnum ? ((RubyFixnum)parameter).getLongValue() : JITRuntime.other2long(parameter)) & 0xFFL);
    }

    public static long u8Value64(IRubyObject parameter) {
        return (parameter instanceof RubyFixnum ? ((RubyFixnum)parameter).getLongValue() : JITRuntime.other2long(parameter)) & 0xFFL;
    }

    public static int s16Value32(IRubyObject parameter) {
        return (short)(parameter instanceof RubyFixnum ? ((RubyFixnum)parameter).getLongValue() : JITRuntime.other2long(parameter));
    }

    public static long s16Value64(IRubyObject parameter) {
        return (short)(parameter instanceof RubyFixnum ? ((RubyFixnum)parameter).getLongValue() : JITRuntime.other2long(parameter));
    }

    public static int u16Value32(IRubyObject parameter) {
        return (int)((parameter instanceof RubyFixnum ? ((RubyFixnum)parameter).getLongValue() : JITRuntime.other2long(parameter)) & 0xFFFFL);
    }

    public static long u16Value64(IRubyObject parameter) {
        return (parameter instanceof RubyFixnum ? ((RubyFixnum)parameter).getLongValue() : JITRuntime.other2long(parameter)) & 0xFFFFL;
    }

    public static int s32Value32(IRubyObject parameter) {
        return (int)(parameter instanceof RubyFixnum ? ((RubyFixnum)parameter).getLongValue() : JITRuntime.other2long(parameter));
    }

    public static long s32Value64(IRubyObject parameter) {
        return (int)(parameter instanceof RubyFixnum ? ((RubyFixnum)parameter).getLongValue() : JITRuntime.other2long(parameter));
    }

    public static int u32Value32(IRubyObject parameter) {
        return (int)((parameter instanceof RubyFixnum ? ((RubyFixnum)parameter).getLongValue() : JITRuntime.other2long(parameter)) & 0xFFFFFFFFL);
    }

    public static long u32Value64(IRubyObject parameter) {
        return (parameter instanceof RubyFixnum ? ((RubyFixnum)parameter).getLongValue() : JITRuntime.other2long(parameter)) & 0xFFFFFFFFL;
    }

    public static long s64Value64(IRubyObject parameter) {
        return parameter instanceof RubyFixnum ? ((RubyFixnum)parameter).getLongValue() : JITRuntime.other2long(parameter);
    }

    public static long other2u64(IRubyObject parameter) {
        if (parameter instanceof RubyBignum) {
            return ((RubyBignum)parameter).getValue().longValue();
        }
        return JITRuntime.other2long(parameter);
    }

    public static long u64Value64(IRubyObject parameter) {
        return parameter instanceof RubyFixnum ? ((RubyFixnum)parameter).getLongValue() : JITRuntime.other2u64(parameter);
    }

    public static int f32Value32(IRubyObject parameter) {
        if (parameter instanceof RubyFloat) {
            return Float.floatToRawIntBits((float)((RubyFloat)parameter).getDoubleValue());
        }
        return (int)JITRuntime.other2long(parameter);
    }

    public static long f32Value64(IRubyObject parameter) {
        if (parameter instanceof RubyFloat) {
            return Float.floatToRawIntBits((float)((RubyFloat)parameter).getDoubleValue());
        }
        return JITRuntime.other2long(parameter);
    }

    public static long f64Value64(IRubyObject parameter) {
        if (parameter instanceof RubyFloat) {
            return Double.doubleToRawLongBits(((RubyFloat)parameter).getDoubleValue());
        }
        return JITRuntime.other2long(parameter);
    }

    public static int boolValue32(IRubyObject parameter) {
        return JITRuntime.boolValue(parameter) ? 1 : 0;
    }

    public static long boolValue64(IRubyObject parameter) {
        return JITRuntime.boolValue(parameter) ? 1L : 0L;
    }

    private static boolean other2bool(IRubyObject parameter) {
        if (parameter instanceof RubyNumeric) {
            return ((RubyNumeric)parameter).getLongValue() != 0L;
        }
        throw parameter.getRuntime().newTypeError("cannot convert " + parameter.getMetaClass().getRealClass() + " to bool");
    }

    public static boolean boolValue(IRubyObject parameter) {
        if (parameter instanceof RubyBoolean) {
            return parameter.isTrue();
        }
        return JITRuntime.other2bool(parameter);
    }

    public static IRubyObject other2ptr(ThreadContext context, IRubyObject parameter) {
        if (parameter instanceof Struct) {
            return ((Struct)parameter).getMemory();
        }
        if (parameter instanceof RubyString || parameter instanceof Buffer || parameter.isNil()) {
            return parameter;
        }
        return JITRuntime.convert2ptr(context, parameter);
    }

    public static IRubyObject convert2ptr(ThreadContext context, IRubyObject parameter) {
        int MAXRECURSE = 4;
        IRubyObject ptr = parameter;
        for (int i2 = 0; i2 < 4 && !(ptr instanceof AbstractMemory) && ptr.respondsTo("to_ptr"); ++i2) {
            ptr = ptr.callMethod(context, "to_ptr");
        }
        return ptr;
    }

    public static IRubyObject newSigned8(ThreadContext context, int value2) {
        return RubyFixnum.newFixnum(context.runtime, (byte)value2);
    }

    public static IRubyObject newSigned8(Ruby runtime2, int value2) {
        return RubyFixnum.newFixnum(runtime2, (byte)value2);
    }

    public static IRubyObject newSigned8(ThreadContext context, long value2) {
        return RubyFixnum.newFixnum(context.runtime, (byte)value2);
    }

    public static IRubyObject newSigned8(Ruby runtime2, long value2) {
        return RubyFixnum.newFixnum(runtime2, (byte)value2);
    }

    public static IRubyObject newUnsigned8(ThreadContext context, int value2) {
        int n = value2;
        return RubyFixnum.newFixnum(context.runtime, n < 0 ? (n & 0x7F) + 128 : n);
    }

    public static IRubyObject newUnsigned8(Ruby runtime2, int value2) {
        int n = value2;
        return RubyFixnum.newFixnum(runtime2, n < 0 ? (n & 0x7F) + 128 : n);
    }

    public static IRubyObject newUnsigned8(ThreadContext context, long value2) {
        int n = (int)value2;
        return RubyFixnum.newFixnum(context.runtime, n < 0 ? (n & 0x7F) + 128 : n);
    }

    public static IRubyObject newUnsigned8(Ruby runtime2, long value2) {
        int n = (int)value2;
        return RubyFixnum.newFixnum(runtime2, n < 0 ? (n & 0x7F) + 128 : n);
    }

    public static IRubyObject newSigned16(ThreadContext context, int value2) {
        return RubyFixnum.newFixnum(context.runtime, (short)value2);
    }

    public static IRubyObject newSigned16(Ruby runtime2, int value2) {
        return RubyFixnum.newFixnum(runtime2, (short)value2);
    }

    public static IRubyObject newSigned16(ThreadContext context, long value2) {
        return RubyFixnum.newFixnum(context.runtime, (short)value2);
    }

    public static IRubyObject newSigned16(Ruby runtime2, long value2) {
        return RubyFixnum.newFixnum(runtime2, (short)value2);
    }

    public static IRubyObject newUnsigned16(ThreadContext context, int value2) {
        int n = value2;
        return RubyFixnum.newFixnum(context.runtime, n < 0 ? (n & Short.MAX_VALUE) + 32768 : n);
    }

    public static IRubyObject newUnsigned16(Ruby runtime2, int value2) {
        int n = value2;
        return RubyFixnum.newFixnum(runtime2, n < 0 ? (n & Short.MAX_VALUE) + 32768 : n);
    }

    public static IRubyObject newUnsigned16(ThreadContext context, long value2) {
        int n = (int)value2;
        return RubyFixnum.newFixnum(context.runtime, n < 0 ? (n & Short.MAX_VALUE) + 32768 : n);
    }

    public static IRubyObject newUnsigned16(Ruby runtime2, long value2) {
        int n = (int)value2;
        return RubyFixnum.newFixnum(runtime2, n < 0 ? (n & Short.MAX_VALUE) + 32768 : n);
    }

    public static IRubyObject newSigned32(ThreadContext context, int value2) {
        return RubyFixnum.newFixnum(context.runtime, value2);
    }

    public static IRubyObject newSigned32(Ruby runtime2, int value2) {
        return RubyFixnum.newFixnum(runtime2, value2);
    }

    public static IRubyObject newSigned32(ThreadContext context, long value2) {
        return RubyFixnum.newFixnum(context.runtime, (int)value2);
    }

    public static IRubyObject newSigned32(Ruby runtime2, long value2) {
        return RubyFixnum.newFixnum(runtime2, (int)value2);
    }

    public static IRubyObject newUnsigned32(ThreadContext context, int value2) {
        long n = value2;
        return RubyFixnum.newFixnum(context.runtime, n < 0L ? (n & Integer.MAX_VALUE) + 0x80000000L : n);
    }

    public static IRubyObject newUnsigned32(Ruby runtime2, int value2) {
        long n = value2;
        return RubyFixnum.newFixnum(runtime2, n < 0L ? (n & Integer.MAX_VALUE) + 0x80000000L : n);
    }

    public static IRubyObject newUnsigned32(ThreadContext context, long value2) {
        long n = (int)value2;
        return RubyFixnum.newFixnum(context.runtime, n < 0L ? (n & Integer.MAX_VALUE) + 0x80000000L : n);
    }

    public static IRubyObject newUnsigned32(Ruby runtime2, long value2) {
        long n = (int)value2;
        return RubyFixnum.newFixnum(runtime2, n < 0L ? (n & Integer.MAX_VALUE) + 0x80000000L : n);
    }

    public static IRubyObject newSigned64(ThreadContext context, long value2) {
        return RubyFixnum.newFixnum(context.runtime, value2);
    }

    public static IRubyObject newSigned64(Ruby runtime2, long value2) {
        return RubyFixnum.newFixnum(runtime2, value2);
    }

    public static IRubyObject newUnsigned64(ThreadContext context, long value2) {
        return value2 < 0L ? RubyBignum.newBignum(context.runtime, BigInteger.valueOf(value2 & Long.MAX_VALUE).add(UINT64_BASE)) : RubyFixnum.newFixnum(context.runtime, value2);
    }

    public static IRubyObject newUnsigned64(Ruby runtime2, long value2) {
        return value2 < 0L ? RubyBignum.newBignum(runtime2, BigInteger.valueOf(value2 & Long.MAX_VALUE).add(UINT64_BASE)) : RubyFixnum.newFixnum(runtime2, value2);
    }

    public static IRubyObject newNil(ThreadContext context, int ignored) {
        return context.nil;
    }

    public static IRubyObject newNil(Ruby runtime2, int ignored) {
        return runtime2.getNil();
    }

    public static IRubyObject newNil(ThreadContext context, long ignored) {
        return context.nil;
    }

    public static IRubyObject newNil(Ruby runtime2, long ignored) {
        return runtime2.getNil();
    }

    public static IRubyObject newPointer32(ThreadContext context, int address2) {
        Ruby runtime2 = context.runtime;
        return new Pointer(runtime2, NativeMemoryIO.wrap(runtime2, (long)address2 & 0xFFFFFFFFL));
    }

    public static IRubyObject newPointer32(Ruby runtime2, int address2) {
        return new Pointer(runtime2, NativeMemoryIO.wrap(runtime2, (long)address2 & 0xFFFFFFFFL));
    }

    public static IRubyObject newPointer32(ThreadContext context, long address2) {
        Ruby runtime2 = context.runtime;
        return new Pointer(runtime2, NativeMemoryIO.wrap(runtime2, address2 & 0xFFFFFFFFL));
    }

    public static IRubyObject newPointer32(Ruby runtime2, long address2) {
        return new Pointer(runtime2, NativeMemoryIO.wrap(runtime2, address2 & 0xFFFFFFFFL));
    }

    public static IRubyObject newPointer64(ThreadContext context, long address2) {
        Ruby runtime2 = context.runtime;
        return new Pointer(runtime2, NativeMemoryIO.wrap(runtime2, address2));
    }

    public static IRubyObject newPointer64(Ruby runtime2, long address2) {
        return new Pointer(runtime2, NativeMemoryIO.wrap(runtime2, address2));
    }

    public static IRubyObject newString(ThreadContext context, int address2) {
        return FFIUtil.getString(context.runtime, address2);
    }

    public static IRubyObject newString(Ruby runtime2, int address2) {
        return FFIUtil.getString(runtime2, address2);
    }

    public static IRubyObject newString(ThreadContext context, long address2) {
        return FFIUtil.getString(context.runtime, address2);
    }

    public static IRubyObject newString(Ruby runtime2, long address2) {
        return FFIUtil.getString(runtime2, address2);
    }

    public static IRubyObject newBoolean(ThreadContext context, int value2) {
        return RubyBoolean.newBoolean(context, (value2 & 1) != 0);
    }

    public static IRubyObject newBoolean(Ruby runtime2, int value2) {
        return runtime2.newBoolean((value2 & 1) != 0);
    }

    public static IRubyObject newBoolean(ThreadContext context, long value2) {
        return RubyBoolean.newBoolean(context, (value2 & 1L) != 0L);
    }

    public static IRubyObject newBoolean(Ruby runtime2, long value2) {
        return runtime2.newBoolean((value2 & 1L) != 0L);
    }

    public static IRubyObject newFloat32(ThreadContext context, int value2) {
        return RubyFloat.newFloat(context.runtime, Float.intBitsToFloat(value2));
    }

    public static IRubyObject newFloat32(Ruby runtime2, int value2) {
        return RubyFloat.newFloat(runtime2, Float.intBitsToFloat(value2));
    }

    public static IRubyObject newFloat32(ThreadContext context, long value2) {
        return RubyFloat.newFloat(context.runtime, Float.intBitsToFloat((int)value2));
    }

    public static IRubyObject newFloat32(Ruby runtime2, long value2) {
        return RubyFloat.newFloat(runtime2, Float.intBitsToFloat((int)value2));
    }

    public static IRubyObject newFloat64(ThreadContext context, long value2) {
        return RubyFloat.newFloat(context.runtime, Double.longBitsToDouble(value2));
    }

    public static IRubyObject newFloat64(Ruby runtime2, long value2) {
        return RubyFloat.newFloat(runtime2, Double.longBitsToDouble(value2));
    }

    public static PointerParameterStrategy lookupPointerParameterStrategy(IRubyObject parameter) {
        if (parameter instanceof MemoryObject) {
            return ((MemoryObject)parameter).getMemoryIO().isDirect() ? DIRECT_MEMORY_OBJECT : HEAP_MEMORY_OBJECT;
        }
        if (parameter instanceof RubyNil) {
            return NIL_POINTER_STRATEGY;
        }
        if (parameter instanceof RubyString) {
            return HEAP_STRING_POINTER_STRATEGY;
        }
        return null;
    }

    public static MemoryIO lookupPointerMemoryIO(IRubyObject parameter) {
        if (parameter instanceof MemoryObject) {
            return ((MemoryObject)parameter).getMemoryIO();
        }
        if (parameter instanceof RubyNil) {
            return NilPointerParameterStrategy.NullMemoryIO.INSTANCE;
        }
        if (parameter instanceof RubyString) {
            return StringParameterStrategy.getMemoryIO((RubyString)parameter, false, false);
        }
        return null;
    }

    public static MemoryIO getPointerMemoryIO(IRubyObject parameter) {
        MemoryIO memory = JITRuntime.lookupPointerMemoryIO(parameter);
        if (memory != null) {
            return memory;
        }
        return JITRuntime.convertToPointerMemoryIO(parameter);
    }

    private static MemoryIO convertToPointerMemoryIO(IRubyObject parameter) {
        IRubyObject obj = parameter;
        ThreadContext context = parameter.getRuntime().getCurrentContext();
        for (int depth = 0; depth < 4; ++depth) {
            if (obj.respondsTo("to_ptr")) {
                MemoryIO memory = JITRuntime.lookupPointerMemoryIO(obj = obj.callMethod(context, "to_ptr"));
                if (memory == null) continue;
                return memory;
            }
            throw parameter.getRuntime().newArgumentError("cannot convert parameter to native pointer");
        }
        throw parameter.getRuntime().newRuntimeError("to_ptr recursion limit reached for " + parameter.getMetaClass());
    }

    private static MemoryIO convertToStringMemoryIO(IRubyObject parameter, ThreadContext context, CachingCallSite callSite, boolean isDirect, boolean checkStringSafety) {
        IRubyObject convertedParameter;
        if (parameter instanceof RubyString) {
            return StringParameterStrategy.getMemoryIO((RubyString)parameter, isDirect, checkStringSafety);
        }
        if (parameter instanceof RubyNil) {
            return NilPointerParameterStrategy.NullMemoryIO.INSTANCE;
        }
        DynamicMethod conversionMethod = callSite.retrieveCache((IRubyObject)parameter).method;
        if (!conversionMethod.isUndefined() && (convertedParameter = conversionMethod.call(context, parameter, (RubyModule)parameter.getMetaClass(), callSite.getMethodName(), Block.NULL_BLOCK)) instanceof RubyString) {
            return StringParameterStrategy.getMemoryIO((RubyString)convertedParameter, isDirect, checkStringSafety);
        }
        return StringParameterStrategy.getMemoryIO(parameter.convertToString(), isDirect, checkStringSafety);
    }

    public static MemoryIO convertToStringMemoryIO(IRubyObject parameter, ThreadContext context, CachingCallSite callSite) {
        return JITRuntime.convertToStringMemoryIO(parameter, context, callSite, true, true);
    }

    public static MemoryIO convertToTransientStringMemoryIO(IRubyObject parameter, ThreadContext context, CachingCallSite callSite) {
        return JITRuntime.convertToStringMemoryIO(parameter, context, callSite, false, true);
    }

    public static PointerParameterStrategy getMemoryIOStrategy(MemoryIO memory) {
        return memory.isDirect() ? DIRECT_MEMORY_IO : HEAP_MEMORY_IO;
    }

    public static PointerParameterStrategy pointerParameterStrategy(IRubyObject parameter) {
        PointerParameterStrategy strategy = JITRuntime.lookupPointerParameterStrategy(parameter);
        if (strategy != null) {
            return strategy;
        }
        if (parameter.respondsTo("to_ptr")) {
            IRubyObject ptr = parameter.callMethod(parameter.getRuntime().getCurrentContext(), "to_ptr");
            return new DelegatingPointerParameterStrategy(ptr, JITRuntime.pointerParameterStrategy(ptr));
        }
        throw parameter.getRuntime().newArgumentError("cannot convert parameter to native pointer");
    }

    public static PointerParameterStrategy stringParameterStrategy(IRubyObject parameter) {
        if (parameter instanceof RubyString) {
            return DIRECT_STRING_PARAMETER_STRATEGY;
        }
        if (parameter.isNil()) {
            return NIL_POINTER_STRATEGY;
        }
        return JITRuntime.stringParameterStrategy(parameter.convertToString());
    }

    public static PointerParameterStrategy transientStringParameterStrategy(IRubyObject parameter) {
        if (parameter instanceof RubyString) {
            return TRANSIENT_STRING_PARAMETER_STRATEGY;
        }
        if (parameter.isNil()) {
            return NIL_POINTER_STRATEGY;
        }
        return JITRuntime.transientStringParameterStrategy(parameter.convertToString());
    }

    public static MemoryIO convertToPointerMemoryIO(ThreadContext context, IRubyObject parameter, CachingCallSite callSite) {
        DynamicMethod method2 = JITRuntime.getConversionMethod(parameter, callSite);
        IRubyObject ptr = method2.call(context, parameter, (RubyModule)parameter.getMetaClass(), callSite.getMethodName(), Block.NULL_BLOCK);
        if (ptr instanceof AbstractMemory) {
            return ((AbstractMemory)ptr).getMemoryIO();
        }
        throw parameter.getRuntime().newTypeError(parameter.getMetaClass() + "#" + callSite.getMethodName() + " should return " + context.runtime.getFFI().pointerClass);
    }

    public static DynamicMethod getConversionMethod(IRubyObject parameter, CachingCallSite callSite) {
        DynamicMethod method2 = callSite.retrieveCache((IRubyObject)parameter).method;
        if (method2.isUndefined()) {
            throw parameter.getRuntime().newTypeError("cannot convert parameter of type " + parameter.getMetaClass() + " to native pointer; does not respond to :" + callSite.getMethodName());
        }
        return method2;
    }

    public static boolean isDirectPointer(IRubyObject parameter) {
        return parameter instanceof MemoryObject && ((MemoryObject)parameter).getMemoryIO().isDirect();
    }

    public static int pointerValue32(IRubyObject parameter) {
        return (int)((MemoryObject)parameter).getMemoryIO().address();
    }

    public static long pointerValue64(IRubyObject parameter) {
        return ((MemoryObject)parameter).getMemoryIO().address();
    }

    public static boolean isTrue(boolean p1) {
        return p1;
    }

    public static boolean isTrue(boolean p1, boolean p2) {
        return p1 & p2;
    }

    public static boolean isTrue(boolean p1, boolean p2, boolean p3) {
        return p1 & p2 & p3;
    }

    public static boolean isTrue(boolean p1, boolean p2, boolean p3, boolean p4) {
        return p1 & p2 & p3 & p4;
    }

    public static boolean isTrue(boolean p1, boolean p2, boolean p3, boolean p4, boolean p5) {
        return p1 & p2 & p3 & p4 & p5;
    }

    public static boolean isTrue(boolean p1, boolean p2, boolean p3, boolean p4, boolean p5, boolean p6) {
        return p1 & p2 & p3 & p4 & p5 & p5 & p6;
    }
}

