/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.jruby.internal;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jruby.RubyInstanceConfig;

class EnvironmentInjector {
    private RubyInstanceConfig config;

    EnvironmentInjector(RubyInstanceConfig config) {
        this.config = config;
    }

    void inject(Map<String, String> environmentVars) {
        if (!environmentVars.isEmpty()) {
            HashMap<String, String> replacementEnv = new HashMap<String, String>(System.getenv());
            for (Map.Entry<String, String> envVar : environmentVars.entrySet()) {
                String key = envVar.getKey();
                String val = envVar.getValue();
                if (val == null || "".equals(val)) {
                    replacementEnv.remove(envVar.getKey());
                    if (!"GEM_PATH".equals(key) || environmentVars.containsKey("GEM_HOME")) continue;
                    replacementEnv.remove("GEM_HOME");
                    continue;
                }
                replacementEnv.put(key, val);
                if (!"GEM_PATH".equals(key) || environmentVars.containsKey("GEM_HOME")) continue;
                String gemHome = val.toString().split(File.pathSeparator)[0];
                replacementEnv.put("GEM_HOME", gemHome);
            }
            this.config.setEnvironment(replacementEnv);
        }
    }
}

