/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.coverage;

import java.util.HashMap;
import java.util.Map;
import org.jruby.util.collections.IntList;

public class CoverageData {
    public static final String STARTED = "";
    private static final IntList SVALUE = new IntList();
    private volatile Map<String, IntList> coverage;
    private volatile int mode;
    public static final int NONE = 0;
    public static final int LINES = 1;
    public static final int BRANCHES = 2;
    public static final int METHODS = 4;
    public static final int ONESHOT_LINES = 8;
    public static final int ALL = 7;

    public boolean isCoverageEnabled() {
        return this.mode != 0;
    }

    public int getMode() {
        return this.mode;
    }

    public boolean isOneshot() {
        return (this.mode & 8) != 0;
    }

    public Map<String, IntList> getCoverage() {
        return this.coverage;
    }

    public synchronized void coverLine(String filename2, int line) {
        IntList lines2 = this.coverage.get(filename2);
        if (lines2 == null) {
            return;
        }
        if (this.isOneshot()) {
            lines2.add(line);
        } else {
            if (lines2.size() <= line) {
                return;
            }
            lines2.set(line, lines2.get(line) + 1);
        }
    }

    public synchronized void setCoverageEnabled(int mode2) {
        Map<String, IntList> coverage2 = this.coverage;
        if (coverage2 == null) {
            coverage2 = new HashMap<String, IntList>();
        }
        if (mode2 != 0) {
            coverage2.put(STARTED, SVALUE);
        } else {
            coverage2.remove(STARTED);
        }
        this.coverage = coverage2;
        this.mode = mode2;
    }

    public synchronized Map<String, IntList> resetCoverage() {
        Map<String, IntList> coverage2 = this.coverage;
        coverage2.remove(STARTED);
        for (Map.Entry<String, IntList> entry : coverage2.entrySet()) {
            String key2 = entry.getKey();
            if (!CoverageData.hasCodeBeenPartiallyCovered(entry.getValue())) continue;
            coverage2.put(key2, SVALUE);
        }
        this.coverage = null;
        this.mode = 0;
        return coverage2;
    }

    private static boolean hasCodeBeenPartiallyCovered(IntList lines2) {
        for (int i2 = 0; i2 < lines2.size(); ++i2) {
            if (lines2.get(i2) <= 0) continue;
            return true;
        }
        return false;
    }

    public synchronized Map<String, IntList> prepareCoverage(String filename2, int[] startingLines) {
        Map<String, IntList> coverage2 = this.coverage;
        if (filename2 == null) {
            return coverage2;
        }
        if (coverage2 != null) {
            if (this.isOneshot()) {
                coverage2.put(filename2, new IntList());
            } else {
                coverage2.put(filename2, new IntList(startingLines));
            }
        }
        return coverage2;
    }
}

