/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.jruby.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.asciidoctor.SafeMode;

public class AsciidoctorUtils {
    private static final String RUNNER = "asciidoctor";

    private AsciidoctorUtils() {
    }

    public static boolean isOptionWithAttribute(Map<String, Object> options, String attributeName, String attributeValue) {
        String configuredAttributeValue;
        Map attributes;
        return options.containsKey("attributes") && (attributes = (Map)options.get("attributes")).containsKey(attributeName) && (configuredAttributeValue = (String)attributes.get(attributeName)).equals(attributeValue);
    }

    public static List<String> toAsciidoctorCommand(Map<String, Object> options, String inputPath) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(RUNNER);
        command.addAll(AsciidoctorUtils.getOptions(options));
        command.add(inputPath);
        return command;
    }

    private static List<String> getOptions(Map<String, Object> options) {
        ArrayList<String> optionsAndAttributes = new ArrayList<String>();
        if (options.containsKey("destination_dir")) {
            optionsAndAttributes.add("-D");
            optionsAndAttributes.add(options.get("destination_dir").toString());
        }
        if (options.containsKey("base_dir")) {
            optionsAndAttributes.add("-B");
            optionsAndAttributes.add(options.get("base_dir").toString());
        }
        if (options.containsKey("template_dirs")) {
            List templates = (List)options.get("template_dirs");
            for (String template : templates) {
                optionsAndAttributes.add("-T");
                optionsAndAttributes.add(template);
            }
        }
        if (options.containsKey("template_engine")) {
            optionsAndAttributes.add("-E");
            optionsAndAttributes.add(options.get("template_engine").toString());
        }
        if (options.containsKey("compact")) {
            optionsAndAttributes.add("-C");
        }
        if (options.containsKey("eruby")) {
            optionsAndAttributes.add("-e");
            optionsAndAttributes.add(options.get("eruby").toString());
        }
        if (options.containsKey("header_footer")) {
            optionsAndAttributes.add("-s");
        }
        if (options.containsKey("safe")) {
            Integer level = (Integer)options.get("safe");
            SafeMode getSafeMode = SafeMode.safeMode((int)level);
            optionsAndAttributes.add("-S");
            optionsAndAttributes.add(getSafeMode.toString());
        }
        if (options.containsKey("to_file")) {
            optionsAndAttributes.add("-o");
            optionsAndAttributes.add(options.get("to_file").toString());
        }
        if (options.containsKey("doctype")) {
            optionsAndAttributes.add("-d");
            optionsAndAttributes.add(options.get("doctype").toString());
        }
        if (options.containsKey("backend")) {
            optionsAndAttributes.add("-b");
            optionsAndAttributes.add(options.get("backend").toString());
        }
        if (options.containsKey("attributes")) {
            optionsAndAttributes.addAll(AsciidoctorUtils.getAttributesSyntax((Map)options.get("attributes")));
        }
        return optionsAndAttributes;
    }

    private static List<String> getAttributesSyntax(Map<String, Object> attributes) {
        ArrayList<String> attributesOutput = new ArrayList<String>();
        Set<Map.Entry<String, Object>> entrySet = attributes.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            attributesOutput.addAll(AsciidoctorUtils.getAttributeSyntax(entry.getKey(), entry.getValue()));
        }
        return attributesOutput;
    }

    private static List<String> getAttributeSyntax(String attributeName, Object attributeValue) {
        ArrayList<String> attribute = new ArrayList<String>();
        attribute.add("-a");
        StringBuilder argument = new StringBuilder(attributeName);
        if (attributeValue != null && !"".equals(attributeValue.toString().trim())) {
            argument.append("=");
            argument.append(attributeValue.toString());
        }
        if (attributeValue == null) {
            argument.append("!");
        }
        attribute.add(argument.toString());
        return attribute;
    }
}

