/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.load;

import java.net.URL;
import org.jruby.Ruby;
import org.jruby.runtime.load.BasicLibraryService;
import org.jruby.runtime.load.Library;

public class ClassExtensionLibrary
implements Library {
    private final Class theClass;
    private final String name;

    static ClassExtensionLibrary tryFind(Ruby runtime2, String searchName) {
        String[] all = searchName.split("/");
        int leftmostIdentifier = ClassExtensionLibrary.findLeftmostIdentifier(all);
        if (leftmostIdentifier == all.length) {
            return null;
        }
        CharSequence serviceName = ClassExtensionLibrary.buildServiceName(all[all.length - 1]);
        StringBuilder classNameBuilder = new StringBuilder(searchName.length() * 2);
        StringBuilder classFileBuilder = new StringBuilder(searchName.length() * 2);
        for (int i2 = all.length - 1; i2 >= leftmostIdentifier; --i2) {
            ClassExtensionLibrary.buildClassName(classNameBuilder, classFileBuilder, all, i2, serviceName);
            if (classFileBuilder.indexOf("-", 0) >= 0) {
                return null;
            }
            URL resource2 = runtime2.getJRubyClassLoader().getResource(classFileBuilder.toString());
            if (resource2 == null) continue;
            String className = classNameBuilder.toString();
            try {
                Class<?> theClass = runtime2.getJavaSupport().loadJavaClass(className);
                return new ClassExtensionLibrary(className + ".java", theClass);
            }
            catch (ClassNotFoundException cnfe) {
                continue;
            }
            catch (UnsupportedClassVersionError ucve) {
                if (runtime2.isDebug()) {
                    ucve.printStackTrace();
                }
                throw runtime2.newLoadError("JRuby ext built for wrong Java version in `" + className + "': " + ucve, className);
            }
        }
        return null;
    }

    public static int findLeftmostIdentifier(String[] all) {
        int firstElement;
        for (firstElement = all.length - 1; firstElement >= 0 && ClassExtensionLibrary.isJavaIdentifier(all[firstElement]); --firstElement) {
        }
        return firstElement + 1;
    }

    private static boolean isJavaIdentifier(String str) {
        if (str.isEmpty()) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(str.charAt(0))) {
            return false;
        }
        for (int i2 = 1; i2 < str.length(); ++i2) {
            if (Character.isJavaIdentifierPart(str.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    private static void buildClassName(StringBuilder nameBuilder, StringBuilder fileBuilder, String[] all, int i2, CharSequence serviceName) {
        nameBuilder.setLength(0);
        fileBuilder.setLength(0);
        for (int j = i2; j < all.length - 1; ++j) {
            nameBuilder.append(all[j]).append('.');
            fileBuilder.append(all[j]).append('/');
        }
        nameBuilder.append(serviceName);
        fileBuilder.append(serviceName).append(".class");
    }

    private static CharSequence buildServiceName(String jarName) {
        String[] last2 = jarName.split("_");
        StringBuilder serviceName = new StringBuilder(jarName.length() + 7);
        for (String l : last2) {
            if (l.length() == 0) break;
            serviceName.append(Character.toUpperCase(l.charAt(0))).append(l.substring(1));
        }
        serviceName.append("Service");
        return serviceName;
    }

    public ClassExtensionLibrary(String name2, Class extension) {
        this.theClass = extension;
        this.name = name2;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void load(Ruby runtime2, boolean wrap2) {
        if (BasicLibraryService.class.isAssignableFrom(this.theClass)) {
            try {
                runtime2.loadExtension(this.name, (BasicLibraryService)this.theClass.getConstructor(new Class[0]).newInstance(new Object[0]), wrap2);
            }
            catch (Exception ee) {
                throw new RuntimeException(ee.getMessage(), ee);
            }
        }
    }
}

