/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.lang.invoke.MethodHandle;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.AbstractIRMethod;
import org.jruby.internal.runtime.SplitSuperState;
import org.jruby.internal.runtime.methods.ExitableReturn;
import org.jruby.internal.runtime.methods.MethodSplitState;
import org.jruby.ir.IRMethod;
import org.jruby.ir.interpreter.ExitableInterpreterContext;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class CompiledIRNoProtocolMethod
extends AbstractIRMethod {
    private final boolean needsDynamicScope;
    private final MethodHandle variable;

    public CompiledIRNoProtocolMethod(MethodHandle handle, StaticScope scope, String file2, int line, RubyModule implementationClass, boolean needsDynamicScope) {
        super(scope, file2, line, Visibility.PUBLIC, implementationClass);
        this.needsDynamicScope = needsDynamicScope;
        this.variable = handle;
    }

    @Override
    public ArgumentDescriptor[] getArgumentDescriptors() {
        return ArgumentDescriptor.EMPTY_ARRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, Block block) {
        StaticScope staticScope1 = this.staticScope;
        RubyModule implementationClass1 = this.implementationClass;
        this.pre(context, staticScope1, implementationClass1, self2, name2, block);
        try {
            IRubyObject iRubyObject = this.variable.invokeExact(context, staticScope1, self2, IRubyObject.NULL_ARRAY, block, implementationClass1, name2);
            return iRubyObject;
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            IRubyObject iRubyObject = null;
            return iRubyObject;
        }
        finally {
            this.post(context);
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        throw new RuntimeException("BUG: this path should never be called");
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
        throw new RuntimeException("BUG: this path should never be called");
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        throw new RuntimeException("BUG: this path should never be called");
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        throw new RuntimeException("BUG: this path should never be called");
    }

    protected void post(ThreadContext context) {
        context.popFrame();
        if (this.needsDynamicScope) {
            context.popScope();
        }
    }

    protected void pre(ThreadContext context, StaticScope staticScope, RubyModule implementationClass, IRubyObject self2, String name2, Block block) {
        context.preMethodFrameOnly(implementationClass, name2, self2, this.getVisibility(), block);
        if (this.needsDynamicScope) {
            context.pushScope(DynamicScope.newDynamicScope(staticScope, context.getCurrentScope()));
        }
    }

    @Override
    public InterpreterContext ensureInstrsReady() {
        return this.getIRScope().getInterpreterContext();
    }

    @Override
    protected void printMethodIR() {
    }

    @Override
    public SplitSuperState<MethodSplitState> startSplitSuperCall(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        InterpreterContext ic = ((IRMethod)this.getIRScope()).builtInterperterContextForJavaConstructor();
        if (!(ic instanceof ExitableInterpreterContext)) {
            return null;
        }
        MethodSplitState state2 = new MethodSplitState(context, (ExitableInterpreterContext)ic, clazz, self2, name2);
        ExitableReturn result2 = this.INTERPRET_METHOD(state2, args2, block);
        return new SplitSuperState<MethodSplitState>(result2, state2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExitableReturn INTERPRET_METHOD(MethodSplitState state2, IRubyObject[] args2, Block block) {
        try {
            ThreadContext.pushBacktrace(state2.context, state2.name, state2.eic.getFileName(), state2.eic.getLine());
            try {
                this.preSplit(state2.eic, state2.context, state2.self, state2.name, block, state2.implClass, state2.scope);
                ExitableReturn exitableReturn = state2.eic.getEngine().interpret(state2.context, null, state2.self, state2.eic, state2.state, state2.implClass, state2.name, args2, block);
                this.post(state2.eic, state2.context);
                return exitableReturn;
            }
            catch (Throwable throwable) {
                this.post(state2.eic, state2.context);
                throw throwable;
            }
        }
        finally {
            ThreadContext.popBacktrace(state2.context);
        }
    }

    @Override
    public void finishSplitCall(SplitSuperState state2) {
        this.INTERPRET_METHOD((MethodSplitState)state2.state, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
    }

    protected void post(InterpreterContext ic, ThreadContext context) {
        context.popFrame();
        if (ic.popDynScope()) {
            context.popScope();
        }
    }

    protected void preSplit(InterpreterContext ic, ThreadContext context, IRubyObject self2, String name2, Block block, RubyModule implClass, DynamicScope scope) {
        context.preMethodFrameOnly(implClass, name2, self2, block);
        if (ic.pushNewDynScope()) {
            context.pushScope(scope);
        }
    }
}

