/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.Member;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.Unrescuable;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaSupport;
import org.jruby.javasupport.binding.AssignedName;
import org.jruby.javasupport.proxy.JavaProxyClass;
import org.jruby.javasupport.util.ObjectProxyCache;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ArraySupport;
import org.jruby.util.WeakIdentityHashMap;
import org.jruby.util.collections.ClassValue;

public class JavaSupportImpl
extends JavaSupport {
    private final ObjectProxyCache<IRubyObject, RubyClass> objectProxyCache = new ObjectProxyCache<IRubyObject, RubyClass>(ObjectProxyCache.ReferenceType.WEAK){

        @Override
        public IRubyObject allocateProxy(Object javaObject, RubyClass clazz) {
            return Java.allocateProxy(javaObject, clazz);
        }
    };
    private final ClassValue<Map<String, AssignedName>> staticAssignedNames;
    private final ClassValue<Map<String, AssignedName>> instanceAssignedNames;
    private RubyModule javaModule;
    private RubyModule javaUtilitiesModule;
    private RubyModule javaArrayUtilitiesModule;
    private RubyClass javaObjectClass;
    private JavaClass objectJavaClass;
    private RubyClass javaClassClass;
    private RubyClass javaPackageClass;
    private RubyClass javaArrayClass;
    private RubyClass javaProxyClass;
    private RubyClass arrayJavaProxyCreatorClass;
    private RubyClass javaFieldClass;
    private RubyClass javaMethodClass;
    private RubyClass javaConstructorClass;
    private RubyModule javaInterfaceTemplate;
    private RubyClass arrayProxyClass;
    private RubyClass concreteProxyClass;
    private RubyClass mapJavaProxy;
    private RubyClass javaProxyConstructorClass;
    private final Map<JavaSupport.ProxyClassKey, JavaProxyClass> javaProxyClasses = new HashMap<JavaSupport.ProxyClassKey, JavaProxyClass>();
    @Deprecated
    private volatile Map<Object, Object[]> javaObjectVariables;

    public JavaSupportImpl(Ruby runtime2) {
        super(runtime2);
        this.staticAssignedNames = ClassValue.newInstance(klass -> new HashMap(8, 1.0f));
        this.instanceAssignedNames = ClassValue.newInstance(klass -> new HashMap(8, 1.0f));
    }

    @Override
    @Deprecated
    public Class loadJavaClassVerbose(String className) {
        try {
            return this.loadJavaClass(className);
        }
        catch (ClassNotFoundException ex) {
            throw Java.initCause(this.runtime.newNameError("cannot load Java class " + className, className, ex), ex);
        }
        catch (ExceptionInInitializerError ex) {
            throw Java.initCause(this.runtime.newNameError("cannot initialize Java class " + className, className, ex), ex);
        }
        catch (LinkageError ex) {
            throw Java.initCause(this.runtime.newNameError("cannot link Java class " + className + ", probable missing dependency: " + ex.getLocalizedMessage(), className, ex), ex);
        }
        catch (SecurityException ex) {
            if (this.runtime.isVerbose()) {
                ex.printStackTrace(this.runtime.getErrorStream());
            }
            throw Java.initCause(this.runtime.newSecurityError(ex.getLocalizedMessage()), ex);
        }
    }

    @Override
    @Deprecated
    public Class loadJavaClassQuiet(String className) {
        try {
            return this.loadJavaClass(className);
        }
        catch (ClassNotFoundException ex) {
            throw Java.initCause(this.runtime.newNameError("cannot load Java class " + className, className, (Throwable)ex, false), ex);
        }
        catch (ExceptionInInitializerError ex) {
            throw Java.initCause(this.runtime.newNameError("cannot initialize Java class " + className, className, (Throwable)ex, false), ex);
        }
        catch (LinkageError ex) {
            throw Java.initCause(this.runtime.newNameError("cannot link Java class " + className, className, (Throwable)ex, false), ex);
        }
        catch (SecurityException ex) {
            throw Java.initCause(this.runtime.newSecurityError(ex.getLocalizedMessage()), ex);
        }
    }

    @Override
    public void handleNativeException(Throwable exception2, Member target) {
        if (exception2 instanceof RaiseException) {
            throw (RaiseException)exception2;
        }
        if (exception2 instanceof Unrescuable) {
            if (exception2 instanceof Error) {
                throw (Error)exception2;
            }
            if (exception2 instanceof RuntimeException) {
                throw (RuntimeException)exception2;
            }
        }
        Helpers.throwException(exception2);
    }

    @Override
    public ObjectProxyCache<IRubyObject, RubyClass> getObjectProxyCache() {
        return this.objectProxyCache;
    }

    @Override
    public Map<String, JavaClass> getNameClassMap() {
        return Collections.emptyMap();
    }

    @Override
    public RubyModule getJavaModule() {
        RubyModule module = this.javaModule;
        if (module != null) {
            return module;
        }
        this.javaModule = this.runtime.getModule("Java");
        return this.javaModule;
    }

    @Override
    public RubyModule getJavaUtilitiesModule() {
        RubyModule module = this.javaUtilitiesModule;
        if (module != null) {
            return module;
        }
        this.javaUtilitiesModule = this.runtime.getModule("JavaUtilities");
        return this.javaUtilitiesModule;
    }

    @Override
    public RubyModule getJavaArrayUtilitiesModule() {
        RubyModule module = this.javaArrayUtilitiesModule;
        if (module != null) {
            return module;
        }
        this.javaArrayUtilitiesModule = this.runtime.getModule("JavaArrayUtilities");
        return this.javaArrayUtilitiesModule;
    }

    @Override
    public RubyClass getJavaObjectClass() {
        RubyClass clazz = this.javaObjectClass;
        if (clazz != null) {
            return clazz;
        }
        this.javaObjectClass = this.getJavaModule().getClass("JavaObject");
        return this.javaObjectClass;
    }

    @Override
    public RubyClass getJavaProxyConstructorClass() {
        RubyClass clazz = this.javaProxyConstructorClass;
        if (clazz != null) {
            return clazz;
        }
        this.javaProxyConstructorClass = this.getJavaModule().getClass("JavaProxyConstructor");
        return this.javaProxyConstructorClass;
    }

    @Override
    @Deprecated
    public JavaClass getObjectJavaClass() {
        JavaClass clazz = this.objectJavaClass;
        if (clazz != null) {
            return clazz;
        }
        this.objectJavaClass = JavaClass.get(this.runtime, Object.class);
        return this.objectJavaClass;
    }

    @Override
    @Deprecated
    public void setObjectJavaClass(JavaClass objectJavaClass) {
    }

    @Override
    public RubyClass getJavaArrayClass() {
        RubyClass clazz = this.javaArrayClass;
        if (clazz != null) {
            return clazz;
        }
        this.javaArrayClass = this.getJavaModule().getClass("JavaArray");
        return this.javaArrayClass;
    }

    @Override
    public RubyClass getJavaClassClass() {
        RubyClass clazz = this.javaClassClass;
        if (clazz != null) {
            return clazz;
        }
        this.javaClassClass = this.getJavaModule().getClass("JavaClass");
        return this.javaClassClass;
    }

    @Override
    public RubyClass getJavaPackageClass() {
        return this.javaPackageClass;
    }

    @Override
    public void setJavaPackageClass(RubyClass javaPackageClass) {
        this.javaPackageClass = javaPackageClass;
    }

    @Override
    public RubyModule getJavaInterfaceTemplate() {
        RubyModule module = this.javaInterfaceTemplate;
        if (module != null) {
            return module;
        }
        this.javaInterfaceTemplate = this.runtime.getModule("JavaInterfaceTemplate");
        return this.javaInterfaceTemplate;
    }

    @Override
    @Deprecated
    public RubyModule getPackageModuleTemplate() {
        return null;
    }

    @Override
    public RubyClass getJavaProxyClass() {
        RubyClass clazz = this.javaProxyClass;
        if (clazz != null) {
            return clazz;
        }
        this.javaProxyClass = this.runtime.getClass("JavaProxy");
        return this.javaProxyClass;
    }

    @Override
    public RubyClass getArrayJavaProxyCreatorClass() {
        RubyClass clazz = this.arrayJavaProxyCreatorClass;
        if (clazz != null) {
            return clazz;
        }
        this.arrayJavaProxyCreatorClass = this.runtime.getClass("ArrayJavaProxyCreator");
        return this.arrayJavaProxyCreatorClass;
    }

    @Override
    public RubyClass getConcreteProxyClass() {
        RubyClass clazz = this.concreteProxyClass;
        if (clazz != null) {
            return clazz;
        }
        this.concreteProxyClass = this.runtime.getClass("ConcreteJavaProxy");
        return this.concreteProxyClass;
    }

    @Override
    public RubyClass getMapJavaProxyClass() {
        RubyClass clazz = this.mapJavaProxy;
        if (clazz != null) {
            return clazz;
        }
        this.mapJavaProxy = this.runtime.getClass("MapJavaProxy");
        return this.mapJavaProxy;
    }

    @Override
    public RubyClass getArrayProxyClass() {
        RubyClass clazz = this.arrayProxyClass;
        if (clazz != null) {
            return clazz;
        }
        this.arrayProxyClass = this.runtime.getClass("ArrayJavaProxy");
        return this.arrayProxyClass;
    }

    @Override
    public RubyClass getJavaFieldClass() {
        RubyClass clazz = this.javaFieldClass;
        if (clazz != null) {
            return clazz;
        }
        this.javaFieldClass = this.getJavaModule().getClass("JavaField");
        return this.javaFieldClass;
    }

    @Override
    public RubyClass getJavaMethodClass() {
        RubyClass clazz = this.javaMethodClass;
        if (clazz != null) {
            return clazz;
        }
        this.javaMethodClass = this.getJavaModule().getClass("JavaMethod");
        return this.javaMethodClass;
    }

    @Override
    public RubyClass getJavaConstructorClass() {
        RubyClass clazz = this.javaConstructorClass;
        if (clazz != null) {
            return clazz;
        }
        this.javaConstructorClass = this.getJavaModule().getClass("JavaConstructor");
        return this.javaConstructorClass;
    }

    @Override
    public ClassValue<Map<String, AssignedName>> getStaticAssignedNames() {
        return this.staticAssignedNames;
    }

    @Override
    public ClassValue<Map<String, AssignedName>> getInstanceAssignedNames() {
        return this.instanceAssignedNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Map<Set<?>, JavaProxyClass> getJavaProxyClassCache() {
        HashMap javaProxyClassCache = new HashMap(this.javaProxyClasses.size());
        Map<JavaSupport.ProxyClassKey, JavaProxyClass> map2 = this.javaProxyClasses;
        synchronized (map2) {
            for (Map.Entry<JavaSupport.ProxyClassKey, JavaProxyClass> entry : this.javaProxyClasses.entrySet()) {
                JavaSupport.ProxyClassKey key2 = entry.getKey();
                HashSet<Object> cacheKey = new HashSet<Object>();
                cacheKey.add(key2.superClass);
                for (int i2 = 0; i2 < key2.interfaces.length; ++i2) {
                    cacheKey.add(key2.interfaces[i2]);
                }
                if (!key2.names.isEmpty()) {
                    cacheKey.addAll(key2.names);
                }
                javaProxyClassCache.put(cacheKey, entry.getValue());
            }
        }
        return Collections.unmodifiableMap(javaProxyClassCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final JavaProxyClass fetchJavaProxyClass(JavaSupport.ProxyClassKey classKey) {
        Map<JavaSupport.ProxyClassKey, JavaProxyClass> map2 = this.javaProxyClasses;
        synchronized (map2) {
            return this.javaProxyClasses.get(classKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final JavaProxyClass saveJavaProxyClass(JavaSupport.ProxyClassKey classKey, JavaProxyClass klass) {
        Map<JavaSupport.ProxyClassKey, JavaProxyClass> map2 = this.javaProxyClasses;
        synchronized (map2) {
            JavaProxyClass existing = this.javaProxyClasses.get(classKey);
            if (existing != null) {
                return existing;
            }
            this.javaProxyClasses.put(classKey, klass);
        }
        return klass;
    }

    public static JavaProxyClass fetchJavaProxyClass(Ruby runtime2, JavaSupport.ProxyClassKey classKey) {
        return runtime2.getJavaSupport().fetchJavaProxyClass(classKey);
    }

    public static JavaProxyClass saveJavaProxyClass(Ruby runtime2, JavaSupport.ProxyClassKey classKey, JavaProxyClass klass) {
        return runtime2.getJavaSupport().saveJavaProxyClass(classKey, klass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Object getJavaObjectVariable(Object o, int i2) {
        if (i2 == -1) {
            return null;
        }
        Map<Object, Object[]> variables = this.javaObjectVariables;
        if (variables == null) {
            return null;
        }
        JavaSupportImpl javaSupportImpl = this;
        synchronized (javaSupportImpl) {
            Object[] vars = variables.get(o);
            if (vars == null || vars.length <= i2) {
                return null;
            }
            return vars[i2];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void setJavaObjectVariable(Object o, int i2, Object v) {
        if (i2 == -1) {
            return;
        }
        JavaSupportImpl javaSupportImpl = this;
        synchronized (javaSupportImpl) {
            Object[] vars;
            WeakIdentityHashMap variables = this.javaObjectVariables;
            if (variables == null) {
                variables = this.javaObjectVariables = new WeakIdentityHashMap();
            }
            if ((vars = variables.get(o)) == null) {
                vars = new Object[i2 + 1];
                variables.put(o, vars);
            } else if (vars.length <= i2) {
                vars = ArraySupport.newCopy(vars, i2 + 1);
                variables.put(o, vars);
            }
            vars[i2] = v;
        }
    }
}

