/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor;

import java.io.File;
import java.io.OutputStream;
import org.asciidoctor.Attributes;
import org.asciidoctor.Options;
import org.asciidoctor.SafeMode;

public class OptionsBuilder {
    private final Options options = new Options();

    OptionsBuilder() {
    }

    public OptionsBuilder backend(String backend) {
        this.options.setBackend(backend);
        return this;
    }

    public OptionsBuilder docType(String docType) {
        this.options.setDocType(docType);
        return this;
    }

    public OptionsBuilder inPlace(boolean inPlace) {
        this.options.setInPlace(inPlace);
        return this;
    }

    public OptionsBuilder standalone(boolean standalone) {
        this.options.setStandalone(standalone);
        return this;
    }

    public OptionsBuilder templateDirs(File ... templateDirs) {
        for (File templateDir : templateDirs) {
            this.options.setTemplateDirs(templateDir.getAbsolutePath());
        }
        return this;
    }

    public OptionsBuilder templateEngine(String templateEngine) {
        this.options.setTemplateEngine(templateEngine);
        return this;
    }

    public OptionsBuilder templateCache(boolean templateCache) {
        this.options.setTemplateCache(templateCache);
        return this;
    }

    public OptionsBuilder attributes(Attributes attributes) {
        this.options.setAttributes(attributes);
        return this;
    }

    public OptionsBuilder toFile(boolean toFile) {
        this.options.setToFile(toFile);
        return this;
    }

    public OptionsBuilder toFile(File toFile) {
        this.options.setToFile(toFile.getPath());
        return this;
    }

    public OptionsBuilder toStream(OutputStream toStream) {
        this.options.setToStream(toStream);
        return this;
    }

    public OptionsBuilder toDir(File directory) {
        this.options.setToDir(directory.getAbsolutePath());
        return this;
    }

    public OptionsBuilder mkDirs(boolean mkDirs) {
        this.options.setMkDirs(mkDirs);
        return this;
    }

    public OptionsBuilder safe(SafeMode safeMode) {
        this.options.setSafe(safeMode);
        return this;
    }

    public OptionsBuilder sourcemap(boolean sourcemap) {
        this.options.setSourcemap(sourcemap);
        return this;
    }

    public OptionsBuilder eruby(String eruby) {
        this.options.setEruby(eruby);
        return this;
    }

    public OptionsBuilder catalogAssets(boolean catalogAssets) {
        this.options.setCatalogAssets(catalogAssets);
        return this;
    }

    public OptionsBuilder compact(boolean compact) {
        this.options.setCompact(compact);
        return this;
    }

    public OptionsBuilder parse(boolean parse) {
        this.options.setParse(parse);
        return this;
    }

    public OptionsBuilder parseHeaderOnly(boolean parseHeaderOnly) {
        this.options.setParseHeaderOnly(parseHeaderOnly);
        return this;
    }

    public OptionsBuilder sourceDir(File srcDir) {
        this.options.setSourceDir(srcDir.getAbsolutePath());
        return this;
    }

    public OptionsBuilder option(String option, Object value) {
        this.options.setOption(option, value);
        return this;
    }

    public OptionsBuilder baseDir(File baseDir) {
        this.options.setBaseDir(baseDir.getAbsolutePath());
        return this;
    }

    public Options build() {
        return this.options;
    }
}

