/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.jruby.ast.impl;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.asciidoctor.ast.Author;
import org.asciidoctor.ast.Catalog;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.RevisionInfo;
import org.asciidoctor.ast.Title;
import org.asciidoctor.jruby.ast.impl.AuthorImpl;
import org.asciidoctor.jruby.ast.impl.CatalogImpl;
import org.asciidoctor.jruby.ast.impl.RevisionInfoImpl;
import org.asciidoctor.jruby.ast.impl.StructuralNodeImpl;
import org.asciidoctor.jruby.internal.RubyHashMapDecorator;
import org.asciidoctor.jruby.internal.RubyHashUtil;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyHash;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.runtime.builtin.IRubyObject;

public class DocumentImpl
extends StructuralNodeImpl
implements Document {
    public DocumentImpl(IRubyObject document) {
        super(document);
    }

    public String getSource() {
        return this.getString("source", new Object[0]);
    }

    public List<String> getSourceLines() {
        return this.getList("source_lines", String.class, new Object[0]);
    }

    public boolean isBasebackend(String backend) {
        return this.getBoolean("basebackend?", backend);
    }

    public Map<Object, Object> getOptions() {
        return RubyHashUtil.convertRubyHashMapToMap((Map<Object, Object>)((RubyHash)this.getRubyProperty("options", new Object[0])));
    }

    public Title getStructuredDoctitle() {
        Ruby runtime = this.getRubyObject().getRuntime();
        RubyHash options = RubyHash.newHash((Ruby)runtime);
        RubySymbol partitioned = RubySymbol.newSymbol((Ruby)runtime, (String)"partition");
        options.put((Object)partitioned, (Object)RubyBoolean.newBoolean((Ruby)runtime, (boolean)true));
        IRubyObject doctitle = this.getRubyProperty("doctitle", options);
        return this.toJava(doctitle, Title.class);
    }

    public String getDoctitle() {
        return this.getString("doctitle", new Object[0]);
    }

    public List<Author> getAuthors() {
        return this.getList("authors", RubyStruct.class, new Object[0]).stream().map(AuthorImpl::getInstance).collect(Collectors.toList());
    }

    public int getAndIncrementCounter(String name) {
        return this.getInt("counter", name);
    }

    public int getAndIncrementCounter(String name, int initialValue) {
        return this.getInt("counter", name, initialValue);
    }

    public boolean isSourcemap() {
        return this.getBoolean("sourcemap", new Object[0]);
    }

    public void setSourcemap(boolean state) {
        this.setBoolean("sourcemap", state);
    }

    public Catalog getCatalog() {
        return new CatalogImpl(new RubyHashMapDecorator((RubyHash)this.getProperty("catalog", new Object[0])));
    }

    public RevisionInfo getRevisionInfo() {
        return RevisionInfoImpl.getInstance(this.getAttributes());
    }
}

