/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.jruby.internal;

import java.util.Map;
import org.jruby.Ruby;

public class RubyGemsPreloader {
    private static final String CODERAY = "coderay";
    private static final String ERUBIS = "erubis";
    private static final String EPUB3 = "epub3";
    private static final String PDF = "pdf";
    private static final String REVEALJS = "asciidoctor-revealjs";
    private static final Map<String, String> optionToRequiredGem = Map.of("eruby", "require 'erubis'", "template_dirs", "require 'tilt'", "cache-uri", "require 'open-uri/cached'", "data-uri", "require 'base64'", "source-highlighter", "require 'coderay'", "epub3", "require 'asciidoctor-epub3'", "pdf", "require 'asciidoctor-pdf'", "asciidoctor-revealjs", "require 'asciidoctor-revealjs'");
    private Ruby rubyRuntime;

    public RubyGemsPreloader(Ruby rubyRuntime) {
        this.rubyRuntime = rubyRuntime;
    }

    public void preloadRequiredLibraries(Map<String, Object> options) {
        if (options.containsKey("attributes")) {
            Map attributes = (Map)options.get("attributes");
            if (this.isOptionSet(attributes, "source-highlighter") && this.isOptionWithValue(attributes, "source-highlighter", CODERAY)) {
                this.preloadLibrary("source-highlighter");
            }
            if (this.isOptionSet(attributes, "cache-uri")) {
                this.preloadLibrary("cache-uri");
            }
            if (this.isOptionSet(attributes, "data-uri")) {
                this.preloadLibrary("data-uri");
            }
        }
        if (this.isOptionSet(options, "eruby") && this.isOptionWithValue(options, "eruby", ERUBIS)) {
            this.preloadLibrary("eruby");
        }
        if (this.isOptionSet(options, "template_dirs")) {
            this.preloadLibrary("template_dirs");
        }
        if (this.isOptionSet(options, "backend") && EPUB3.equalsIgnoreCase((String)options.get("backend"))) {
            this.preloadLibrary(EPUB3);
        }
        if (this.isOptionSet(options, "backend") && PDF.equalsIgnoreCase((String)options.get("backend"))) {
            this.preloadLibrary(PDF);
        }
        if (this.isOptionSet(options, "backend") && "revealjs".equalsIgnoreCase((String)options.get("backend"))) {
            this.preloadLibrary(REVEALJS);
        }
    }

    private void preloadLibrary(String option) {
        this.rubyRuntime.evalScriptlet(optionToRequiredGem.get(option));
    }

    private boolean isOptionWithValue(Map<String, Object> attributes, String attribute, String value) {
        return attributes.get(attribute).equals(value);
    }

    private boolean isOptionSet(Map<String, Object> attributes, String attribute) {
        return attributes.containsKey(attribute);
    }
}

