/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.cli.jruby;

import com.beust.jcommander.JCommander;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Options;
import org.asciidoctor.cli.AsciidoctorCliOptions;
import org.asciidoctor.cli.MaxSeverityLogHandler;
import org.asciidoctor.jruby.GlobDirectoryWalker;
import org.asciidoctor.jruby.internal.IOUtils;
import org.asciidoctor.jruby.internal.JRubyAsciidoctor;
import org.asciidoctor.jruby.internal.JRubyRuntimeContext;
import org.asciidoctor.jruby.internal.RubyUtils;
import org.asciidoctor.log.LogHandler;
import org.jruby.Main;
import org.jruby.Ruby;
import org.jruby.runtime.builtin.IRubyObject;

public class AsciidoctorInvoker {
    public int invoke(String ... parameters) throws IOException {
        AsciidoctorCliOptions asciidoctorCliOptions = new AsciidoctorCliOptions();
        JCommander jCommander = new JCommander((Object)asciidoctorCliOptions);
        jCommander.parse(parameters);
        if (asciidoctorCliOptions.isHelp() || parameters.length == 0) {
            jCommander.setProgramName("asciidoctor");
            jCommander.usage();
        } else {
            JRubyAsciidoctor asciidoctor = this.buildAsciidoctorJInstance(asciidoctorCliOptions);
            if (asciidoctorCliOptions.isVersion()) {
                System.out.println("AsciidoctorJ " + this.getAsciidoctorJVersion() + " (Asciidoctor " + asciidoctor.asciidoctorVersion() + ") [https://asciidoctor.org]");
                IRubyObject rubyVersionString = JRubyRuntimeContext.get((Asciidoctor)asciidoctor).evalScriptlet("\"#{JRUBY_VERSION} (#{RUBY_VERSION})\"");
                System.out.println("Runtime Environment: jruby " + rubyVersionString);
                return 0;
            }
            List<File> inputFiles = this.getInputFiles(asciidoctorCliOptions);
            if (inputFiles.isEmpty()) {
                System.err.println("asciidoctor: FAILED: input file(s) '" + asciidoctorCliOptions.getParameters() + "' missing or cannot be read");
                throw new IllegalArgumentException("asciidoctor: FAILED: input file(s) '" + asciidoctorCliOptions.getParameters() + "' missing or cannot be read");
            }
            MaxSeverityLogHandler maxSeverityLogHandler = new MaxSeverityLogHandler();
            asciidoctor.registerLogHandler((LogHandler)maxSeverityLogHandler);
            Options options = asciidoctorCliOptions.parse();
            if (asciidoctorCliOptions.isRequire()) {
                for (String require : asciidoctorCliOptions.getRequire()) {
                    RubyUtils.requireLibrary((Ruby)asciidoctor.getRubyRuntime(), (String)require);
                }
            }
            this.setTimingsMode((Asciidoctor)asciidoctor, asciidoctorCliOptions, options);
            this.setVerboseLevel(asciidoctor, asciidoctorCliOptions);
            this.convertInput((Asciidoctor)asciidoctor, options, inputFiles);
            if (asciidoctorCliOptions.getFailureLevel().compareTo((Enum)maxSeverityLogHandler.getMaxSeverity()) <= 0) {
                return 1;
            }
            if (asciidoctorCliOptions.isTimings()) {
                Map optionsMap = options.map();
                IRubyObject timings = (IRubyObject)optionsMap.get("timings");
                timings.callMethod(JRubyRuntimeContext.get((Asciidoctor)asciidoctor).getCurrentContext(), "print_report");
            }
        }
        return 0;
    }

    private String getAsciidoctorJVersion() {
        InputStream in = this.getClass().getResourceAsStream("/META-INF/asciidoctorj-version.properties");
        if (in == null) {
            return "N/A";
        }
        Properties versionProps = new Properties();
        try {
            versionProps.load(in);
            return versionProps.getProperty("version.asciidoctorj");
        }
        catch (IOException e) {
            return "N/A";
        }
    }

    private void setTimingsMode(Asciidoctor asciidoctor, AsciidoctorCliOptions asciidoctorCliOptions, Options options) {
        if (asciidoctorCliOptions.isTimings()) {
            options.setOption("timings", (Object)JRubyRuntimeContext.get((Asciidoctor)asciidoctor).evalScriptlet("Asciidoctor::Timings.new"));
        }
    }

    private void setVerboseLevel(JRubyAsciidoctor asciidoctor, AsciidoctorCliOptions asciidoctorCliOptions) {
        if (asciidoctorCliOptions.isVerbose()) {
            RubyUtils.setGlobalVariable((Ruby)asciidoctor.getRubyRuntime(), (String)"VERBOSE", (Object)"true");
        } else if (asciidoctorCliOptions.isQuiet()) {
            RubyUtils.setGlobalVariable((Ruby)asciidoctor.getRubyRuntime(), (String)"VERBOSE", (Object)"nil");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JRubyAsciidoctor buildAsciidoctorJInstance(AsciidoctorCliOptions asciidoctorCliOptions) {
        ClassLoader oldTccl = Thread.currentThread().getContextClassLoader();
        try {
            if (asciidoctorCliOptions.isClassPaths()) {
                URLClassLoader tccl = this.createUrlClassLoader(asciidoctorCliOptions.getClassPaths());
                Thread.currentThread().setContextClassLoader(tccl);
            }
            JRubyAsciidoctor asciidoctor = asciidoctorCliOptions.isLoadPaths() ? JRubyAsciidoctor.create(asciidoctorCliOptions.getLoadPaths()) : JRubyAsciidoctor.create();
            JRubyAsciidoctor jRubyAsciidoctor = asciidoctor;
            return jRubyAsciidoctor;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTccl);
        }
    }

    private URLClassLoader createUrlClassLoader(List<String> classPaths) {
        ArrayList<URL> cpUrls = new ArrayList<URL>();
        for (String cp : classPaths) {
            try {
                GlobDirectoryWalker globDirectoryWalker = new GlobDirectoryWalker(cp);
                for (File f : globDirectoryWalker.scan()) {
                    cpUrls.add(f.toURI().toURL());
                }
            }
            catch (Exception e) {
                System.err.println(String.format("asciidoctor: WARNING: Could not resolve classpath '%s': %s", cp, e.getMessage()));
            }
        }
        return new URLClassLoader(cpUrls.toArray(new URL[cpUrls.size()]));
    }

    private void convertInput(Asciidoctor asciidoctor, Options options, List<File> inputFiles) {
        if (inputFiles.size() == 1 && "-".equals(inputFiles.get(0).getName())) {
            asciidoctor.convert(this.readInputFromStdIn(), options);
            return;
        }
        options.setMkDirs(true);
        this.findInvalidInputFile(inputFiles).ifPresent(inputFile -> {
            System.err.println("asciidoctor: FAILED: input file(s) '" + inputFile.getAbsolutePath() + "' missing or cannot be read");
            throw new IllegalArgumentException("asciidoctor: FAILED: input file(s) '" + inputFile.getAbsolutePath() + "' missing or cannot be read");
        });
        Optional<File> toDir = this.getAbsolutePathFromOption(options, "to_dir");
        Optional<File> srcDir = this.getAbsolutePathFromOption(options, "source_dir");
        inputFiles.forEach(inputFile -> {
            if (toDir.isPresent() && srcDir.isPresent() && inputFile.getAbsolutePath().startsWith(((File)srcDir.get()).getAbsolutePath())) {
                String relativePath = ((File)srcDir.get()).toURI().relativize(inputFile.getParentFile().getAbsoluteFile().toURI()).getPath();
                String absolutePath = new File((File)toDir.get(), relativePath).getAbsolutePath();
                options.setToDir(absolutePath);
            }
            asciidoctor.convertFile(inputFile, options);
        });
    }

    private Optional<File> getAbsolutePathFromOption(Options options, String name) {
        return Optional.ofNullable(options.map().get(name)).filter(String.class::isInstance).map(String.class::cast).map(File::new);
    }

    private Optional<File> findInvalidInputFile(List<File> inputFiles) {
        return inputFiles.stream().filter(inputFile -> !inputFile.canRead()).findFirst();
    }

    private String readInputFromStdIn() {
        return IOUtils.readFull((InputStream)System.in);
    }

    private List<File> getInputFiles(AsciidoctorCliOptions asciidoctorCliOptions) {
        List<String> parameters = asciidoctorCliOptions.getParameters();
        if (parameters.stream().anyMatch(String::isEmpty)) {
            System.err.println("asciidoctor: FAILED: empty input file name");
            throw new IllegalArgumentException("asciidoctor: FAILED: empty input file name");
        }
        return parameters.stream().map(globExpression -> new GlobDirectoryWalker(globExpression)).flatMap(walker -> walker.scan().stream()).collect(Collectors.toList());
    }

    public static void main(String[] args) throws IOException {
        Main.processDotfile();
        int status = new AsciidoctorInvoker().invoke(args);
        if (status != 0) {
            System.exit(status);
        }
    }
}

