/*
 * Decompiled with CFR 0.152.
 */
package org.astarteplatform.devicesdk;

import java.util.Timer;
import java.util.TimerTask;
import org.astarteplatform.devicesdk.AstarteDevice;
import org.astarteplatform.devicesdk.AstarteInterfaceProvider;
import org.astarteplatform.devicesdk.AstarteMessageListener;
import org.astarteplatform.devicesdk.AstartePairingException;
import org.astarteplatform.devicesdk.AstartePairingHandler;
import org.astarteplatform.devicesdk.AstartePropertyStorage;
import org.astarteplatform.devicesdk.crypto.AstarteCryptoException;
import org.astarteplatform.devicesdk.crypto.AstarteCryptoStore;
import org.astarteplatform.devicesdk.protocol.AstarteInterface;
import org.astarteplatform.devicesdk.protocol.AstarteInvalidInterfaceException;
import org.astarteplatform.devicesdk.transport.AstarteFailedMessageStorage;
import org.astarteplatform.devicesdk.transport.AstarteTransport;
import org.astarteplatform.devicesdk.transport.AstarteTransportEventListener;
import org.astarteplatform.devicesdk.transport.AstarteTransportException;
import org.json.JSONException;

public abstract class AstartePairableDevice
extends AstarteDevice
implements AstarteTransportEventListener {
    private AstartePairingHandler mPairingHandler;
    private AstarteTransport mAstarteTransport = null;
    private AstarteMessageListener mAstarteMessageListener = null;
    private boolean mInitialized = false;
    private boolean mExplicitDisconnectionRequest = false;
    private Timer mReconnectTimer = null;

    protected AstartePairableDevice(AstartePairingHandler pairingHandler, AstartePropertyStorage propertyStorage, AstarteFailedMessageStorage failedMessageStorage, AstarteInterfaceProvider interfaceProvider) throws JSONException, AstarteInvalidInterfaceException {
        super(interfaceProvider, propertyStorage, failedMessageStorage);
        this.mPairingHandler = pairingHandler;
    }

    private void init() throws AstartePairingException {
        this.mPairingHandler.init();
        this.setFirstTransportFromPairingHandler();
    }

    @Override
    public String getDeviceId() {
        return this.mPairingHandler.getDeviceId();
    }

    @Override
    public String getAstarteRealm() {
        return this.mPairingHandler.getAstarteRealm();
    }

    public AstarteCryptoStore getCryptoStore() {
        return this.mPairingHandler.m_cryptoStore;
    }

    public AstarteTransport getAstarteTransport() {
        return this.mAstarteTransport;
    }

    public void setAstarteTransport(AstarteTransport astarteTransport) {
        this.mAstarteTransport = astarteTransport;
        this.configureTransport();
    }

    @Override
    public AstarteMessageListener getAstarteMessageListener() {
        return this.mAstarteMessageListener;
    }

    @Override
    public void setAstarteMessageListener(AstarteMessageListener astarteMessageListener) {
        this.mAstarteMessageListener = astarteMessageListener;
        if (this.mAstarteTransport != null && astarteMessageListener != null) {
            this.mAstarteTransport.setMessageListener(astarteMessageListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean eventuallyReconnect() {
        AstartePairableDevice astartePairableDevice = this;
        synchronized (astartePairableDevice) {
            if (this.alwaysReconnects() && this.mReconnectTimer == null) {
                this.mReconnectTimer = new Timer();
                this.mReconnectTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            AstartePairableDevice.this.connect();
                        }
                        catch (Exception e) {
                            AstartePairableDevice.this.mAstarteMessageListener.onFailure(e);
                        }
                    }
                }, 5000L, 15000L);
                return true;
            }
            this.mExplicitDisconnectionRequest = false;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() throws AstarteTransportException, AstarteCryptoException, AstartePairingException {
        AstartePairableDevice astartePairableDevice = this;
        synchronized (astartePairableDevice) {
            block12: {
                if (!this.mInitialized) {
                    try {
                        this.init();
                    }
                    catch (Exception e) {
                        if (!this.eventuallyReconnect()) {
                            throw e;
                        }
                        return;
                    }
                    this.mInitialized = true;
                }
                if (this.isConnected()) {
                    return;
                }
                try {
                    this.mAstarteTransport.connect();
                }
                catch (AstarteCryptoException e) {
                    System.err.println("Regenerating the cert");
                    try {
                        this.mPairingHandler.requestNewCertificate();
                    }
                    catch (AstartePairingException ex) {
                        this.onTransportConnectionError(ex);
                        return;
                    }
                    if (this.eventuallyReconnect()) break block12;
                    this.mAstarteTransport.connect();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() throws AstarteTransportException {
        AstartePairableDevice astartePairableDevice = this;
        synchronized (astartePairableDevice) {
            if (this.mReconnectTimer != null) {
                this.mExplicitDisconnectionRequest = true;
            }
            if (!this.isConnected()) {
                return;
            }
            this.mExplicitDisconnectionRequest = true;
            this.mAstarteTransport.disconnect();
        }
    }

    @Override
    public boolean isConnected() {
        try {
            return this.mAstarteTransport.isConnected();
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTransportConnected() {
        AstartePairableDevice astartePairableDevice = this;
        synchronized (astartePairableDevice) {
            if (this.mAstarteMessageListener != null) {
                this.mAstarteMessageListener.onConnected();
            }
            if (this.mReconnectTimer != null) {
                this.mReconnectTimer.cancel();
                this.mReconnectTimer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTransportConnectionInitializationError(final Throwable cause) {
        AstartePairableDevice astartePairableDevice = this;
        synchronized (astartePairableDevice) {
            if (this.mAstarteMessageListener != null) {
                this.mAstarteMessageListener.onFailure(cause);
            } else {
                cause.printStackTrace();
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        AstartePairableDevice.this.disconnect();
                        if (AstartePairableDevice.this.mAstarteMessageListener != null) {
                            AstartePairableDevice.this.mAstarteMessageListener.onDisconnected(cause);
                        }
                    }
                    catch (AstarteTransportException e) {
                        e.printStackTrace();
                    }
                    AstartePairableDevice.this.eventuallyReconnect();
                }
            }).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTransportConnectionError(Throwable cause) {
        AstartePairableDevice astartePairableDevice = this;
        synchronized (astartePairableDevice) {
            block12: {
                if (cause instanceof AstarteCryptoException) {
                    System.err.println("Regenerating the cert");
                    try {
                        this.mPairingHandler.requestNewCertificate();
                        this.setFirstTransportFromPairingHandler();
                    }
                    catch (AstartePairingException e) {
                        if (!this.eventuallyReconnect()) {
                            this.mAstarteMessageListener.onFailure(e);
                            e.printStackTrace();
                        }
                        return;
                    }
                    try {
                        this.mAstarteTransport.connect();
                    }
                    catch (Exception e) {
                        if (this.mAstarteMessageListener != null) {
                            this.mAstarteMessageListener.onFailure(e);
                            break block12;
                        }
                        e.printStackTrace();
                    }
                } else if (!this.eventuallyReconnect() && this.mAstarteMessageListener != null) {
                    this.mAstarteMessageListener.onFailure(cause);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTransportDisconnected() {
        AstartePairableDevice astartePairableDevice = this;
        synchronized (astartePairableDevice) {
            if (this.mAstarteMessageListener != null) {
                this.mAstarteMessageListener.onDisconnected(null);
            }
            if (this.alwaysReconnects() && !this.mExplicitDisconnectionRequest) {
                this.eventuallyReconnect();
            }
            this.mExplicitDisconnectionRequest = false;
        }
    }

    private void setFirstTransportFromPairingHandler() throws AstartePairingException {
        this.mAstarteTransport = this.mPairingHandler.getTransports().get(0);
        if (this.mAstarteTransport == null) {
            throw new AstartePairingException("Astarte returned no supported transports for the Device!");
        }
        this.configureTransport();
    }

    private void configureTransport() {
        this.mAstarteTransport.setDevice(this);
        this.mAstarteTransport.setPropertyStorage(this.mPropertyStorage);
        this.mAstarteTransport.setFailedMessageStorage(this.mFailedMessageStorage);
        this.mAstarteTransport.setAstarteTransportEventListener(this);
        if (this.mAstarteMessageListener != null) {
            this.mAstarteTransport.setMessageListener(this.mAstarteMessageListener);
        }
        for (AstarteInterface astarteInterface : this.getAllInterfaces()) {
            astarteInterface.setAstarteTransport(this.mAstarteTransport);
        }
    }
}

