/*
 * Decompiled with CFR 0.152.
 */
package org.astarteplatform.devicesdk;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.io.IOUtils;
import org.astarteplatform.devicesdk.AstartePairingException;
import org.astarteplatform.devicesdk.crypto.AstarteCryptoStore;
import org.astarteplatform.devicesdk.protocol.AstarteProtocolType;
import org.astarteplatform.devicesdk.transport.AstarteTransport;
import org.astarteplatform.devicesdk.transport.AstarteTransportFactory;
import org.json.JSONException;
import org.json.JSONObject;

public class AstartePairingHandler {
    private HttpUrl m_pairingUrl;
    private final String m_astarteRealm;
    private final String m_deviceId;
    private final String m_credentialSecret;
    final AstarteCryptoStore m_cryptoStore;
    private List<AstarteTransport> m_transports;
    private Certificate m_certificate;
    private final OkHttpClient m_httpClient = new OkHttpClient();
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");

    public AstartePairingHandler(String pairingUrl, String astarteRealm, String deviceId, String credentialSecret, AstarteCryptoStore cryptoStore) {
        this.m_astarteRealm = astarteRealm;
        this.m_deviceId = deviceId;
        this.m_credentialSecret = credentialSecret;
        this.m_cryptoStore = cryptoStore;
        this.m_pairingUrl = HttpUrl.parse((String)pairingUrl);
        HttpUrl.Builder builder = this.m_pairingUrl.newBuilder().addPathSegments("v1");
        this.m_pairingUrl = builder.build();
        this.m_certificate = this.m_cryptoStore.getCertificate();
    }

    public void init() throws AstartePairingException {
        this.reloadTransports();
    }

    public List<AstarteTransport> getTransports() {
        return this.m_transports;
    }

    public String getAstarteRealm() {
        return this.m_astarteRealm;
    }

    public String getDeviceId() {
        return this.m_deviceId;
    }

    public Certificate getCertificate() {
        return this.m_certificate;
    }

    public boolean isCertificateAvailable() {
        return this.m_cryptoStore.getCertificate() != null;
    }

    private void reloadTransports() throws AstartePairingException {
        JSONObject transports;
        HttpUrl requestUrl;
        try {
            HttpUrl.Builder builder = this.m_pairingUrl.newBuilder().addPathSegment(this.m_astarteRealm).addPathSegment("devices").addPathSegment(this.m_deviceId);
            requestUrl = builder.build();
        }
        catch (Exception e) {
            throw new AstartePairingException("Could not build Pairing URL", e);
        }
        Request request = new Request.Builder().url(requestUrl).header("Authorization", "Bearer " + this.m_credentialSecret).get().build();
        try (Response response = this.m_httpClient.newCall(request).execute();){
            String responseBody = response.body().string();
            System.out.println(responseBody);
            JSONObject responseJson = new JSONObject(responseBody);
            transports = responseJson.getJSONObject("data").getJSONObject("protocols");
        }
        catch (NullPointerException e) {
            throw new AstartePairingException("Null Pointer exception - probably got a wrong payload?", e);
        }
        catch (Exception e) {
            throw new AstartePairingException("Failure in calling Pairing API to " + requestUrl.toString(), e);
        }
        Iterator keys = transports.keys();
        this.m_transports = new LinkedList<AstarteTransport>();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            AstarteProtocolType protocolType = AstarteProtocolType.fromString(key);
            if (protocolType == null) {
                System.out.println("Found unsupported protocol " + key);
                continue;
            }
            try {
                AstarteTransport supportedTransport = AstarteTransportFactory.createAstarteTransportFromPairing(protocolType, this.m_astarteRealm, this.m_deviceId, transports.getJSONObject(key), this.m_cryptoStore);
                this.m_transports.add(supportedTransport);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.m_transports.isEmpty()) {
            throw new AstartePairingException("Pairing did not return any supported Transport.");
        }
    }

    public void requestNewCertificate() throws AstartePairingException {
        HttpUrl requestUrl;
        String csr;
        try {
            csr = this.m_cryptoStore.generateCSR("CN=" + this.m_astarteRealm + "/" + this.m_deviceId);
        }
        catch (Exception e) {
            throw new AstartePairingException("Could not generate a CSR", e);
        }
        JSONObject payload = new JSONObject();
        try {
            JSONObject data = new JSONObject();
            data.put("csr", (Object)csr);
            payload.put("data", (Object)data);
        }
        catch (JSONException e) {
            throw new AstartePairingException("Could not generate the JSON Request Payload", e);
        }
        try {
            HttpUrl.Builder builder = this.m_pairingUrl.newBuilder().addPathSegment(this.m_astarteRealm).addPathSegment("devices").addPathSegment(this.m_deviceId).addPathSegments("protocols/astarte_mqtt_v1/credentials");
            requestUrl = builder.build();
        }
        catch (Exception e) {
            throw new AstartePairingException("Could not build Pairing URL", e);
        }
        RequestBody body = RequestBody.create((MediaType)JSON, (String)payload.toString());
        Request request = new Request.Builder().url(requestUrl).header("Authorization", "Bearer " + this.m_credentialSecret).post(body).build();
        try (Response response = this.m_httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new AstartePairingException("Request to Pairing API failed with " + response.code() + ". Returned body is " + response.body().string());
            }
            String responseBody = response.body().string();
            JSONObject responseJson = new JSONObject(responseBody);
            CertificateFactory fact = CertificateFactory.getInstance("X.509");
            InputStream certificateStream = IOUtils.toInputStream((String)responseJson.getJSONObject("data").getString("client_crt"), (Charset)Charset.defaultCharset());
            X509Certificate astarteCertificate = (X509Certificate)fact.generateCertificate(certificateStream);
            this.m_cryptoStore.setAstarteCertificate(astarteCertificate);
            this.m_certificate = astarteCertificate;
        }
        catch (NullPointerException e) {
            throw new AstartePairingException("Null Pointer exception - probably got a wrong payload?", e);
        }
        catch (Exception e) {
            throw new AstartePairingException("Failure in calling Pairing API", e);
        }
    }
}

