/*
 * Decompiled with CFR 0.152.
 */
package org.astarteplatform.devicesdk.transport.mqtt;

import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.astarteplatform.devicesdk.transport.mqtt.MqttConnectionInfo;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;

public class MutualSSLAuthenticationMqttConnectionInfo
implements MqttConnectionInfo {
    private final String m_brokerUrl;
    private final MqttConnectOptions m_mqttConnectOptions;
    private final String m_clientId;

    public MutualSSLAuthenticationMqttConnectionInfo(String brokerUrl, String astarteRealm, String deviceId, SSLSocketFactory sslSocketFactory) {
        this.m_brokerUrl = brokerUrl;
        this.m_mqttConnectOptions = new MqttConnectOptions();
        this.m_mqttConnectOptions.setConnectionTimeout(60);
        this.m_mqttConnectOptions.setKeepAliveInterval(60);
        this.m_mqttConnectOptions.setMaxInflight(128);
        this.m_mqttConnectOptions.setAutomaticReconnect(false);
        try {
            this.m_mqttConnectOptions.setSocketFactory((SocketFactory)sslSocketFactory);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_clientId = astarteRealm + "/" + deviceId;
    }

    @Override
    public String getBrokerUrl() {
        return this.m_brokerUrl;
    }

    @Override
    public String getClientId() {
        return this.m_clientId;
    }

    @Override
    public MqttConnectOptions getMqttConnectOptions() {
        return this.m_mqttConnectOptions;
    }
}

