/*
 * Decompiled with CFR 0.152.
 */
package org.astarteplatform.devicesdk;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.io.IOUtils;
import org.astarteplatform.devicesdk.AstartePairingException;
import org.astarteplatform.devicesdk.AstartePairingServiceException;
import org.astarteplatform.devicesdk.crypto.AstarteCryptoStore;
import org.astarteplatform.devicesdk.protocol.AstarteProtocolType;
import org.astarteplatform.devicesdk.transport.AstarteTransport;
import org.astarteplatform.devicesdk.transport.AstarteTransportFactory;
import org.json.JSONException;
import org.json.JSONObject;

public final class AstartePairingService {
    private HttpUrl m_pairingUrl;
    private final String m_astarteRealm;
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private final OkHttpClient m_httpClient;

    public AstartePairingService(String pairingUrl, String astarteRealm) {
        this.m_astarteRealm = astarteRealm;
        this.m_pairingUrl = HttpUrl.parse((String)pairingUrl);
        if (this.m_pairingUrl == null) {
            throw new IllegalStateException();
        }
        this.m_pairingUrl = this.m_pairingUrl.newBuilder().addPathSegments("v1").build();
        this.m_httpClient = new OkHttpClient();
    }

    public String registerDevice(String jwtToken, String deviceId) throws IOException, AstartePairingException {
        String credentialsSecret;
        block18: {
            HttpUrl registerUrl;
            JSONObject payload = new JSONObject();
            try {
                JSONObject data = new JSONObject();
                data.put("hw_id", (Object)deviceId);
                payload.put("data", (Object)data);
            }
            catch (JSONException e) {
                throw new AstartePairingServiceException("Could not generate the JSON Request Payload", e);
            }
            try {
                HttpUrl.Builder builder = this.m_pairingUrl.newBuilder().addPathSegment(this.m_astarteRealm).addPathSegment("agent").addPathSegment("devices");
                registerUrl = builder.build();
            }
            catch (Exception e) {
                throw new AstartePairingServiceException("Could not build Register Device URL", e);
            }
            RequestBody body = RequestBody.create((MediaType)JSON, (String)payload.toString());
            Request request = new Request.Builder().url(registerUrl).header("Authorization", "Bearer " + jwtToken).post(body).build();
            try (Response response = this.m_httpClient.newCall(request).execute();){
                Optional<ResponseBody> optBody = Optional.ofNullable(response.body());
                if (!response.isSuccessful() || !optBody.isPresent()) {
                    throw new AstartePairingException("Request to device register API failed with " + response.code() + ". Returned body is " + (optBody.isPresent() ? optBody.get().string() : "empty"));
                }
                String responseBody = optBody.get().string();
                JSONObject responseJson = new JSONObject(responseBody);
                Optional<String> optCredentialsSecret = Optional.ofNullable(responseJson.optJSONObject("data").optString("credentials_secret"));
                if (optCredentialsSecret.isPresent()) {
                    credentialsSecret = optCredentialsSecret.get();
                    break block18;
                }
                throw new AstartePairingException("Failure in calling device register API");
            }
        }
        return credentialsSecret;
    }

    protected List<AstarteTransport> reloadTransports(String credentialSecret, AstarteCryptoStore cryptoStore, String deviceId) throws AstartePairingException {
        JSONObject transportObjects;
        HttpUrl requestUrl;
        try {
            HttpUrl.Builder builder = this.m_pairingUrl.newBuilder().addPathSegment(this.m_astarteRealm).addPathSegment("devices").addPathSegment(deviceId);
            requestUrl = builder.build();
        }
        catch (Exception e) {
            throw new AstartePairingException("Could not build Pairing URL", e);
        }
        Request request = new Request.Builder().url(requestUrl).header("Authorization", "Bearer " + credentialSecret).get().build();
        try (Response response = this.m_httpClient.newCall(request).execute();){
            String responseBody = response.body().string();
            System.out.println(responseBody);
            JSONObject responseJson = new JSONObject(responseBody);
            transportObjects = responseJson.getJSONObject("data").getJSONObject("protocols");
        }
        catch (NullPointerException e) {
            throw new AstartePairingException("Null Pointer exception - probably got a wrong payload?", e);
        }
        catch (Exception e) {
            throw new AstartePairingException("Failure in calling Pairing API to " + requestUrl.toString(), e);
        }
        Iterator keys = transportObjects.keys();
        LinkedList<AstarteTransport> transports = new LinkedList<AstarteTransport>();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            AstarteProtocolType protocolType = AstarteProtocolType.fromString(key);
            if (protocolType == null) {
                System.out.println("Found unsupported protocol " + key);
                continue;
            }
            try {
                AstarteTransport supportedTransport = AstarteTransportFactory.createAstarteTransportFromPairing(protocolType, this.m_astarteRealm, deviceId, transportObjects.getJSONObject(key), cryptoStore);
                transports.add(supportedTransport);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (transports.isEmpty()) {
            throw new AstartePairingException("Pairing did not return any supported Transport.");
        }
        return transports;
    }

    protected Certificate requestNewCertificate(String credentialSecret, AstarteCryptoStore cryptoStore, String deviceId) throws AstartePairingException {
        X509Certificate certificate;
        HttpUrl requestUrl;
        String csr;
        try {
            csr = cryptoStore.generateCSR("CN=" + this.m_astarteRealm + "/" + deviceId);
        }
        catch (Exception e) {
            throw new AstartePairingException("Could not generate a CSR", e);
        }
        JSONObject payload = new JSONObject();
        try {
            JSONObject data = new JSONObject();
            data.put("csr", (Object)csr);
            payload.put("data", (Object)data);
        }
        catch (JSONException e) {
            throw new AstartePairingException("Could not generate the JSON Request Payload", e);
        }
        try {
            HttpUrl.Builder builder = this.m_pairingUrl.newBuilder().addPathSegment(this.m_astarteRealm).addPathSegment("devices").addPathSegment(deviceId).addPathSegments("protocols/astarte_mqtt_v1/credentials");
            requestUrl = builder.build();
        }
        catch (Exception e) {
            throw new AstartePairingException("Could not build Pairing URL", e);
        }
        RequestBody body = RequestBody.create((MediaType)JSON, (String)payload.toString());
        Request request = new Request.Builder().url(requestUrl).header("Authorization", "Bearer " + credentialSecret).post(body).build();
        try (Response response = this.m_httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new AstartePairingException("Request to Pairing API failed with " + response.code() + ". Returned body is " + response.body().string());
            }
            String responseBody = response.body().string();
            JSONObject responseJson = new JSONObject(responseBody);
            CertificateFactory fact = CertificateFactory.getInstance("X.509");
            InputStream certificateStream = IOUtils.toInputStream((String)responseJson.getJSONObject("data").getString("client_crt"), (Charset)Charset.defaultCharset());
            X509Certificate astarteCertificate = (X509Certificate)fact.generateCertificate(certificateStream);
            cryptoStore.setAstarteCertificate(astarteCertificate);
            certificate = astarteCertificate;
        }
        catch (NullPointerException e) {
            throw new AstartePairingException("Null Pointer exception - probably got a wrong payload?", e);
        }
        catch (Exception e) {
            throw new AstartePairingException("Failure in calling Pairing API", e);
        }
        return certificate;
    }
}

