/*
 * Decompiled with CFR 0.152.
 */
package org.astarteplatform.devicesdk.protocol;

import java.util.Map;
import org.astarteplatform.devicesdk.AstartePropertyStorage;
import org.astarteplatform.devicesdk.AstartePropertyStorageException;
import org.astarteplatform.devicesdk.protocol.AstarteInterface;
import org.joda.time.DateTime;

public abstract class AstartePropertyInterface
extends AstarteInterface {
    final AstartePropertyStorage mPropertyStorage;

    AstartePropertyInterface(AstartePropertyStorage propertyStorage) {
        this.mPropertyStorage = propertyStorage;
    }

    public Map<String, Object> getAllValues() {
        if (this.mPropertyStorage == null) {
            return null;
        }
        try {
            return this.mPropertyStorage.getStoredValuesForInterface(this);
        }
        catch (AstartePropertyStorageException e) {
            return null;
        }
    }

    Object getPropertyValue(String path) {
        if (this.mPropertyStorage == null) {
            return null;
        }
        Map<String, Object> storedPaths = null;
        try {
            storedPaths = this.mPropertyStorage.getStoredValuesForInterface(this);
        }
        catch (AstartePropertyStorageException e) {
            return null;
        }
        if (!storedPaths.containsKey(path)) {
            return null;
        }
        return storedPaths.get(path);
    }

    public String getPropertyValueString(String path) {
        return (String)this.getPropertyValue(path);
    }

    public boolean getPropertyValueBoolean(String path) {
        return (Boolean)this.getPropertyValue(path);
    }

    public int getPropertyValueInt(String path) {
        return (Integer)this.getPropertyValue(path);
    }

    public long getPropertyValueLong(String path) {
        return (Long)this.getPropertyValue(path);
    }

    public double getPropertyValueDouble(String path) {
        return (Double)this.getPropertyValue(path);
    }

    public byte[] getPropertyValueByteArray(String path) {
        return (byte[])this.getPropertyValue(path);
    }

    public DateTime getPropertyValueDateTime(String path) {
        return (DateTime)this.getPropertyValue(path);
    }
}

