/*
 * Decompiled with CFR 0.152.
 */
package org.astarteplatform.devicesdk.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.UUID;

public class UUID5 {
    private static final Charset UTF8 = StandardCharsets.UTF_8;

    public static UUID nameUUIDFromNamespaceAndString(UUID namespace, String data) {
        return UUID5.nameUUIDFromNamespaceAndBytes(namespace, Objects.requireNonNull(data, "data == null").getBytes(UTF8));
    }

    public static UUID nameUUIDFromNamespaceAndBytes(UUID namespace, byte[] data) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new InternalError("SHA-1 not supported");
        }
        md.update(UUID5.toBytes(Objects.requireNonNull(namespace, "namespace is null")));
        md.update(Objects.requireNonNull(data, "data is null"));
        byte[] sha1Bytes = md.digest();
        sha1Bytes[6] = (byte)(sha1Bytes[6] & 0xF);
        sha1Bytes[6] = (byte)(sha1Bytes[6] | 0x50);
        sha1Bytes[8] = (byte)(sha1Bytes[8] & 0x3F);
        sha1Bytes[8] = (byte)(sha1Bytes[8] | 0x80);
        return UUID5.fromBytes(sha1Bytes);
    }

    private static UUID fromBytes(byte[] data) {
        int i;
        long msb = 0L;
        long lsb = 0L;
        assert (data.length >= 16);
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(data[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(data[i] & 0xFF);
        }
        return new UUID(msb, lsb);
    }

    private static byte[] toBytes(UUID uuid) {
        int i;
        byte[] out = new byte[16];
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        for (i = 0; i < 8; ++i) {
            out[i] = (byte)(msb >> (7 - i) * 8 & 0xFFL);
        }
        for (i = 8; i < 16; ++i) {
            out[i] = (byte)(lsb >> (15 - i) * 8 & 0xFFL);
        }
        return out;
    }
}

