/*
 * Decompiled with CFR 0.152.
 */
package org.astarteplatform.devicesdk.protocol;

import org.astarteplatform.devicesdk.protocol.AstarteInterfaceMapping;
import org.json.JSONException;
import org.json.JSONObject;

public class AstarteInterfaceDatastreamMapping
extends AstarteInterfaceMapping {
    private boolean explicitTimestamp = false;
    private MappingReliability reliability = MappingReliability.UNRELIABLE;
    private MappingRetention retention = MappingRetention.DISCARD;
    private int expiry = 0;

    static AstarteInterfaceDatastreamMapping fromJSON(JSONObject astarteMappingObject) throws JSONException {
        AstarteInterfaceDatastreamMapping astarteInterfaceDatastreamMapping = new AstarteInterfaceDatastreamMapping();
        astarteInterfaceDatastreamMapping.parseMappingFromJSON(astarteMappingObject);
        try {
            astarteInterfaceDatastreamMapping.explicitTimestamp = astarteMappingObject.getBoolean("explicit_timestamp");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            astarteInterfaceDatastreamMapping.reliability = MappingReliability.fromString(astarteMappingObject.getString("reliability"));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            astarteInterfaceDatastreamMapping.retention = MappingRetention.fromString(astarteMappingObject.getString("retention"));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            astarteInterfaceDatastreamMapping.expiry = astarteMappingObject.getInt("expiry");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return astarteInterfaceDatastreamMapping;
    }

    public boolean isExplicitTimestamp() {
        return this.explicitTimestamp;
    }

    public MappingReliability getReliability() {
        return this.reliability;
    }

    public MappingRetention getRetention() {
        return this.retention;
    }

    public int getExpiry() {
        return this.expiry;
    }

    public static enum MappingRetention {
        DISCARD("discard"),
        VOLATILE("volatile"),
        STORED("stored");

        public final String label;

        private MappingRetention(String label) {
            this.label = label;
        }

        public String toString() {
            return String.valueOf(this.label);
        }

        public static MappingRetention fromString(String text) {
            for (MappingRetention t : MappingRetention.values()) {
                if (!t.label.equalsIgnoreCase(text)) continue;
                return t;
            }
            return null;
        }
    }

    public static enum MappingReliability {
        UNRELIABLE("unreliable"),
        GUARANTEED("guaranteed"),
        UNIQUE("unique");

        public final String label;

        private MappingReliability(String label) {
            this.label = label;
        }

        public String toString() {
            return String.valueOf(this.label);
        }

        public static MappingReliability fromString(String text) {
            for (MappingReliability t : MappingReliability.values()) {
                if (!t.label.equalsIgnoreCase(text)) continue;
                return t;
            }
            return null;
        }
    }
}

