/*
 * Decompiled with CFR 0.152.
 */
package org.astarteplatform.devicesdk.transport.mqtt;

import javax.net.ssl.SSLHandshakeException;
import org.astarteplatform.devicesdk.AstarteMessageListener;
import org.astarteplatform.devicesdk.crypto.AstarteCryptoException;
import org.astarteplatform.devicesdk.protocol.AstarteProtocolType;
import org.astarteplatform.devicesdk.transport.AstarteTransport;
import org.astarteplatform.devicesdk.transport.AstarteTransportException;
import org.astarteplatform.devicesdk.transport.mqtt.MqttConnectionInfo;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttException;

public abstract class AstarteMqttTransport
extends AstarteTransport
implements IMqttActionListener {
    protected MqttAsyncClient m_client;
    private final MqttConnectionInfo m_connectionInfo;
    private MqttCallback mMqttCallback;
    private final IMqttActionListener mMqttActionListener = new IMqttActionListener(){

        public void onSuccess(IMqttToken asyncActionToken) {
            block2: {
                try {
                    AstarteMqttTransport.this.onConnected(asyncActionToken);
                }
                catch (AstarteTransportException e) {
                    if (AstarteMqttTransport.this.m_astarteTransportEventListener == null) break block2;
                    AstarteMqttTransport.this.m_astarteTransportEventListener.onTransportConnectionInitializationError(e);
                }
            }
        }

        public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
            AstarteMessageListener listener;
            Exception derivedException = null;
            derivedException = exception.getCause() instanceof NullPointerException ? new AstarteCryptoException("Missing Device Certificate", exception) : (exception.getCause() instanceof SSLHandshakeException ? new AstarteCryptoException("Invalid Device Certificate", exception) : new AstarteTransportException("Error while connecting", exception));
            if (AstarteMqttTransport.this.m_astarteTransportEventListener != null) {
                AstarteMqttTransport.this.m_astarteTransportEventListener.onTransportConnectionError(derivedException);
            }
            if ((listener = AstarteMqttTransport.this.getMessageListener()) != null) {
                listener.onFailure(derivedException);
            } else {
                derivedException.printStackTrace();
            }
            exception.printStackTrace();
        }
    };

    protected AstarteMqttTransport(AstarteProtocolType type, MqttConnectionInfo connectionInfo) {
        super(type);
        this.m_connectionInfo = connectionInfo;
    }

    protected void setCallback(MqttCallback callback) {
        this.mMqttCallback = callback;
    }

    public MqttConnectionInfo getConnectionInfo() {
        return this.m_connectionInfo;
    }

    private void initClient() {
        String brokerUrl;
        if (this.m_client != null) {
            try {
                this.m_client.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((brokerUrl = this.m_connectionInfo.getBrokerUrl()).startsWith("mqtts")) {
            brokerUrl = brokerUrl.replace("mqtts", "ssl");
        }
        try {
            this.m_client = new MqttAsyncClient(brokerUrl, this.m_connectionInfo.getClientId(), null);
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
        this.m_client.setCallback(this.mMqttCallback);
    }

    @Override
    public void connect() throws AstarteTransportException, AstarteCryptoException {
        try {
            if (this.m_client != null) {
                if (this.m_client.isConnected()) {
                    return;
                }
            } else {
                this.initClient();
            }
            this.m_client.connect(this.m_connectionInfo.getMqttConnectOptions(), null, this.mMqttActionListener);
        }
        catch (MqttException e) {
            if (e.getCause() instanceof NullPointerException) {
                throw new AstarteCryptoException("Missing Device Certificate", e);
            }
            if (e.getCause() instanceof SSLHandshakeException) {
                throw new AstarteCryptoException("Invalid Device Certificate", e);
            }
            throw new AstarteTransportException(e);
        }
    }

    @Override
    public void disconnect() throws AstarteTransportException {
        try {
            if (this.m_client.isConnected()) {
                this.m_client.disconnect();
            }
        }
        catch (MqttException e) {
            throw new AstarteTransportException(e);
        }
    }

    @Override
    public boolean isConnected() {
        if (this.m_client == null) {
            return false;
        }
        return this.m_client.isConnected();
    }

    public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
        Exception failureCause = null;
        failureCause = exception.getCause() instanceof NullPointerException ? new AstarteCryptoException("Missing Device Certificate", exception) : (exception.getCause() instanceof SSLHandshakeException ? new AstarteCryptoException("Invalid Device Certificate", exception) : new AstarteTransportException(exception));
        if (this.m_astarteTransportEventListener == null) {
            failureCause.printStackTrace();
            return;
        }
        this.m_astarteTransportEventListener.onTransportConnectionError(failureCause);
    }

    protected abstract void onConnected(IMqttToken var1) throws AstarteTransportException;
}

