/*
 * Decompiled with CFR 0.152.
 */
package org.astarteplatform.devicesdk.protocol;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.astarteplatform.devicesdk.AstartePropertyStorage;
import org.astarteplatform.devicesdk.protocol.AstarteAggregateDatastreamInterface;
import org.astarteplatform.devicesdk.protocol.AstarteDeviceAggregateDatastreamInterface;
import org.astarteplatform.devicesdk.protocol.AstarteDeviceDatastreamInterface;
import org.astarteplatform.devicesdk.protocol.AstarteDevicePropertyInterface;
import org.astarteplatform.devicesdk.protocol.AstarteInterfaceDatastreamMapping;
import org.astarteplatform.devicesdk.protocol.AstarteInterfaceMapping;
import org.astarteplatform.devicesdk.protocol.AstarteInterfaceMappingNotFoundException;
import org.astarteplatform.devicesdk.protocol.AstarteInvalidInterfaceException;
import org.astarteplatform.devicesdk.protocol.AstarteInvalidValueException;
import org.astarteplatform.devicesdk.protocol.AstarteServerAggregateDatastreamInterface;
import org.astarteplatform.devicesdk.protocol.AstarteServerDatastreamInterface;
import org.astarteplatform.devicesdk.protocol.AstarteServerPropertyInterface;
import org.astarteplatform.devicesdk.transport.AstarteTransport;
import org.joda.time.DateTime;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AstarteInterface {
    private String interfaceName;
    private int majorVersion;
    private int minorVersion;
    private Map<String, AstarteInterfaceMapping> mappings;
    private AstarteTransport mAstarteTransport;

    public AstarteTransport getAstarteTransport() {
        return this.mAstarteTransport;
    }

    public void setAstarteTransport(AstarteTransport astarteTransport) {
        this.mAstarteTransport = astarteTransport;
    }

    public static AstarteInterface fromJSON(JSONObject astarteInterfaceObject, AstartePropertyStorage propertyStorage) throws JSONException, AstarteInvalidInterfaceException {
        boolean astarteInterfaceExplicitTimestamp;
        String astarteInterfaceAggregation;
        String astarteInterfaceType = astarteInterfaceObject.getString("type");
        String astarteInterfaceOwnership = astarteInterfaceObject.getString("ownership");
        try {
            astarteInterfaceAggregation = astarteInterfaceObject.getString("aggregation");
        }
        catch (JSONException e) {
            astarteInterfaceAggregation = "individual";
        }
        try {
            astarteInterfaceExplicitTimestamp = astarteInterfaceObject.getBoolean("explicit_timestamp");
        }
        catch (JSONException e) {
            astarteInterfaceExplicitTimestamp = false;
        }
        AstarteInterface astarteInterface = null;
        if (astarteInterfaceType.equals("properties")) {
            if (astarteInterfaceOwnership.equals("device")) {
                astarteInterface = new AstarteDevicePropertyInterface(propertyStorage);
            } else if (astarteInterfaceOwnership.equals("server")) {
                astarteInterface = new AstarteServerPropertyInterface(propertyStorage);
            }
        } else if (astarteInterfaceType.equals("datastream")) {
            AstarteAggregateDatastreamInterface aggregateDatastreamInterface;
            if (astarteInterfaceOwnership.equals("device")) {
                if (astarteInterfaceAggregation.equals("individual")) {
                    astarteInterface = new AstarteDeviceDatastreamInterface();
                } else if (astarteInterfaceAggregation.equals("object")) {
                    aggregateDatastreamInterface = new AstarteDeviceAggregateDatastreamInterface();
                    aggregateDatastreamInterface.explicitTimestamp = astarteInterfaceExplicitTimestamp;
                    astarteInterface = aggregateDatastreamInterface;
                }
            } else if (astarteInterfaceOwnership.equals("server")) {
                if (astarteInterfaceAggregation.equals("individual")) {
                    astarteInterface = new AstarteServerDatastreamInterface();
                } else if (astarteInterfaceAggregation.equals("object")) {
                    aggregateDatastreamInterface = new AstarteServerAggregateDatastreamInterface();
                    aggregateDatastreamInterface.explicitTimestamp = astarteInterfaceExplicitTimestamp;
                    astarteInterface = aggregateDatastreamInterface;
                }
            }
        }
        if (astarteInterface == null) {
            throw new AstarteInvalidInterfaceException("Couldn't parse the interface");
        }
        astarteInterface.interfaceName = astarteInterfaceObject.getString("interface_name");
        astarteInterface.majorVersion = astarteInterfaceObject.getInt("version_major");
        astarteInterface.minorVersion = astarteInterfaceObject.getInt("version_minor");
        astarteInterface.mappings = new HashMap<String, AstarteInterfaceMapping>();
        JSONArray jsonMappings = astarteInterfaceObject.getJSONArray("mappings");
        for (int i = 0; i < jsonMappings.length(); ++i) {
            if (Objects.equals(astarteInterfaceType, "datastream")) {
                astarteInterface.mappings.put(jsonMappings.getJSONObject(i).getString("endpoint"), AstarteInterfaceDatastreamMapping.fromJSON(jsonMappings.getJSONObject(i)));
                continue;
            }
            astarteInterface.mappings.put(jsonMappings.getJSONObject(i).getString("endpoint"), AstarteInterfaceMapping.fromJSON(jsonMappings.getJSONObject(i)));
        }
        return astarteInterface;
    }

    public static AstarteInterfaceMapping findMappingInInterface(AstarteInterface astarteInterface, String path) throws AstarteInterfaceMappingNotFoundException {
        for (Map.Entry<String, AstarteInterfaceMapping> mappingEntry : astarteInterface.getMappings().entrySet()) {
            if (!AstarteInterface.isPathCompatibleWithMapping(path, mappingEntry.getKey())) continue;
            return mappingEntry.getValue();
        }
        throw new AstarteInterfaceMappingNotFoundException("Mapping " + path + " not found in interface " + astarteInterface);
    }

    public static void validatePayload(AstarteInterface astarteInterface, String path, Object payload) throws AstarteInvalidValueException, AstarteInterfaceMappingNotFoundException {
        AstarteInterface.validatePayload(astarteInterface, path, payload, null);
    }

    public static void validatePayload(AstarteInterface astarteInterface, String path, Object payload, DateTime timestamp) throws AstarteInvalidValueException, AstarteInterfaceMappingNotFoundException {
        AstarteInterface.validatePayload(AstarteInterface.findMappingInInterface(astarteInterface, path), payload, timestamp);
    }

    public static void validatePayload(AstarteInterfaceMapping mapping, Object payload) throws AstarteInvalidValueException {
        if (!mapping.isTypeCompatible(payload.getClass())) {
            throw new AstarteInvalidValueException("Payload type " + payload.getClass() + " is incompatible with mapping type " + mapping.getType());
        }
    }

    public static void validatePayload(AstarteInterfaceMapping mapping, Object payload, DateTime timestamp) throws AstarteInvalidValueException {
        AstarteInterface.validatePayload(mapping, payload);
        if (mapping instanceof AstarteInterfaceDatastreamMapping) {
            AstarteInterfaceDatastreamMapping datastreamMapping = (AstarteInterfaceDatastreamMapping)mapping;
            if (datastreamMapping.isExplicitTimestamp() && timestamp == null) {
                throw new AstarteInvalidValueException("This mapping has an explicit timestamp, but no timestamp has been specified.");
            }
        } else if (timestamp != null) {
            throw new AstarteInvalidValueException("When sending a property, explicit timestamp is always ignored");
        }
    }

    public static void validateAggregate(AstarteInterface astarteInterface, String pathPrefix, Map<String, Object> payload, DateTime timestamp) throws AstarteInvalidValueException, AstarteInterfaceMappingNotFoundException {
        if (astarteInterface.getMappings().size() != payload.size()) {
            throw new AstarteInterfaceMappingNotFoundException("The interface mapping and the payload don't match.");
        }
        for (Map.Entry<String, Object> payloadEntry : payload.entrySet()) {
            String path = pathPrefix + "/" + payloadEntry.getKey();
            AstarteInterface.validatePayload(AstarteInterface.findMappingInInterface(astarteInterface, path), payloadEntry.getValue(), timestamp);
        }
    }

    public static boolean isPathCompatibleWithMapping(String path, String mapping) {
        String[] pathTokens;
        String[] mappingTokens = mapping.split("/");
        if (mappingTokens.length != (pathTokens = path.split("/")).length) {
            return false;
        }
        boolean matches = true;
        for (int k = 0; k < mappingTokens.length; ++k) {
            if (mappingTokens[k].contains("%{") || Objects.equals(mappingTokens[k], pathTokens[k])) continue;
            matches = false;
            break;
        }
        return matches;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public Map<String, AstarteInterfaceMapping> getMappings() {
        return this.mappings;
    }
}

