/*
 * Decompiled with CFR 0.152.
 */
package org.astarteplatform.devicesdk.protocol;

import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import org.joda.time.DateTime;
import org.json.JSONException;
import org.json.JSONObject;

public class AstarteInterfaceMapping {
    private String path;
    private Type type;
    private static final Collection<Collection<Type>> mTypeCompatibilityList = new HashSet<Collection<Type>>();

    static AstarteInterfaceMapping fromJSON(JSONObject astarteMappingObject) throws JSONException {
        AstarteInterfaceMapping astarteInterfaceMapping = new AstarteInterfaceMapping();
        astarteInterfaceMapping.parseMappingFromJSON(astarteMappingObject);
        return astarteInterfaceMapping;
    }

    protected void parseMappingFromJSON(JSONObject astarteMappingObject) throws JSONException {
        this.path = astarteMappingObject.getString("endpoint");
        this.type = AstarteInterfaceMapping.stringToJavaType(astarteMappingObject.getString("type"));
    }

    public String getPath() {
        return this.path;
    }

    public Type getType() {
        return this.type;
    }

    boolean isTypeCompatible(Type otherType) {
        for (Collection<Type> compatibilityList : mTypeCompatibilityList) {
            if (!compatibilityList.contains(otherType) || !compatibilityList.contains(this.getType())) continue;
            return true;
        }
        return false;
    }

    boolean isTypeCompatible(String astarteType) {
        for (Collection<Type> compatibilityList : mTypeCompatibilityList) {
            if (!compatibilityList.contains(AstarteInterfaceMapping.stringToJavaType(astarteType)) || !compatibilityList.contains(this.getType())) continue;
            return true;
        }
        return false;
    }

    private static Type stringToJavaType(String typeString) {
        if (Objects.equals(typeString, "string")) {
            return String.class;
        }
        if (Objects.equals(typeString, "integer")) {
            return Integer.class;
        }
        if (Objects.equals(typeString, "double")) {
            return Double.class;
        }
        if (Objects.equals(typeString, "longinteger")) {
            return Long.class;
        }
        if (Objects.equals(typeString, "boolean")) {
            return Boolean.class;
        }
        if (Objects.equals(typeString, "binaryblob")) {
            return Byte[].class;
        }
        if (Objects.equals(typeString, "datetime")) {
            return DateTime.class;
        }
        return Object.class;
    }

    static {
        HashSet<Class<Number>> numberCompatibilityList = new HashSet<Class<Number>>();
        numberCompatibilityList.add(Integer.TYPE);
        numberCompatibilityList.add(Long.TYPE);
        numberCompatibilityList.add(Float.TYPE);
        numberCompatibilityList.add(Double.TYPE);
        numberCompatibilityList.add(Integer.class);
        numberCompatibilityList.add(Long.class);
        numberCompatibilityList.add(BigInteger.class);
        numberCompatibilityList.add(Float.class);
        numberCompatibilityList.add(Double.class);
        HashSet<Class<Boolean>> booleanCompatibilityList = new HashSet<Class<Boolean>>();
        booleanCompatibilityList.add(Boolean.TYPE);
        booleanCompatibilityList.add(Boolean.class);
        HashSet<Class<String>> stringCompatibilityList = new HashSet<Class<String>>();
        stringCompatibilityList.add(String.class);
        HashSet<Class<DateTime>> dateTimeCompatibilityList = new HashSet<Class<DateTime>>();
        dateTimeCompatibilityList.add(DateTime.class);
        HashSet<Class> byteArrayCompatibilityList = new HashSet<Class>();
        byteArrayCompatibilityList.add(byte[].class);
        byteArrayCompatibilityList.add(Byte[].class);
        mTypeCompatibilityList.add(numberCompatibilityList);
        mTypeCompatibilityList.add(booleanCompatibilityList);
        mTypeCompatibilityList.add(stringCompatibilityList);
        mTypeCompatibilityList.add(dateTimeCompatibilityList);
        mTypeCompatibilityList.add(byteArrayCompatibilityList);
    }
}

