/*
 * Decompiled with CFR 0.152.
 */
package org.astarteplatform.devicesdk;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.astarteplatform.devicesdk.AstarteInterfaceProvider;
import org.astarteplatform.devicesdk.AstarteMessageListener;
import org.astarteplatform.devicesdk.AstartePairingException;
import org.astarteplatform.devicesdk.AstartePropertyStorage;
import org.astarteplatform.devicesdk.crypto.AstarteCryptoException;
import org.astarteplatform.devicesdk.protocol.AstarteGlobalEventListener;
import org.astarteplatform.devicesdk.protocol.AstarteInterface;
import org.astarteplatform.devicesdk.protocol.AstarteInterfaceAlreadyPresentException;
import org.astarteplatform.devicesdk.protocol.AstarteInterfaceNotFoundException;
import org.astarteplatform.devicesdk.protocol.AstarteInvalidInterfaceException;
import org.astarteplatform.devicesdk.protocol.AstarteServerAggregateDatastreamInterface;
import org.astarteplatform.devicesdk.protocol.AstarteServerDatastreamInterface;
import org.astarteplatform.devicesdk.protocol.AstarteServerPropertyInterface;
import org.astarteplatform.devicesdk.transport.AstarteFailedMessageStorage;
import org.astarteplatform.devicesdk.transport.AstarteTransportException;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AstarteDevice {
    private final Map<String, AstarteInterface> mAstarteInterfaces;
    protected final AstartePropertyStorage mPropertyStorage;
    protected final AstarteFailedMessageStorage mFailedMessageStorage;
    protected boolean mAlwaysReconnect;

    AstarteDevice(AstarteInterfaceProvider astarteInterfaceProvider, AstartePropertyStorage propertyStorage, AstarteFailedMessageStorage failedMessageStorage) throws JSONException, AstarteInvalidInterfaceException {
        this.mPropertyStorage = propertyStorage;
        this.mFailedMessageStorage = failedMessageStorage;
        Collection<JSONObject> astarteInterfaces = astarteInterfaceProvider.loadAllInterfaces();
        this.mAstarteInterfaces = new HashMap<String, AstarteInterface>();
        for (JSONObject astarteInterface : astarteInterfaces) {
            AstarteInterface theInterface = AstarteInterface.fromJSON(astarteInterface, this.mPropertyStorage);
            this.mAstarteInterfaces.put(theInterface.getInterfaceName(), theInterface);
        }
    }

    public boolean hasInterface(String interfaceName) {
        return this.mAstarteInterfaces.containsKey(interfaceName);
    }

    public void addInterface(JSONObject astarteInterfaceObject) throws AstarteInvalidInterfaceException, AstarteInterfaceAlreadyPresentException {
        AstarteInterface newInterface = AstarteInterface.fromJSON(astarteInterfaceObject, this.mPropertyStorage);
        AstarteInterface formerInterface = this.getInterface(newInterface.getInterfaceName());
        if (formerInterface != null && formerInterface.getMajorVersion() == newInterface.getMajorVersion()) {
            if (formerInterface.getMinorVersion() == newInterface.getMinorVersion()) {
                throw new AstarteInterfaceAlreadyPresentException("Interface already present in mapping");
            }
            if (formerInterface.getMinorVersion() > newInterface.getMinorVersion()) {
                throw new AstarteInvalidInterfaceException("Can't downgrade an interface at runtime");
            }
        }
        this.mAstarteInterfaces.put(newInterface.getInterfaceName(), newInterface);
    }

    public void removeInterface(String interfaceName) throws AstarteInterfaceNotFoundException {
        AstarteInterface formerInterface = this.getInterface(interfaceName);
        if (formerInterface == null) {
            throw new AstarteInterfaceNotFoundException("Interface " + interfaceName + " not found");
        }
        this.mAstarteInterfaces.remove(interfaceName);
    }

    public Collection<String> getAllInterfaceNames() {
        return this.mAstarteInterfaces.keySet();
    }

    public Collection<AstarteInterface> getAllInterfaces() {
        return this.mAstarteInterfaces.values();
    }

    public AstarteInterface getInterface(String interfaceName) {
        return this.mAstarteInterfaces.get(interfaceName);
    }

    public void addGlobalEventListener(AstarteGlobalEventListener eventListener) {
        for (Map.Entry<String, AstarteInterface> interfaceEntry : this.mAstarteInterfaces.entrySet()) {
            AstarteInterface astarteInterface = interfaceEntry.getValue();
            if (astarteInterface instanceof AstarteServerPropertyInterface) {
                ((AstarteServerPropertyInterface)astarteInterface).addListener(eventListener);
                continue;
            }
            if (astarteInterface instanceof AstarteServerDatastreamInterface) {
                ((AstarteServerDatastreamInterface)astarteInterface).addListener(eventListener);
                continue;
            }
            if (!(astarteInterface instanceof AstarteServerAggregateDatastreamInterface)) continue;
            ((AstarteServerAggregateDatastreamInterface)astarteInterface).addListener(eventListener);
        }
    }

    public void removeGlobalListener(AstarteGlobalEventListener eventListener) {
        for (Map.Entry<String, AstarteInterface> interfaceEntry : this.mAstarteInterfaces.entrySet()) {
            AstarteInterface astarteInterface = interfaceEntry.getValue();
            if (astarteInterface instanceof AstarteServerPropertyInterface) {
                ((AstarteServerPropertyInterface)astarteInterface).removeListener(eventListener);
                continue;
            }
            if (astarteInterface instanceof AstarteServerDatastreamInterface) {
                ((AstarteServerDatastreamInterface)astarteInterface).removeListener(eventListener);
                continue;
            }
            if (!(astarteInterface instanceof AstarteServerAggregateDatastreamInterface)) continue;
            ((AstarteServerAggregateDatastreamInterface)astarteInterface).removeListener(eventListener);
        }
    }

    public abstract String getDeviceId();

    public abstract String getAstarteRealm();

    public abstract AstarteMessageListener getAstarteMessageListener();

    public abstract void setAstarteMessageListener(AstarteMessageListener var1);

    public abstract void connect() throws AstarteTransportException, AstarteCryptoException, AstartePairingException;

    public abstract void disconnect() throws AstarteTransportException;

    public abstract boolean isConnected();

    public boolean alwaysReconnects() {
        return this.mAlwaysReconnect;
    }

    public void setAlwaysReconnect(boolean alwaysReconnect) {
        this.mAlwaysReconnect = alwaysReconnect;
    }
}

