/*
 * Decompiled with CFR 0.152.
 */
package org.astarteplatform.devicesdk;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import org.astarteplatform.devicesdk.AstartePairingException;
import org.astarteplatform.devicesdk.AstartePairingService;
import org.astarteplatform.devicesdk.crypto.AstarteCryptoStore;
import org.astarteplatform.devicesdk.transport.AstarteTransport;

public class AstartePairingHandler {
    private final AstartePairingService m_AstartePairingService;
    private final String m_astarteRealm;
    private final String m_deviceId;
    private final String m_credentialSecret;
    final AstarteCryptoStore m_cryptoStore;
    private List<AstarteTransport> m_transports;
    private Certificate m_certificate;

    public AstartePairingHandler(String pairingUrl, String astarteRealm, String deviceId, String credentialSecret, AstarteCryptoStore cryptoStore) {
        this.m_astarteRealm = astarteRealm;
        this.m_deviceId = deviceId;
        this.m_credentialSecret = credentialSecret;
        this.m_cryptoStore = cryptoStore;
        this.m_AstartePairingService = new AstartePairingService(pairingUrl, astarteRealm);
        this.m_certificate = this.m_cryptoStore.getCertificate();
    }

    public void init() throws AstartePairingException {
        this.reloadTransports();
    }

    public List<AstarteTransport> getTransports() {
        return this.m_transports;
    }

    public String getAstarteRealm() {
        return this.m_astarteRealm;
    }

    public String getDeviceId() {
        return this.m_deviceId;
    }

    public Certificate getCertificate() {
        return this.m_certificate;
    }

    public boolean isCertificateAvailable() {
        Certificate certificate = this.m_cryptoStore.getCertificate();
        if (certificate == null) {
            return false;
        }
        if (certificate instanceof X509Certificate) {
            Date notBefore = ((X509Certificate)certificate).getNotBefore();
            Date notAfter = ((X509Certificate)certificate).getNotAfter();
            Date now = new Date();
            return notBefore.before(now) && notAfter.after(now);
        }
        return true;
    }

    private void reloadTransports() throws AstartePairingException {
        this.m_transports = this.m_AstartePairingService.reloadTransports(this.m_credentialSecret, this.m_cryptoStore, this.m_deviceId);
    }

    public void requestNewCertificate() throws AstartePairingException {
        this.m_certificate = this.m_AstartePairingService.requestNewCertificate(this.m_credentialSecret, this.m_cryptoStore, this.m_deviceId);
    }
}

