/*
 * Decompiled with CFR 0.152.
 */
package org.astarteplatform.devicesdk.protocol;

import java.util.Map;
import org.astarteplatform.devicesdk.protocol.AstarteAggregateDataStreamer;
import org.astarteplatform.devicesdk.protocol.AstarteAggregateDatastreamInterface;
import org.astarteplatform.devicesdk.protocol.AstarteInterfaceMapping;
import org.astarteplatform.devicesdk.protocol.AstarteInterfaceMappingNotFoundException;
import org.astarteplatform.devicesdk.protocol.AstarteInvalidValueException;
import org.astarteplatform.devicesdk.transport.AstarteTransport;
import org.astarteplatform.devicesdk.transport.AstarteTransportException;
import org.joda.time.DateTime;

public class AstarteDeviceAggregateDatastreamInterface
extends AstarteAggregateDatastreamInterface
implements AstarteAggregateDataStreamer {
    @Override
    public void streamData(String path, Map<String, Object> payload) throws AstarteTransportException, AstarteInvalidValueException, AstarteInterfaceMappingNotFoundException {
        this.streamData(path, payload, null);
    }

    @Override
    public void streamData(String path, Map<String, Object> payload, DateTime timestamp) throws AstarteTransportException, AstarteInvalidValueException, AstarteInterfaceMappingNotFoundException {
        this.validatePayload(path, payload, timestamp);
        AstarteTransport transport = this.getAstarteTransport();
        if (transport == null) {
            throw new AstarteTransportException("No available transport");
        }
        transport.sendAggregate(this, path, payload, timestamp);
    }

    public void validatePayload(String path, Map<String, Object> payload, DateTime timestamp) throws AstarteInvalidValueException, AstarteInterfaceMappingNotFoundException {
        Map<String, AstarteInterfaceMapping> mappings = this.getMappings();
        String firstMappingPath = mappings.entrySet().iterator().next().getValue().getPath();
        String prefix = firstMappingPath.substring(0, firstMappingPath.lastIndexOf("/"));
        String[] splitMappingPath = prefix.split("/");
        String[] splitPath = path.split("/");
        if (splitPath.length != splitMappingPath.length) {
            throw new AstarteInterfaceMappingNotFoundException(String.format("%s not found in interface", path));
        }
        for (int i = 0; i < splitPath.length; ++i) {
            if (splitPath[i].equals(splitMappingPath[i]) || splitMappingPath[i].startsWith("%{")) continue;
            throw new AstarteInterfaceMappingNotFoundException(String.format("%s not found in interface", path));
        }
        String formattedPath = prefix + "/";
        for (Map.Entry<String, AstarteInterfaceMapping> interfaceMappingEntry : mappings.entrySet()) {
            AstarteInterfaceMapping astarteInterfaceMapping = interfaceMappingEntry.getValue();
            if (payload.containsKey(astarteInterfaceMapping.getPath().substring(formattedPath.length()))) continue;
            throw new AstarteInvalidValueException(String.format("Value not found for %s", astarteInterfaceMapping.getPath()));
        }
        for (Map.Entry<String, Object> data : payload.entrySet()) {
            if (mappings.containsKey(formattedPath + data.getKey())) {
                this.findMappingInInterface(formattedPath + data.getKey()).validatePayload(data.getValue(), timestamp);
                continue;
            }
            throw new AstarteInterfaceMappingNotFoundException(String.format("%s not found in interface", formattedPath + data.getKey()));
        }
    }
}

