/*
 * Decompiled with CFR 0.152.
 */
package org.astarteplatform.devicesdk.protocol;

import org.astarteplatform.devicesdk.AstartePropertyStorage;
import org.astarteplatform.devicesdk.AstartePropertyStorageException;
import org.astarteplatform.devicesdk.protocol.AstarteInterfaceMappingNotFoundException;
import org.astarteplatform.devicesdk.protocol.AstarteInvalidValueException;
import org.astarteplatform.devicesdk.protocol.AstartePropertyInterface;
import org.astarteplatform.devicesdk.protocol.AstartePropertySetter;
import org.astarteplatform.devicesdk.transport.AstarteTransport;
import org.astarteplatform.devicesdk.transport.AstarteTransportException;

public class AstarteDevicePropertyInterface
extends AstartePropertyInterface
implements AstartePropertySetter {
    AstarteDevicePropertyInterface(AstartePropertyStorage propertyStorage) {
        super(propertyStorage);
    }

    @Override
    public void setProperty(String path, Object payload) throws AstarteTransportException, AstarteInvalidValueException, AstarteInterfaceMappingNotFoundException {
        this.validatePayload(path, payload, null);
        AstarteTransport transport = this.getAstarteTransport();
        if (transport == null) {
            throw new AstarteTransportException("No available transport");
        }
        Object storedValue = null;
        if (this.mPropertyStorage != null) {
            try {
                storedValue = this.mPropertyStorage.getStoredValue(this, path);
            }
            catch (AstartePropertyStorageException e) {
                e.printStackTrace();
            }
        }
        if (!payload.equals(storedValue)) {
            transport.sendIndividualValue(this, path, payload);
        }
        if (this.mPropertyStorage != null) {
            try {
                this.mPropertyStorage.setStoredValue(this.getInterfaceName(), path, payload);
            }
            catch (AstartePropertyStorageException e) {
                throw new AstarteTransportException("Property storage failure", e);
            }
        }
    }

    @Override
    public void unsetProperty(String path) throws AstarteTransportException, AstarteInterfaceMappingNotFoundException {
        AstarteTransport transport = this.getAstarteTransport();
        if (transport == null) {
            throw new AstarteTransportException("No available transport");
        }
        transport.sendIndividualValue(this, path, null);
        if (this.mPropertyStorage != null) {
            try {
                this.mPropertyStorage.removeStoredPath(this.getInterfaceName(), path);
            }
            catch (AstartePropertyStorageException e) {
                throw new AstarteTransportException("Property storage failure", e);
            }
        }
    }
}

