/*
 * Decompiled with CFR 0.152.
 */
package org.astarteplatform.devicesdk.protocol;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.astarteplatform.devicesdk.AstartePropertyStorage;
import org.astarteplatform.devicesdk.protocol.AstarteAggregateDatastreamInterface;
import org.astarteplatform.devicesdk.protocol.AstarteDeviceAggregateDatastreamInterface;
import org.astarteplatform.devicesdk.protocol.AstarteDeviceDatastreamInterface;
import org.astarteplatform.devicesdk.protocol.AstarteDevicePropertyInterface;
import org.astarteplatform.devicesdk.protocol.AstarteInterfaceDatastreamMapping;
import org.astarteplatform.devicesdk.protocol.AstarteInterfaceMapping;
import org.astarteplatform.devicesdk.protocol.AstarteInterfaceMappingNotFoundException;
import org.astarteplatform.devicesdk.protocol.AstarteInvalidInterfaceException;
import org.astarteplatform.devicesdk.protocol.AstarteInvalidValueException;
import org.astarteplatform.devicesdk.protocol.AstarteServerAggregateDatastreamInterface;
import org.astarteplatform.devicesdk.protocol.AstarteServerDatastreamInterface;
import org.astarteplatform.devicesdk.protocol.AstarteServerPropertyInterface;
import org.astarteplatform.devicesdk.transport.AstarteTransport;
import org.joda.time.DateTime;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AstarteInterface {
    private String interfaceName;
    private int majorVersion;
    private int minorVersion;
    private Map<String, AstarteInterfaceMapping> mappings;
    private AstarteTransport mAstarteTransport;

    public AstarteTransport getAstarteTransport() {
        return this.mAstarteTransport;
    }

    public void setAstarteTransport(AstarteTransport astarteTransport) {
        this.mAstarteTransport = astarteTransport;
    }

    public static AstarteInterface fromJSON(JSONObject astarteInterfaceObject, AstartePropertyStorage propertyStorage) throws JSONException, AstarteInvalidInterfaceException {
        boolean astarteInterfaceExplicitTimestamp;
        String astarteInterfaceAggregation;
        String astarteInterfaceType = astarteInterfaceObject.getString("type");
        String astarteInterfaceOwnership = astarteInterfaceObject.getString("ownership");
        try {
            astarteInterfaceAggregation = astarteInterfaceObject.getString("aggregation");
        }
        catch (JSONException e) {
            astarteInterfaceAggregation = "individual";
        }
        try {
            astarteInterfaceExplicitTimestamp = astarteInterfaceObject.getBoolean("explicit_timestamp");
        }
        catch (JSONException e) {
            astarteInterfaceExplicitTimestamp = false;
        }
        AstarteInterface astarteInterface = null;
        if (astarteInterfaceType.equals("properties")) {
            if (astarteInterfaceOwnership.equals("device")) {
                astarteInterface = new AstarteDevicePropertyInterface(propertyStorage);
            } else if (astarteInterfaceOwnership.equals("server")) {
                astarteInterface = new AstarteServerPropertyInterface(propertyStorage);
            }
        } else if (astarteInterfaceType.equals("datastream")) {
            AstarteAggregateDatastreamInterface aggregateDatastreamInterface;
            if (astarteInterfaceOwnership.equals("device")) {
                if (astarteInterfaceAggregation.equals("individual")) {
                    astarteInterface = new AstarteDeviceDatastreamInterface();
                } else if (astarteInterfaceAggregation.equals("object")) {
                    aggregateDatastreamInterface = new AstarteDeviceAggregateDatastreamInterface();
                    aggregateDatastreamInterface.explicitTimestamp = astarteInterfaceExplicitTimestamp;
                    astarteInterface = aggregateDatastreamInterface;
                }
            } else if (astarteInterfaceOwnership.equals("server")) {
                if (astarteInterfaceAggregation.equals("individual")) {
                    astarteInterface = new AstarteServerDatastreamInterface();
                } else if (astarteInterfaceAggregation.equals("object")) {
                    aggregateDatastreamInterface = new AstarteServerAggregateDatastreamInterface();
                    aggregateDatastreamInterface.explicitTimestamp = astarteInterfaceExplicitTimestamp;
                    astarteInterface = aggregateDatastreamInterface;
                }
            }
        }
        if (astarteInterface == null) {
            throw new AstarteInvalidInterfaceException("Couldn't parse the interface");
        }
        astarteInterface.interfaceName = astarteInterfaceObject.getString("interface_name");
        astarteInterface.majorVersion = astarteInterfaceObject.getInt("version_major");
        astarteInterface.minorVersion = astarteInterfaceObject.getInt("version_minor");
        if (astarteInterface.majorVersion == 0 && astarteInterface.minorVersion == 0) {
            throw new AstarteInvalidInterfaceException(String.format("Both Major and Minor version are 0 on interface %s", astarteInterface.getInterfaceName()));
        }
        astarteInterface.mappings = new HashMap<String, AstarteInterfaceMapping>();
        JSONArray jsonMappings = astarteInterfaceObject.getJSONArray("mappings");
        for (int i = 0; i < jsonMappings.length(); ++i) {
            if (Objects.equals(astarteInterfaceType, "datastream")) {
                astarteInterface.mappings.put(jsonMappings.getJSONObject(i).getString("endpoint"), AstarteInterfaceDatastreamMapping.fromJSON(jsonMappings.getJSONObject(i)));
                continue;
            }
            astarteInterface.mappings.put(jsonMappings.getJSONObject(i).getString("endpoint"), AstarteInterfaceMapping.fromJSON(jsonMappings.getJSONObject(i)));
        }
        return astarteInterface;
    }

    public AstarteInterfaceMapping findMappingInInterface(String path) throws AstarteInterfaceMappingNotFoundException {
        for (Map.Entry<String, AstarteInterfaceMapping> mappingEntry : this.getMappings().entrySet()) {
            if (!AstarteInterface.isPathCompatibleWithMapping(path, mappingEntry.getKey())) continue;
            return mappingEntry.getValue();
        }
        throw new AstarteInterfaceMappingNotFoundException("Mapping " + path + " not found in interface " + this);
    }

    public void validatePayload(String path, Object payload, DateTime timestamp) throws AstarteInvalidValueException, AstarteInterfaceMappingNotFoundException {
        this.findMappingInInterface(path).validatePayload(payload, timestamp);
    }

    public static boolean isPathCompatibleWithMapping(String path, String mapping) {
        String[] pathTokens;
        String[] mappingTokens = mapping.split("/");
        if (mappingTokens.length != (pathTokens = path.split("/")).length) {
            return false;
        }
        boolean matches = true;
        for (int k = 0; k < mappingTokens.length; ++k) {
            if (mappingTokens[k].contains("%{") || Objects.equals(mappingTokens[k], pathTokens[k])) continue;
            matches = false;
            break;
        }
        return matches;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public Map<String, AstarteInterfaceMapping> getMappings() {
        return this.mappings;
    }
}

